/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ParameterValidator
extends TypeValidator<Parameter> {
    private static final TraceComponent tc = Tr.register(ParameterValidator.class);
    private static final ParameterValidator INSTANCE = new ParameterValidator();

    public static ParameterValidator getInstance() {
        return INSTANCE;
    }

    private ParameterValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Parameter t) {
        if (t != null) {
            String message;
            String message2;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            ValidatorUtils.validateRequiredField(t.getName(), context, "name").ifPresent(helper::addValidationEvent);
            Parameter.In in = t.getIn();
            ValidatorUtils.validateRequiredField(in, context, "in").ifPresent(helper::addValidationEvent);
            if (in != null && in != Parameter.In.COOKIE && in != Parameter.In.HEADER && in != Parameter.In.PATH && in != Parameter.In.QUERY) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterInFieldInvalid", (Object[])new Object[]{in, t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("in"), message2));
            }
            if (t.getExample() != null && t.getExamples() != null && !t.getExamples().isEmpty()) {
                message2 = Tr.formatMessage((TraceComponent)tc, (String)"parameterExampleOrExamples", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message2));
            }
            Schema schema = t.getSchema();
            Content content = t.getContent();
            if (schema == null && content == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaOrContent", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (schema != null && content != null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"parameterSchemaAndContent", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (content != null && content.size() > 1) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"parameterContentMapMustNotBeEmpty", (Object[])new Object[]{t.getName()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("content"), message));
            }
        }
    }
}

