/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigProcessor
implements Closeable {
    private static final TraceComponent tc = Tr.register(ConfigProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String VALIDATION = "mp.openapi.extensions.liberty.validation";
    private static final boolean VALIDATION_DEFAULT_VALUE = true;
    private static final String FILE_POLLING_INTERVAL = "mp.openapi.extensions.liberty.file.polling.interval";
    private static final int FILE_POLLING_INTERVAL_DEFAULT_VALUE = 2;
    private String modelReaderClassName = null;
    private String openAPIFilterClassName = null;
    private boolean scanDisabled = false;
    private boolean validation = true;
    private int pollingInterval = 2;
    private Set<String> classesToScan = null;
    private Set<String> classesToExclude = null;
    private Set<String> packagesToScan = null;
    private Set<String> packagesToExclude = null;
    private Set<String> servers = null;
    private Map<String, Set<String>> pathsServers = null;
    private Map<String, Set<String>> operationsServers = null;
    private Config config;
    static final long serialVersionUID = -707324292652173791L;

    public ConfigProcessor(ClassLoader appClassloader) {
        this.config = ConfigProviderResolver.instance().getBuilder().forClassLoader(appClassloader).addDefaultSources().addDiscoveredConverters().addDiscoveredSources().build();
        this.modelReaderClassName = this.getOptionalValue("mp.openapi.model.reader", String.class, null);
        this.scanDisabled = this.getOptionalValue("mp.openapi.scan.disable", Boolean.class, false);
        this.openAPIFilterClassName = this.getOptionalValue("mp.openapi.filter", String.class, null);
        this.validation = this.getOptionalValue(VALIDATION, Boolean.class, true);
        this.pollingInterval = this.getOptionalValue(FILE_POLLING_INTERVAL, Integer.class, 2, v -> v >= 0);
        this.classesToScan = this.getConfigPropAsSet("mp.openapi.scan.classes");
        this.packagesToScan = this.getConfigPropAsSet("mp.openapi.scan.packages");
        this.classesToExclude = this.getConfigPropAsSet("mp.openapi.scan.exclude.classes");
        this.packagesToExclude = this.getConfigPropAsSet("mp.openapi.scan.exclude.packages");
        this.retrieveServers();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block2: {
            try {
                ((Closeable)this.config).close();
                this.config = null;
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.openapi.ConfigProcessor", (String)"89", (Object)this, (Object[])new Object[0]);
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Failed to close config: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public String getModelReaderClassName() {
        return this.modelReaderClassName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigProcessor : {\n");
        builder.append("mp.openapi.model.reader=" + this.modelReaderClassName + "\n");
        builder.append("mp.openapi.filter=" + this.openAPIFilterClassName + "\n");
        builder.append("mp.openapi.scan.disable=" + this.scanDisabled + "\n");
        builder.append("mp.openapi.extensions.liberty.validation=" + this.validation + "\n");
        builder.append("mp.openapi.extensions.liberty.file.polling.interval=" + this.pollingInterval + "\n");
        builder.append("mp.openapi.scan.classes=" + this.classesToScan + "\n");
        builder.append("mp.openapi.scan.packages=" + this.packagesToScan + "\n");
        builder.append("mp.openapi.scan.exclude.classes=" + this.classesToExclude + "\n");
        builder.append("mp.openapi.scan.exclude.packages=" + this.packagesToExclude + "\n");
        builder.append("mp.openapi.servers=" + this.servers + "\n");
        builder.append("mp.openapi.servers.path.=" + this.pathsServers + "\n");
        builder.append("mp.openapi.servers.operation.=" + this.operationsServers + "\n");
        builder.append("}\n");
        return builder.toString();
    }

    public boolean isScanDisabled() {
        return this.scanDisabled;
    }

    public String getOpenAPIFilterClassName() {
        return this.openAPIFilterClassName;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public int getFilePollingInterval() {
        return this.pollingInterval;
    }

    private <T> T getOptionalValue(String propertyName, Class<T> propertyType, T defaultValue) {
        return this.getOptionalValue(propertyName, propertyType, defaultValue, null);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T getOptionalValue(String propertyName, Class<T> propertyType, T defaultValue, Predicate<? super T> filter) {
        try {
            Optional<Object> optional = this.config.getOptionalValue(propertyName, propertyType);
            if (filter != null) {
                optional = optional.filter(filter);
            }
            return optional.orElse(defaultValue);
        }
        catch (IllegalArgumentException optional) {
            FFDCFilter.processException((Throwable)optional, (String)"com.ibm.ws.microprofile.openapi.ConfigProcessor", (String)"151", (Object)this, (Object[])new Object[]{propertyName, propertyType, defaultValue, filter});
            if (OpenAPIUtils.isEventEnabled(tc)) {
                void e;
                Tr.event((TraceComponent)tc, (String)("Failed to read config: " + e.getMessage()), (Object[])new Object[0]);
            }
            return defaultValue;
        }
    }

    private Set<String> getConfigPropAsSet(String configProperty) {
        String[] configValues = this.getOptionalValue(configProperty, String[].class, null);
        if (configValues == null || configValues.length == 0) {
            return null;
        }
        HashSet<String> configPropSet = new HashSet<String>();
        for (String s : configValues) {
            if (s == null || !StringUtils.isNotBlank((CharSequence)s)) continue;
            configPropSet.add(s);
        }
        if (configPropSet.isEmpty()) {
            return null;
        }
        return configPropSet;
    }

    private void retrieveServers() {
        this.servers = this.getConfigPropAsSet("mp.openapi.servers");
        for (String propertyName : this.config.getPropertyNames()) {
            String path;
            Set<String> servers;
            if (propertyName.startsWith("mp.openapi.servers.path.")) {
                servers = this.getConfigPropAsSet(propertyName);
                if (servers == null || !StringUtils.isNotBlank((CharSequence)(path = propertyName.substring("mp.openapi.servers.path.".length())))) continue;
                if (this.pathsServers == null) {
                    this.pathsServers = new HashMap<String, Set<String>>();
                }
                this.pathsServers.put(path, servers);
                continue;
            }
            if (!propertyName.startsWith("mp.openapi.servers.operation.") || (servers = this.getConfigPropAsSet(propertyName)) == null || !StringUtils.isNotBlank((CharSequence)(path = propertyName.substring("mp.openapi.servers.operation.".length())))) continue;
            if (this.operationsServers == null) {
                this.operationsServers = new HashMap<String, Set<String>>();
            }
            this.operationsServers.put(path, servers);
        }
    }

    public Set<String> getClassesToScan() {
        return this.classesToScan;
    }

    public Set<String> getClassesToExclude() {
        return this.classesToExclude;
    }

    public Set<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public Set<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public Set<String> getServers() {
        return this.servers;
    }

    public Map<String, Set<String>> getPathsServers() {
        return this.pathsServers;
    }

    public Map<String, Set<String>> getOperationsServers() {
        return this.operationsServers;
    }
}

