/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.util.Map;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._asm.MethodVisitor;
import org.apache.commons.weaver.privilizer._asm.commons.Method;
import org.apache.commons.weaver.privilizer._asm.tree.ClassNode;

class InlineNestedPrivilegedCalls
extends ClassNode {
    private final Privilizer privilizer;
    private final ClassVisitor next;
    private final Map<Method, String> privilegedMethods;

    InlineNestedPrivilegedCalls(Privilizer privilizer, Map<Method, String> privilegedMethods, ClassVisitor next) {
        super(327680);
        this.privilizer = privilizer;
        this.privilegedMethods = privilegedMethods;
        this.next = next;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.accept(new VisitEnd());
    }

    private final class VisitEnd
    extends ClassVisitor {
        private VisitEnd() {
            super(327680, InlineNestedPrivilegedCalls.this.next);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Method outer = new Method(name, desc);
            MethodVisitor orig = super.visitMethod(access, name, desc, signature, exceptions);
            if (!InlineNestedPrivilegedCalls.this.privilegedMethods.containsValue(name)) {
                return orig;
            }
            return new VisitMethod(orig, outer);
        }

        private final class VisitMethod
        extends MethodVisitor {
            private final Method outer;

            private VisitMethod(MethodVisitor orig, Method outer) {
                super(327680, orig);
                this.outer = outer;
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                String useName = name;
                if (owner.equals(InlineNestedPrivilegedCalls.this.name)) {
                    Method methd = new Method(name, desc);
                    if (InlineNestedPrivilegedCalls.this.privilegedMethods.containsKey(methd)) {
                        useName = (String)InlineNestedPrivilegedCalls.this.privilegedMethods.get(methd);
                        ((InlineNestedPrivilegedCalls)InlineNestedPrivilegedCalls.this).privilizer.env.debug("Inlining call from %s to %s as %s", this.outer, methd, useName);
                    }
                }
                super.visitMethodInsn(opcode, owner, useName, desc, itf);
            }
        }
    }
}

