/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.health.impl.HealthCheckResponseImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckResponseBuilderImpl
extends HealthCheckResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheckResponseBuilderImpl.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private String name;
    private final Optional<Map<String, Object>> data = Optional.of(new HashMap());
    private HealthCheckResponse.State state;
    static final long serialVersionUID = -1662586321334723636L;

    public HealthCheckResponseBuilder name(String name) {
        this.validateName(name);
        this.name = name;
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, String value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder withData(String key, long value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder withData(String key, boolean value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder up() {
        this.state = HealthCheckResponse.State.UP;
        return this;
    }

    public HealthCheckResponseBuilder down() {
        this.state = HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponseBuilder state(boolean up) {
        this.state = up ? HealthCheckResponse.State.UP : HealthCheckResponse.State.DOWN;
        return this;
    }

    public HealthCheckResponse build() {
        HealthCheckResponseImpl response = new HealthCheckResponseImpl(this.name, this.state, this.data);
        return response;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HealthCheckResponseBuilder: ");
        builder.append("\n\t");
        builder.append("name");
        builder.append(" = ");
        builder.append(this.name);
        builder.append("\n\t");
        builder.append("state");
        builder.append(" = ");
        builder.append(this.state);
        builder.append("\n\t");
        builder.append("data");
        builder.append(" = ");
        builder.append(this.data);
        return builder.toString();
    }

    private HealthCheckResponseBuilder withData(String key, Object value) {
        this.validateKey(key);
        if (this.data.isPresent()) {
            this.data.get().put(key, value);
        }
        return this;
    }

    private void validateName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Name is null", (Object[])new Object[0]));
        }
    }

    private void validateKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Key is null", (Object[])new Object[0]));
        }
    }
}

