/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RLSUtils {
    private static final TraceComponent tc = Tr.register(RLSUtils.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    public static final long STANDARD_RETRY_MAX_INTERVAL_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long STANDARD_RETRY_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final String _digits = "0123456789abcdef";
    public static final int MAX_DISPLAY_BYTES = 32;
    protected static final int BOOLEAN_SIZE = 1;
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int LONG_SIZE = 8;
    protected static final String UNC_HEADER = new String(File.separator + File.separator);
    private static Object _directoryCreationLock = new Object();
    static final long serialVersionUID = -8963847526454294878L;

    public static String toHexString(byte[] byteSource) {
        if (byteSource == null) {
            return "null";
        }
        return RLSUtils.toHexString(byteSource, byteSource.length);
    }

    public static String toHexString(byte[] byteSource, int bytes) {
        StringBuffer result = null;
        boolean truncated = false;
        if (byteSource != null) {
            if (bytes > byteSource.length) {
                bytes = byteSource.length;
            } else if (bytes < byteSource.length) {
                truncated = true;
            }
            result = new StringBuffer(bytes * 2);
            for (int i = 0; i < bytes; ++i) {
                result.append(_digits.charAt(byteSource[i] >> 4 & 0xF));
                result.append(_digits.charAt(byteSource[i] & 0xF));
            }
            if (truncated) {
                result.append("... (" + bytes + "/" + byteSource.length + ")");
            } else {
                result.append("(" + bytes + ")");
            }
        } else {
            result = new StringBuffer("null");
        }
        return result.toString();
    }

    public static String FQHAMCompatibleServerName(String cell, String node, String server) {
        return cell + "\\" + node + "\\" + server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public static boolean createDirectoryTree(String requiredDirectoryTree) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDirectoryTree", (Object[])new Object[]{requiredDirectoryTree});
        }
        boolean exists = true;
        Object object = _directoryCreationLock;
        synchronized (object) {
            File target = new File(requiredDirectoryTree);
            if (!target.exists()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Creating directory tree", (Object[])new Object[]{requiredDirectoryTree});
                }
                Stack<File> pathStack = new Stack<File>();
                while (target != null) {
                    pathStack.push(target);
                    target = target.getParentFile();
                }
                while (!pathStack.empty() && exists) {
                    target = (File)pathStack.pop();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking path to " + target.getAbsolutePath()), (Object[])new Object[0]);
                    }
                    if (!target.exists()) {
                        boolean created;
                        if (target.getAbsolutePath().equals(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Ignoring " + target.getAbsolutePath() + " - is " + UNC_HEADER), (Object[])new Object[0]);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Creating path to " + target.getAbsolutePath()), (Object[])new Object[0]);
                        }
                        if (created = target.mkdirs()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Created path to " + target.getAbsolutePath()), (Object[])new Object[0]);
                            continue;
                        }
                        if (target.getAbsolutePath().startsWith(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Ignoring " + target.getAbsolutePath() + " - starts with " + UNC_HEADER), (Object[])new Object[0]);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Did not create path to " + target.getAbsolutePath()), (Object[])new Object[0]);
                        }
                        if (!target.exists()) {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Unable to create directory tree", (Object[])new Object[0]);
                            }
                            exists = false;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Path to " + target.getAbsolutePath() + " already exists"), (Object[])new Object[0]);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Path to " + target.getAbsolutePath() + " already exists"), (Object[])new Object[0]);
                }
            }
            if (exists && !target.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Did not create path to " + target.getAbsolutePath()), (Object[])new Object[0]);
                }
                exists = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDirectoryTree", (Object)exists);
        }
        return exists;
    }

    public static boolean retry(Operation op, long fullRetryNs) throws Exception {
        if (op.act()) {
            return true;
        }
        if (fullRetryNs == 0L) {
            return false;
        }
        if (fullRetryNs < 0L) {
            throw new IllegalArgumentException("Full retry interval (" + fullRetryNs + ") is less then 0");
        }
        long finalNs = System.nanoTime() + fullRetryNs;
        do {
            RLSUtils.sleep(STANDARD_RETRY_INTERVAL_NS);
            if (!op.act()) continue;
            return true;
        } while (System.nanoTime() < finalNs);
        return false;
    }

    private static long sleep(long requestedNs) throws InterruptedException {
        long startNs = System.nanoTime();
        long elapsedNs = 0L;
        long remainingNs = requestedNs;
        while (remainingNs > 0L) {
            TimeUnit.NANOSECONDS.sleep(remainingNs);
            elapsedNs = System.nanoTime() - startNs;
            remainingNs = requestedNs - elapsedNs;
        }
        return elapsedNs;
    }

    @ManualTrace
    public static boolean deleteDirectory(File dir) {
        File[] files;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteDirectory", (Object[])new Object[]{dir.getAbsolutePath()});
        }
        if (!dir.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirectory", (Object)true);
            }
            return true;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                if (RLSUtils.deleteDirectory(file)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"deleteDirectory", (Object)false);
                }
                return false;
            }
            if (RLSUtils.deleteFile(file)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteDirectory", (Object)false);
            }
            return false;
        }
        boolean ret = RLSUtils.deleteFile(dir);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirectory", (Object)ret);
        }
        return ret;
    }

    @ManualTrace
    private static boolean deleteFile(File file) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteFile", (Object[])new Object[]{file.getAbsolutePath()});
        }
        Path path = file.toPath();
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"deleteFile", (Object)true);
                }
                return true;
            }
            boolean ret = Files.deleteIfExists(path);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteFile", (Object)ret);
            }
            return ret;
        }
        catch (IOException ret) {
            FFDCFilter.processException((Throwable)ret, (String)"com.ibm.ws.recoverylog.spi.RLSUtils", (String)"390", null, (Object[])new Object[]{file});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"deleteFile", (Object)false);
            }
            return false;
        }
    }

    @ManualTrace
    public static void archiveAndDeleteDirectoryTree(File directoryToBeDeleted) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"archiveAndDeleteDirectoryTree", (Object[])new Object[]{directoryToBeDeleted.getAbsolutePath()});
        }
        String trashDir = directoryToBeDeleted.getParent() + File.separator + ".trash";
        RLSUtils.createDirectoryTree(trashDir);
        File to = new File(trashDir + File.separator + directoryToBeDeleted.getName());
        directoryToBeDeleted.renameTo(to);
        File trashDirFile = new File(trashDir);
        for (File file : trashDirFile.listFiles()) {
            RLSUtils.deleteDirectoryTreeTrash(file);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"archiveAndDeleteDirectoryTree");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static void deleteDirectoryTreeTrash(File directoryToBeDeleted) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"deleteDirectoryTreeTrash", (Object[])new Object[]{directoryToBeDeleted.getAbsolutePath()});
            }
            Path rootPath = Paths.get(directoryToBeDeleted.getAbsolutePath(), new String[0]);
            try {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    static final long serialVersionUID = 6491542725365808215L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        block3: {
                            if (tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"deleting file ", (Object[])new Object[]{file.toString()});
                            }
                            try {
                                Files.delete(file);
                            }
                            catch (IOException iOException) {
                                void e;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.RLSUtils$1", (String)"438", (Object)this, (Object[])new Object[]{file, attrs});
                                if (!tc.isDebugEnabled()) break block3;
                                Tr.debug((TraceComponent)tc, (String)"visitFile: failed to delete because:", (Object[])new Object[]{e});
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        block3: {
                            if (tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"deleting dir ", (Object[])new Object[]{dir.toString()});
                            }
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException iOException) {
                                void e;
                                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.RLSUtils$1", (String)"451", (Object)this, (Object[])new Object[]{dir, exc});
                                if (!tc.isDebugEnabled()) break block3;
                                Tr.debug((TraceComponent)tc, (String)"postVisitDirectory: failed to delete because:", (Object[])new Object[]{e});
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.RLSUtils$1", 1.class, null, null);
                    }
                });
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.RLSUtils", (String)"458", null, (Object[])new Object[]{directoryToBeDeleted});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"deleteDirectoryTreeTrash: failed to delete because:", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteDirectoryTreeTrash");
        }
    }

    public static interface Operation {
        public boolean act() throws Exception;
    }
}

