/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RLSAccessFile
extends RandomAccessFile {
    private static final TraceComponent tc = Tr.register(RLSAccessFile.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static HashMap<File, RLSAccessFile> _accessFiles = new HashMap();
    private int _useCount;
    private final File _file;
    static final long serialVersionUID = -5293758300638995834L;

    @ManualTrace
    RLSAccessFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RLSAccessFile", (Object[])new Object[]{file, mode});
        }
        this._useCount = 1;
        this._file = file;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RLSAccessFile", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[]{this, this._file});
        }
        Class<RLSAccessFile> clazz = RLSAccessFile.class;
        synchronized (RLSAccessFile.class) {
            --this._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"remaining file use count", (Object[])new Object[]{this._useCount});
            }
            if (tc.isDebugEnabled() && this._useCount <= 0) {
                Tr.debug((TraceComponent)tc, (String)"call stack", (Object[])new Object[]{new Exception("Dummy traceback")});
            }
            if (this._useCount == 0) {
                super.close();
                _accessFiles.remove(this._file);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"close");
            }
            return;
        }
    }

    @ManualTrace
    public boolean delete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete", (Object[])new Object[]{this, this._file});
        }
        boolean deleted = this._file.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete", (Object)deleted);
        }
        return deleted;
    }

    @ManualTrace
    static synchronized RLSAccessFile getRLSAccessFile(File file) throws FileNotFoundException {
        RLSAccessFile raf;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRLSAccessFile", (Object[])new Object[]{file});
        }
        if ((raf = _accessFiles.get(file)) == null) {
            raf = new RLSAccessFile(file, "rw");
            _accessFiles.put(file, raf);
        } else {
            ++raf._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"total file use count", (Object[])new Object[]{raf._useCount});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRLSAccessFile", (Object)raf);
        }
        return raf;
    }
}

