/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import java.util.ArrayList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PeerLeaseTable {
    private static final TraceComponent tc = Tr.register(PeerLeaseTable.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected final ArrayList<PeerLeaseData> _peerLeaseTable;
    static final long serialVersionUID = 8555422199438478969L;

    @ManualTrace
    public PeerLeaseTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PeerLeaseTable", (Object[])new Object[0]);
        }
        this._peerLeaseTable = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PeerLeaseTable");
        }
    }

    @ManualTrace
    public void addPeerEntry(PeerLeaseData leaseData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addPeerEntry", (Object[])new Object[]{leaseData});
        }
        this._peerLeaseTable.add(leaseData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addPeerEntry");
        }
    }

    @ManualTrace
    public ArrayList<String> getExpiredPeers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getExpiredPeers", (Object[])new Object[0]);
        }
        ArrayList<String> peersToRecover = new ArrayList<String>();
        for (PeerLeaseData p : this._peerLeaseTable) {
            if (!p.isExpired()) continue;
            peersToRecover.add(p.getRecoveryIdentity());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getExpiredPeers", peersToRecover);
        }
        return peersToRecover;
    }

    public int size() {
        return this._peerLeaseTable.size();
    }

    public void clear() {
        this._peerLeaseTable.clear();
    }
}

