/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.bval.ConstructorAccess;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;

public class MetaConstraint<T, A extends Annotation> {
    private final Member member;
    private final Class<T> beanClass;
    private final A annotation;
    private Integer index;
    private final AccessStrategy accessStrategy;

    public MetaConstraint(Class<T> beanClass, Member member, A annotation) {
        this.member = member;
        this.beanClass = beanClass;
        this.annotation = annotation;
        this.accessStrategy = member != null ? MetaConstraint.createAccessStrategy(member) : null;
    }

    private static AccessStrategy createAccessStrategy(Member member) {
        if (member instanceof Method) {
            return new MethodAccess((Method)member);
        }
        if (member instanceof Field) {
            return new FieldAccess((Field)member);
        }
        if (member instanceof Constructor) {
            return new ConstructorAccess((Constructor)member);
        }
        return null;
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public Member getMember() {
        return this.member;
    }

    public A getAnnotation() {
        return this.annotation;
    }

    public AccessStrategy getAccessStrategy() {
        return this.accessStrategy;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

