/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.common.auth.module;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.helper.AuthenticateUserHelper;
import com.ibm.ws.security.authentication.jaas.modules.LoginModuleHelper;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IdentityAssertionLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(IdentityAssertionLoginModule.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    private static final String KEY_TRUST_STATE = "com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.state";
    private static final String KEY_PRINCIPAL = "com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.principal";
    private static final String KEY_CERTIFICATES = "com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.certificates";
    private static final String KEY_TRUSTED = "com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule.trusted";
    private Subject subject;
    private Map sharedState;
    protected Subject temporarySubject;
    private Principal trustedPrincipal;
    private X509Certificate[] certificateChain;
    private String username;
    private UserRegistry userRegistry;
    static final long serialVersionUID = 640671690103067063L;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.sharedState = sharedState;
    }

    @Override
    @FFDCIgnore(value={WSLoginFailedException.class})
    public boolean login() throws WSLoginFailedException {
        try {
            this.userRegistry = this.getUserRegistry();
            Map trustState = (Map)this.sharedState.get(KEY_TRUST_STATE);
            this.setUserNameFromDataInTrustState(trustState);
            this.setUpTemporarySubject();
        }
        catch (WSLoginFailedException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule", (String)"134", (Object)this, (Object[])new Object[0]);
            throw new WSLoginFailedException(e.getLocalizedMessage());
        }
        return true;
    }

    private void setUserNameFromDataInTrustState(Map trustState) throws WSLoginFailedException {
        this.validateTrust(trustState);
        this.trustedPrincipal = (Principal)trustState.get(KEY_PRINCIPAL);
        this.certificateChain = (X509Certificate[])trustState.get(KEY_CERTIFICATES);
        this.validateSufficientData();
        this.setUserName();
    }

    private void validateTrust(Map trustState) throws WSLoginFailedException {
        if (trustState == null || !((Boolean)trustState.get(KEY_TRUSTED)).booleanValue()) {
            throw new WSLoginFailedException("No Trust information for trust validation.");
        }
        Boolean trusted = (Boolean)trustState.get(KEY_TRUSTED);
        if (trusted == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Missing a trust key", (Object[])new Object[0]);
            }
            throw new WSLoginFailedException("No Trust Validator configured for trust validation, identity assertion is disabled.");
        }
        if (!trusted.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"trust is false", (Object[])new Object[0]);
            }
            throw new WSLoginFailedException("No Trust established for trust validation, identity assertion is disabled.");
        }
    }

    private void validateSufficientData() throws WSLoginFailedException {
        if (this.trustedPrincipal == null && !(this.certificateChain != null && this.certificateChain.length != 0)) {
            throw new WSLoginFailedException("No principal or X509Certificate provided to login new user with.");
        }
    }

    private void setUserName() throws WSLoginFailedException {
        this.username = this.getUserNameFromPrincipal();
        if (this.username == null) {
            this.username = this.getUserNameFromCertificate();
        }
    }

    private String getUserNameFromPrincipal() {
        int realmDelimiterIndex;
        String name = null;
        if (this.trustedPrincipal != null && (name = this.trustedPrincipal.getName()) != null && (realmDelimiterIndex = name.lastIndexOf("/")) >= 0) {
            name = name.substring(realmDelimiterIndex + 1);
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserNameFromCertificate() throws WSLoginFailedException {
        String name = null;
        try {
            name = this.userRegistry.mapCertificate(this.certificateChain);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule", (String)"200", (Object)this, (Object[])new Object[0]);
            throw new WSLoginFailedException(e.getLocalizedMessage());
        }
        return name;
    }

    private void setUpTemporarySubject() throws Exception {
        AuthenticateUserHelper authenticateUserHelper = new AuthenticateUserHelper();
        AuthenticationService authenticationService = this.getAuthenticationService();
        this.temporarySubject = authenticateUserHelper.authenticateUser(authenticationService, this.username, "system.DEFAULT");
    }

    @Override
    public boolean commit() throws WSLoginFailedException {
        if (this.temporarySubject == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Authentication did not occur for this login module, abstaining.", (Object[])new Object[0]);
            }
            return false;
        }
        this.setUpSubject();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void setUpSubject() throws WSLoginFailedException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                static final long serialVersionUID = -4235717761535206731L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() throws Exception {
                    IdentityAssertionLoginModule.this.updateSubjectWithTemporarySubjectContents();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule$1", 1.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule", (String)"252", (Object)this, (Object[])new Object[0]);
            throw new WSLoginFailedException("Unable to setup the Subject: " + e.getLocalizedMessage());
        }
    }

    protected void updateSubjectWithTemporarySubjectContents() {
        this.subject.getPrincipals().addAll(this.temporarySubject.getPrincipals());
        this.subject.getPublicCredentials().addAll(this.temporarySubject.getPublicCredentials());
        this.subject.getPrivateCredentials().addAll(this.temporarySubject.getPrivateCredentials());
    }

    @Override
    public boolean abort() throws LoginException {
        this.cleanUpSubject();
        this.username = null;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.cleanUpSubject();
        this.username = null;
        return true;
    }

    private UserRegistry getUserRegistry() throws RegistryException {
        return LoginModuleHelper.getJAASService().getUserRegistry();
    }

    private AuthenticationService getAuthenticationService() {
        return LoginModuleHelper.getJAASService().getAuthenticationService();
    }

    private void cleanUpSubject() {
        if (this.temporarySubject != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){
                static final long serialVersionUID = -8043289216984870743L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Object run() {
                    IdentityAssertionLoginModule.this.subject.getPrincipals().removeAll(IdentityAssertionLoginModule.this.temporarySubject.getPrincipals());
                    IdentityAssertionLoginModule.this.subject.getPublicCredentials().removeAll(IdentityAssertionLoginModule.this.temporarySubject.getPublicCredentials());
                    IdentityAssertionLoginModule.this.subject.getPrivateCredentials().removeAll(IdentityAssertionLoginModule.this.temporarySubject.getPrivateCredentials());
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.wsspi.security.common.auth.module.IdentityAssertionLoginModule$2", 2.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
                }
            });
        }
        this.temporarySubject = null;
    }
}

