/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.InvalidBuilderException;
import com.ibm.websphere.security.jwt.InvalidClaimException;
import com.ibm.websphere.security.jwt.JwtBuilder;
import com.ibm.websphere.security.jwt.JwtException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.token.propagation.TokenPropagationHelper;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtHeaderInjecter
implements ClientRequestFilter {
    private static final TraceComponent tc = Tr.register(JwtHeaderInjecter.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    String jwt = null;
    String header = null;
    static final long serialVersionUID = 2728061604613562776L;

    public void filter(ClientRequestContext requestContext) {
        if (requestContext == null || this.jwt == null || requestContext.getHeaders().containsKey((Object)"Authorization")) {
            return;
        }
        if (this.header == null || this.header.equals("")) {
            this.header = "Authorization";
        }
        String headerValue = "Authorization".equals(this.header) ? "Bearer " + this.jwt : this.jwt;
        requestContext.getHeaders().add((Object)this.header, (Object)headerValue);
    }

    public JwtHeaderInjecter() throws Exception {
        this.jwt = TokenPropagationHelper.getJwtToken();
        if (this.jwt == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_PROPAGATION_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new Exception(msg);
        }
    }

    public JwtHeaderInjecter(String headername) throws Exception {
        this.header = headername;
        this.jwt = TokenPropagationHelper.getJwtToken();
        if (this.jwt == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_PROPAGATION_INVALID_TOKEN_ERR", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new Exception(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JwtHeaderInjecter(String headername, String builder) throws Exception {
        this.header = headername;
        try {
            String sub = TokenPropagationHelper.getUserName();
            JwtToken token = JwtBuilder.create(builder).subject(sub).buildJwt();
            this.jwt = token.compact();
        }
        catch (InvalidBuilderException sub) {
            void e;
            FFDCFilter.processException((Throwable)sub, (String)"com.ibm.websphere.security.jwt.JwtHeaderInjecter", (String)"146", (Object)this, (Object[])new Object[]{headername, builder});
            throw e;
        }
        catch (JwtException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.security.jwt.JwtHeaderInjecter", (String)"148", (Object)this, (Object[])new Object[]{headername, builder});
            throw e;
        }
        catch (InvalidClaimException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.websphere.security.jwt.JwtHeaderInjecter", (String)"150", (Object)this, (Object[])new Object[]{headername, builder});
            throw e;
        }
    }
}

