/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MediaTypeHeaderProvider
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    private static final TraceComponent tc = Tr.register(MediaTypeHeaderProvider.class, null, null);
    private static final String STRICT_MEDIA_TYPE_CHECK = "org.apache.cxf.jaxrs.mediaTypeCheck.strict";
    private static final Pattern COMPLEX_PARAMETERS = Pattern.compile("(([\\w-]+=\"[^\"]*\")|([\\w-]+=[\\w-/\\+]+))");
    private static Map<String, MediaType> map = new ConcurrentHashMap<String, MediaType>();
    private static final int MAX_MT_CACHE_SIZE = SystemPropertyAction.getInteger("org.apache.cxf.jaxrs.max_mediatype_cache_size", 200);
    static final long serialVersionUID = 1428929707513644497L;

    public MediaType fromString(String mType) {
        return MediaTypeHeaderProvider.valueOf(mType);
    }

    public static MediaType valueOf(String mType) {
        if (mType == null) {
            throw new IllegalArgumentException("Media type value can not be null");
        }
        MediaType result = map.get(mType);
        if (result == null) {
            result = MediaTypeHeaderProvider.internalValueOf(mType);
            int size = map.size();
            if (size >= MAX_MT_CACHE_SIZE) {
                map.clear();
            }
            map.put(mType, result);
        }
        return result;
    }

    public static MediaType internalValueOf(String mType) {
        Map<String, String> parameters;
        String subtype;
        String type;
        block7: {
            int i = mType.indexOf(47);
            if (i == -1) {
                return MediaTypeHeaderProvider.handleMediaTypeWithoutSubtype(mType.trim());
            }
            if (i == 0) {
                throw new IllegalArgumentException("Invalid media type string: " + mType);
            }
            int paramsStart = mType.indexOf(59, i + 1);
            int end = paramsStart == -1 ? mType.length() : paramsStart;
            type = mType.substring(0, i);
            subtype = mType.substring(i + 1, end);
            if (!MediaTypeHeaderProvider.isValid(type) || !MediaTypeHeaderProvider.isValid(subtype)) {
                throw new IllegalArgumentException("Failure parsing MediaType string: " + type);
            }
            parameters = Collections.emptyMap();
            if (paramsStart == -1) break block7;
            parameters = new LinkedHashMap();
            String paramString = mType.substring(paramsStart + 1);
            if (paramString.contains("\"")) {
                Matcher m = COMPLEX_PARAMETERS.matcher(paramString);
                while (m.find()) {
                    String val = m.group().trim();
                    MediaTypeHeaderProvider.addParameter(parameters, val);
                }
            } else {
                StringTokenizer st = new StringTokenizer(paramString, ";");
                while (st.hasMoreTokens()) {
                    MediaTypeHeaderProvider.addParameter(parameters, st.nextToken());
                }
            }
        }
        return new MediaType(type.trim().toLowerCase(), subtype.trim().toLowerCase(), parameters);
    }

    private static void addParameter(Map<String, String> parameters, String token) {
        int equalSign = token.indexOf(61);
        if (equalSign == -1) {
            throw new IllegalArgumentException("Wrong media type parameter, separator is missing");
        }
        parameters.put(token.substring(0, equalSign).trim().toLowerCase(), token.substring(equalSign + 1).trim());
    }

    @Trivial
    public String toString(MediaType type) {
        return MediaTypeHeaderProvider.typeToString(type);
    }

    @Trivial
    public static String typeToString(MediaType type) {
        return MediaTypeHeaderProvider.typeToString(type, null);
    }

    @Trivial
    public static String typeToString(MediaType type, List<String> ignoreParams) {
        if (type == null) {
            throw new IllegalArgumentException("MediaType parameter is null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(type.getType()).append('/').append(type.getSubtype());
        Map params = type.getParameters();
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                if (ignoreParams != null && ignoreParams.contains(entry.getKey())) continue;
                sb.append(';').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
        }
        return sb.toString();
    }

    private static MediaType handleMediaTypeWithoutSubtype(String mType) {
        String mTypeNext;
        boolean mTypeNextEmpty;
        if (mType.startsWith("*") && ((mTypeNextEmpty = StringUtils.isEmpty(mTypeNext = mType.length() == 1 ? "" : mType.substring(1).trim())) || mTypeNext.startsWith(";"))) {
            if (!mTypeNextEmpty) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                StringTokenizer st = new StringTokenizer(mType.substring(2).trim(), ";");
                while (st.hasMoreTokens()) {
                    MediaTypeHeaderProvider.addParameter(parameters, st.nextToken());
                }
                return new MediaType("*", "*", parameters);
            }
            return MediaType.WILDCARD_TYPE;
        }
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && !MessageUtils.isTrue(message.getContextualProperty(STRICT_MEDIA_TYPE_CHECK))) {
            MediaType mt = null;
            mt = mType.equals(MediaType.TEXT_PLAIN_TYPE.getType()) ? MediaType.TEXT_PLAIN_TYPE : (mType.equals(MediaType.APPLICATION_XML_TYPE.getSubtype()) ? MediaType.APPLICATION_XML_TYPE : MediaType.WILDCARD_TYPE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Converting a malformed media type '" + mType + "' to '" + MediaTypeHeaderProvider.typeToString(mt) + "'"), (Object[])new Object[0]);
            }
            return mt;
        }
        throw new IllegalArgumentException("Media type separator is missing");
    }

    private static boolean isValid(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': {
                    return false;
                }
            }
        }
        return true;
    }
}

