/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.InvocationCallback;
import org.apache.cxf.endpoint.ClientCallback;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JaxrsClientCallback<T>
extends ClientCallback {
    private final InvocationCallback<T> handler;
    private final Type outType;
    private final Class<?> responseClass;
    static final long serialVersionUID = 5632776126606258379L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JaxrsClientCallback(InvocationCallback<T> handler, Class<?> responseClass, Type outGenericType) {
        this.handler = handler;
        this.outType = outGenericType;
        this.responseClass = responseClass;
    }

    public InvocationCallback<T> getHandler() {
        return this.handler;
    }

    public Type getOutGenericType() {
        return this.outType;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean result = super.cancel(mayInterruptIfRunning);
        if (result && this.handler != null) {
            this.handler.failed((Throwable)new CancellationException());
        }
        return result;
    }

    public Future<T> createFuture() {
        return new JaxrsResponseFuture(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        this.context = ctx;
        this.result = res;
        if (this.handler != null) {
            this.handler.completed(res[0]);
        }
        this.done = true;
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        this.context = ctx;
        this.exception = ex;
        if (this.handler != null) {
            this.handler.failed(this.exception);
        }
        this.done = true;
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            this.notifyAll();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.JaxrsClientCallback", JaxrsClientCallback.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    static class JaxrsResponseFuture<T>
    implements Future<T> {
        JaxrsClientCallback<T> callback;
        static final long serialVersionUID = 5368569724382723174L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JaxrsResponseFuture(JaxrsClientCallback<T> cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.getObject(this.callback.get()[0]);
            }
            catch (InterruptedException ex) {
                if (((JaxrsClientCallback)this.callback).handler != null) {
                    ((JaxrsClientCallback)this.callback).handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.getObject(this.callback.get(timeout, unit)[0]);
            }
            catch (InterruptedException ex) {
                if (((JaxrsClientCallback)this.callback).handler != null) {
                    ((JaxrsClientCallback)this.callback).handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        private T getObject(Object object) {
            return (T)object;
        }

        @Override
        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.callback.isDone();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.client.JaxrsClientCallback$JaxrsResponseFuture", JaxrsResponseFuture.class, null, null);
        }
    }
}

