/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObjectState;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionServices;
import com.ibm.ws.cdi.internal.interfaces.WebSphereInjectionTargetListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.weld.construction.api.WeldCreationalContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CDIManagedObject<T>
implements ManagedObject<T>,
WebSphereInjectionTargetListener<T> {
    private static final TraceComponent tc = Tr.register(CDIManagedObject.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private T managedObject;
    private WeldCreationalContext<T> creationalContext = null;
    private javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget = null;
    private boolean lifecycleManaged = false;
    private String beanScope = null;
    private final String identity;
    private WebSphereInjectionServices websphereInjectionServices;
    private Set<InjectionTarget> currentInjectionTargets;
    private InjectionTargetContext currentInjectionContext;
    static final long serialVersionUID = 642874158156701263L;

    public CDIManagedObject(T managedObject, WeldCreationalContext<T> creationalContext, String beanScope, WebSphereInjectionServices websphereInjectionServices) {
        this.creationalContext = creationalContext;
        this.managedObject = managedObject;
        this.beanScope = beanScope;
        this.websphereInjectionServices = websphereInjectionServices;
        this.identity = Util.identity(this.managedObject);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.identity + " creating --> " + Util.identity(this.creationalContext) + " beanscope: " + beanScope), (Object[])new Object[0]);
        }
    }

    public CDIManagedObject(T managedObject, WeldCreationalContext<T> creationalContext, javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget, String beanScope, WebSphereInjectionServices websphereInjectionServices) {
        this(managedObject, creationalContext, beanScope, websphereInjectionServices);
        this.injectionTarget = injectionTarget;
        this.lifecycleManaged = this.injectionTarget != null;
    }

    public <K> K getContextData(Class<K> klass) {
        if (klass == WeldCreationalContext.class) {
            return klass.cast(this.creationalContext);
        }
        return null;
    }

    public T getObject() {
        return this.managedObject;
    }

    public ManagedObjectContext getContext() {
        return new CDIManagedObjectState(this.creationalContext);
    }

    /*
     * WARNING - void declaration
     */
    public void release() {
        if (null != this.creationalContext) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.identity + " releasing --> " + Util.identity(this.creationalContext)), (Object[])new Object[0]);
            }
            if (this.injectionTarget != null) {
                block5: {
                    try {
                        this.injectionTarget.preDestroy(this.managedObject);
                    }
                    catch (Throwable throwable) {
                        void t;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.cdi.impl.managedobject.CDIManagedObject", (String)"94", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)(this.identity + " preDestroy exception --> " + t), (Object[])new Object[0]);
                    }
                }
                this.injectionTarget.dispose(this.managedObject);
                this.injectionTarget = null;
            }
            this.creationalContext.release();
            this.creationalContext = null;
            this.managedObject = null;
        }
    }

    public boolean isLifecycleManaged() {
        return this.lifecycleManaged;
    }

    public String getBeanScope() {
        return this.beanScope;
    }

    public String toString() {
        String released = this.creationalContext == null ? " (RELEASED)" : "";
        return "CDIManagedObject: " + this.identity + released;
    }

    /*
     * WARNING - void declaration
     */
    public T inject(ReferenceContext referenceContext) throws ManagedObjectException {
        T instance = this.getObject();
        if (referenceContext == null) {
            instance = this.cdiInjection(instance);
        } else {
            InjectionTarget[] injectionTargets;
            try {
                injectionTargets = referenceContext.getInjectionTargets(instance.getClass());
            }
            catch (InjectionException injectionException) {
                void e;
                FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.cdi.impl.managedobject.CDIManagedObject", (String)"142", (Object)this, (Object[])new Object[]{referenceContext});
                throw new ManagedObjectException((Throwable)e);
            }
            InjectionTargetContext injectionContext = new InjectionTargetContext(){
                static final long serialVersionUID = -5767132127582061148L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public <S> S getInjectionTargetContextData(Class<S> data) {
                    return CDIManagedObject.this.getContextData(data);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.managedobject.CDIManagedObject$1", 1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
                }
            };
            instance = this.inject(injectionTargets, injectionContext);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T inject(InjectionTarget[] targets, InjectionTargetContext injectionContext) throws ManagedObjectException {
        T instance = this.getObject();
        CDIManagedObject cDIManagedObject = this;
        synchronized (cDIManagedObject) {
            try {
                this.currentInjectionTargets = new HashSet<InjectionTarget>();
                this.currentInjectionContext = injectionContext;
                this.websphereInjectionServices.registerInjectionTargetListener((WebSphereInjectionTargetListener)this);
                for (InjectionTarget it : targets) {
                    this.currentInjectionTargets.add(it);
                }
                instance = this.cdiInjection(instance);
                Iterator<InjectionTarget> iterator = this.currentInjectionTargets.iterator();
                while (iterator.hasNext()) {
                    InjectionTarget it = (InjectionTarget)iterator.next();
                    if (it.getInjectionBinding().getAnnotationType() == Inject.class) continue;
                    try {
                        it.inject(instance, injectionContext);
                    }
                    catch (InjectionException injectionException) {
                        void e;
                        FFDCFilter.processException((Throwable)injectionException, (String)"com.ibm.ws.cdi.impl.managedobject.CDIManagedObject", (String)"183", (Object)this, (Object[])new Object[]{targets, injectionContext});
                        throw new ManagedObjectException((Throwable)e);
                    }
                }
                return instance;
            }
            finally {
                this.websphereInjectionServices.deregisterInjectionTargetListener((WebSphereInjectionTargetListener)this);
                this.currentInjectionContext = null;
                this.currentInjectionTargets = null;
            }
        }
    }

    private T cdiInjection(T instance) {
        this.injectionTarget.inject(instance, this.creationalContext);
        return instance;
    }

    public void injectionTargetProcessed(InjectionTarget injectionTarget) {
        this.currentInjectionTargets.remove(injectionTarget);
    }

    public InjectionTargetContext getCurrentInjectionTargetContext() {
        return this.currentInjectionContext;
    }
}

