/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.stat.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.stat.CachePerf;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CacheStatsModule
extends StatisticActions
implements CachePerf {
    private static TraceComponent tc = Tr.register(CacheStatsModule.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final String templateCount2 = "/com/ibm/websphere/pmi/xml/cacheModule_root.xml";
    private static final String templateCount15 = "/com/ibm/websphere/pmi/xml/cacheModule_template.xml";
    private static final String templateCount13 = "/com/ibm/websphere/pmi/xml/cacheModule_disk.xml";
    public static final int TYPE_UNDETERMINED = 0;
    public static final int TYPE_SERVLET = 1;
    public static final int TYPE_OBJECT = 2;
    private static StatsGroup _cacheRootStatsGroup;
    private StatsGroup _cacheTemplateStatsGroup;
    private StatsGroup _cacheDiskStatsGroup;
    private StatsGroup _cacheObjectStatsGroup;
    private StatsInstance _statsInstance = null;
    private CacheStatsModule _csmDisk = null;
    private CacheStatsModule _csmObject = null;
    private String _sCacheName;
    private boolean _diskOffloadEnabled;
    private int _iCacheType = 0;
    protected boolean _enable = true;
    private SPICountStatistic _maxInMemoryCacheEntryCount = null;
    private SPICountStatistic _inMemoryCacheEntryCount = null;
    private SPICountStatistic _objectsOnDisk = null;
    private SPICountStatistic _hitsOnDisk = null;
    private SPICountStatistic _explicitInvalidationsFromDisk = null;
    private SPICountStatistic _timeoutInvalidationsFromDisk = null;
    private SPICountStatistic _pendingRemovalFromDisk = null;
    private SPICountStatistic _dependencyIdsOnDisk = null;
    private SPICountStatistic _dependencyIdsBufferedForDisk = null;
    private SPICountStatistic _dependencyIdsOffloadedToDisk = null;
    private SPICountStatistic _dependencyIdBasedInvalidationsFromDisk = null;
    private SPICountStatistic _templatesOnDisk = null;
    private SPICountStatistic _templatesBufferedForDisk = null;
    private SPICountStatistic _templatesOffloadedToDisk = null;
    private SPICountStatistic _templateBasedInvalidationsFromDisk = null;
    private SPICountStatistic _garbageCollectorInvalidationsFromDisk = null;
    private SPICountStatistic _overflowInvalidationsFromDisk = null;
    private SPICountStatistic _hitsInMemoryCount = null;
    private SPICountStatistic _hitsOnDiskCount = null;
    private SPICountStatistic _explicitInvalidationCount = null;
    private SPICountStatistic _lruInvalidationCount = null;
    private SPICountStatistic _timeoutInvalidationCount = null;
    private SPICountStatistic _inMemoryAndDiskCacheEntryCount = null;
    private SPICountStatistic _remoteHitCount = null;
    private SPICountStatistic _missCount = null;
    private SPICountStatistic _clientRequestCount = null;
    private SPICountStatistic _distributedRequestCount = null;
    private SPICountStatistic _explicitMemoryInvalidationCount = null;
    private SPICountStatistic _explicitDiskInvalidationCount = null;
    private SPICountStatistic _localExplicitInvalidationCount = null;
    private SPICountStatistic _remoteExplicitInvalidationCount = null;
    private SPICountStatistic _remoteCreationCount = null;
    HashMap<String, CacheStatsModule> templatesPassed = new HashMap();
    ArrayList<String> templatesFailed = new ArrayList();

    public CacheStatsModule(String cacheName, boolean swapToDisk) throws StatsFactoryException {
        String methodName = "CacheStatsModule() CTOR #1";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 cacheName=" + cacheName + " offload " + swapToDisk), (Object[])new Object[0]);
        }
        this._sCacheName = cacheName;
        this._diskOffloadEnabled = swapToDisk;
        if (_cacheRootStatsGroup == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 Creating cacheModule group for cacheName=" + this._sCacheName), (Object[])new Object[0]);
            }
            _cacheRootStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule", (String)templateCount2, null, (StatisticActions)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("CacheStatsModule() CTOR #1 _cacheRootStatsGroup=" + _cacheRootStatsGroup + " for cacheName=" + this._sCacheName));
        }
    }

    public void enableServletCacheStats() {
        block7: {
            String methodName = "enableServletCacheStats";
            try {
                if (null == this._statsInstance) {
                    this._iCacheType = 1;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("enableServletCacheStats Creating statistic for " + this._sCacheName + " instance (servlet cache)"), (Object[])new Object[0]);
                    }
                    this._statsInstance = StatsFactory.createStatsInstance((String)("Servlet: " + this._sCacheName), (StatsGroup)_cacheRootStatsGroup, null, (StatisticActions)this);
                    if (this._diskOffloadEnabled) {
                        if (this._cacheDiskStatsGroup == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("enableServletCacheStats Creating disk group for cacheName=" + this._sCacheName), (Object[])new Object[0]);
                            }
                            this._cacheDiskStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.disk", (String)templateCount13, (StatsInstance)this._statsInstance, null, (StatisticActions)this);
                        }
                        this._csmDisk = new CacheStatsModule(this._sCacheName, "cacheModule.diskOffloadEnabled", this._cacheDiskStatsGroup, this);
                    }
                }
            }
            catch (StatsFactoryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.stat.CacheStatsModule", (String)"198", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)("enableServletCacheStats Exception while enabling servlet cache stats template - cacheName=" + this._sCacheName + ": " + ExceptionUtility.getStackTrace((Throwable)e)), (Object[])new Object[0]);
            }
        }
    }

    public void enableObjectCacheStats() {
        block9: {
            String methodName = "enableObjectCacheStats";
            try {
                if (null == this._statsInstance) {
                    this._iCacheType = 2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("enableObjectCacheStats Creating statistic for " + this._sCacheName + " instance (object cache)"), (Object[])new Object[0]);
                    }
                    this._statsInstance = StatsFactory.createStatsInstance((String)("Object: " + this._sCacheName), (StatsGroup)_cacheRootStatsGroup, null, (StatisticActions)this);
                    if (null == this._cacheObjectStatsGroup) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("enableObjectCacheStats Creating object cache group for cacheName=" + this._sCacheName), (Object[])new Object[0]);
                        }
                        this._cacheObjectStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.objectCache", (String)templateCount15, (StatsInstance)this._statsInstance, null, (StatisticActions)this);
                        this._csmObject = new CacheStatsModule(this._sCacheName, "cacheModule.counters", this._cacheObjectStatsGroup, this);
                    }
                    if (this._diskOffloadEnabled) {
                        if (this._cacheDiskStatsGroup == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("enableObjectCacheStats Creating disk group for cacheName=" + this._sCacheName), (Object[])new Object[0]);
                            }
                            this._cacheDiskStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.disk", (String)templateCount13, (StatsInstance)this._statsInstance, null, (StatisticActions)this);
                        }
                        this._csmDisk = new CacheStatsModule(this._sCacheName, "cacheModule.diskOffloadEnabled", this._cacheDiskStatsGroup, this);
                    }
                }
            }
            catch (StatsFactoryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.stat.CacheStatsModule", (String)"176", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("enableObjectCacheStats Exception while enabling object cache stats for" + this._sCacheName + " : " + ExceptionUtility.getStackTrace((Throwable)e)), (Object[])new Object[0]);
            }
        }
    }

    public CacheStatsModule(String cacheName, String template, StatsGroup templateGroup, CacheStatsModule parent) throws StatsFactoryException {
        String methodName = "CacheStatsModule() CTOR #2";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 cacheName=" + cacheName), (Object[])new Object[]{" name/template=" + template});
        }
        this._sCacheName = cacheName;
        this._iCacheType = parent._iCacheType;
        this._diskOffloadEnabled = parent._diskOffloadEnabled;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 Creating statistic for name/template=" + template + " instance for cacheName=" + cacheName), (Object[])new Object[0]);
        }
        this._statsInstance = StatsFactory.createStatsInstance((String)template, (StatsGroup)templateGroup, null, (StatisticActions)this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("CacheStatsModule() CTOR #2 _statsInstance=" + this._statsInstance + " for cacheName=" + cacheName));
        }
    }

    private synchronized CacheStatsModule createTemplateModule(String template) {
        String methodName = "createTemplateModule()";
        CacheStatsModule csm = this.templatesPassed.get(template);
        if (csm == null && !this.templatesFailed.contains(template)) {
            try {
                if (this._cacheTemplateStatsGroup == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createTemplateModule() Creating template group for cacheName=" + this._sCacheName), (Object[])new Object[0]);
                    }
                    this._cacheTemplateStatsGroup = StatsFactory.createStatsGroup((String)"cacheModule.template", (String)templateCount15, (StatsInstance)this._statsInstance, null, (StatisticActions)this);
                }
                csm = new CacheStatsModule(this._sCacheName, template, this._cacheTemplateStatsGroup, this);
                this.templatesPassed.put(template, csm);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.cache.stat.CacheStatsModule", (String)"572", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createTemplateModule() Exception while creating template - cacheName=" + this._sCacheName + " template=" + template + ": " + ExceptionUtility.getStackTrace((Throwable)t)), (Object[])new Object[0]);
                }
                this.templatesFailed.add(template);
                csm = null;
            }
        }
        return csm;
    }

    private CacheStatsModule getCSM(String template) {
        CacheStatsModule csm = null;
        try {
            if (this._iCacheType == 0) {
                if (template == null || template.equals("")) {
                    this.enableObjectCacheStats();
                } else {
                    this.enableServletCacheStats();
                }
            }
            if (this._iCacheType == 1) {
                csm = this.templatesPassed.get(template);
                if (csm == null && null != template) {
                    csm = this.createTemplateModule(template);
                }
            } else if (this._iCacheType == 2) {
                csm = this._csmObject;
            }
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getCSM " + template + " > " + (Object)((Object)csm)), (Object[])new Object[0]);
            }
        }
        return csm;
    }

    public void statisticCreated(SPIStatistic s) {
        String methodName = "statisticCreated()";
        switch (s.getId()) {
            case 1: {
                this._maxInMemoryCacheEntryCount = (SPICountStatistic)s;
                break;
            }
            case 2: {
                this._inMemoryCacheEntryCount = (SPICountStatistic)s;
                break;
            }
            case 21: {
                this._hitsInMemoryCount = (SPICountStatistic)s;
                break;
            }
            case 22: {
                this._hitsOnDiskCount = (SPICountStatistic)s;
                break;
            }
            case 23: {
                this._explicitInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 24: {
                this._lruInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 25: {
                this._timeoutInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 26: {
                this._inMemoryAndDiskCacheEntryCount = (SPICountStatistic)s;
                break;
            }
            case 27: {
                this._remoteHitCount = (SPICountStatistic)s;
                break;
            }
            case 28: {
                this._missCount = (SPICountStatistic)s;
                break;
            }
            case 29: {
                this._clientRequestCount = (SPICountStatistic)s;
                break;
            }
            case 30: {
                this._distributedRequestCount = (SPICountStatistic)s;
                break;
            }
            case 31: {
                this._explicitMemoryInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 32: {
                this._explicitDiskInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 34: {
                this._localExplicitInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 35: {
                this._remoteExplicitInvalidationCount = (SPICountStatistic)s;
                break;
            }
            case 36: {
                this._remoteCreationCount = (SPICountStatistic)s;
                break;
            }
            case 4: {
                this._objectsOnDisk = (SPICountStatistic)s;
                break;
            }
            case 5: {
                this._hitsOnDisk = (SPICountStatistic)s;
                break;
            }
            case 6: {
                this._explicitInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            case 7: {
                this._timeoutInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            case 8: {
                this._pendingRemovalFromDisk = (SPICountStatistic)s;
                break;
            }
            case 9: {
                this._dependencyIdsOnDisk = (SPICountStatistic)s;
                break;
            }
            case 10: {
                this._dependencyIdsBufferedForDisk = (SPICountStatistic)s;
                break;
            }
            case 11: {
                this._dependencyIdsOffloadedToDisk = (SPICountStatistic)s;
                break;
            }
            case 12: {
                this._dependencyIdBasedInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            case 13: {
                this._templatesOnDisk = (SPICountStatistic)s;
                break;
            }
            case 14: {
                this._templatesBufferedForDisk = (SPICountStatistic)s;
                break;
            }
            case 15: {
                this._templatesOffloadedToDisk = (SPICountStatistic)s;
                break;
            }
            case 16: {
                this._templateBasedInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            case 17: {
                this._garbageCollectorInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            case 18: {
                this._overflowInvalidationsFromDisk = (SPICountStatistic)s;
                break;
            }
            default: {
                Tr.debug((TraceComponent)tc, (String)"statisticCreated()", (Object[])new Object[]{"Error - Unknown stats Id for cacheModule cacheName=" + this._sCacheName + " dataID=" + s.getId()});
                assert (false);
                break;
            }
        }
    }

    public void enableStatusChanged(int[] enabled, int[] disabled) {
        String methodName = "enableStatusChanged()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"enableStatusChanged()", (Object[])new Object[]{this._sCacheName, this, enabled, disabled});
        }
        ServerCache.getCache((String)this._sCacheName).refreshCachePerf();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"enableStatusChanged()");
        }
    }

    public void updateStatisticOnRequest(int dataId) {
    }

    public boolean isPMIEnabled() {
        this._enable = StatsFactory.isPMIEnabled();
        return this._enable;
    }

    public void resetPMICounters() {
        String methodName = "resetPMICounters()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resetPMICounters() cacheName=" + this._sCacheName), (Object[])new Object[0]);
        }
        if (this._enable && this._maxInMemoryCacheEntryCount != null) {
            this._maxInMemoryCacheEntryCount.setCount(0L);
        }
        if (this._enable && this._inMemoryCacheEntryCount != null) {
            this._inMemoryCacheEntryCount.setCount(0L);
        }
        if (this._csmDisk != null && this._csmDisk._enable) {
            if (this._csmDisk._objectsOnDisk != null) {
                this._csmDisk._objectsOnDisk.setCount(0L);
            }
            if (this._csmDisk._hitsOnDisk != null) {
                this._csmDisk._hitsOnDisk.setCount(0L);
            }
            if (this._csmDisk._explicitInvalidationsFromDisk != null) {
                this._csmDisk._explicitInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._timeoutInvalidationsFromDisk != null) {
                this._csmDisk._timeoutInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                this._csmDisk._pendingRemovalFromDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                this._csmDisk._dependencyIdsOnDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOffloadedToDisk != null) {
                this._csmDisk._dependencyIdsOffloadedToDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdBasedInvalidationsFromDisk != null) {
                this._csmDisk._dependencyIdBasedInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                this._csmDisk._templatesOnDisk.setCount(0L);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                this._csmDisk._templatesBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOffloadedToDisk != null) {
                this._csmDisk._templatesOffloadedToDisk.setCount(0L);
            }
            if (this._csmDisk._templateBasedInvalidationsFromDisk != null) {
                this._csmDisk._templateBasedInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._garbageCollectorInvalidationsFromDisk != null) {
                this._csmDisk._garbageCollectorInvalidationsFromDisk.setCount(0L);
            }
            if (this._csmDisk._overflowInvalidationsFromDisk != null) {
                this._csmDisk._overflowInvalidationsFromDisk.setCount(0L);
            }
        }
        if (this._iCacheType == 1) {
            for (CacheStatsModule csm : this.templatesPassed.values()) {
                if (csm == null || !csm._enable) continue;
                if (csm._hitsInMemoryCount != null) {
                    csm._hitsInMemoryCount.setCount(0L);
                }
                if (csm._hitsOnDiskCount != null) {
                    csm._hitsOnDiskCount.setCount(0L);
                }
                if (csm._explicitInvalidationCount != null) {
                    csm._explicitInvalidationCount.setCount(0L);
                }
                if (csm._lruInvalidationCount != null) {
                    csm._lruInvalidationCount.setCount(0L);
                }
                if (csm._timeoutInvalidationCount != null) {
                    csm._timeoutInvalidationCount.setCount(0L);
                }
                if (csm._inMemoryAndDiskCacheEntryCount != null) {
                    csm._inMemoryAndDiskCacheEntryCount.setCount(0L);
                }
                if (csm._remoteHitCount != null) {
                    csm._remoteHitCount.setCount(0L);
                }
                if (csm._missCount != null) {
                    csm._missCount.setCount(0L);
                }
                if (csm._clientRequestCount != null) {
                    csm._clientRequestCount.setCount(0L);
                }
                if (csm._distributedRequestCount != null) {
                    csm._distributedRequestCount.setCount(0L);
                }
                if (csm._explicitMemoryInvalidationCount != null) {
                    csm._explicitMemoryInvalidationCount.setCount(0L);
                }
                if (csm._explicitDiskInvalidationCount != null) {
                    csm._explicitDiskInvalidationCount.setCount(0L);
                }
                if (csm._localExplicitInvalidationCount != null) {
                    csm._localExplicitInvalidationCount.setCount(0L);
                }
                if (csm._remoteExplicitInvalidationCount != null) {
                    csm._remoteExplicitInvalidationCount.setCount(0L);
                }
                if (csm._remoteCreationCount == null) continue;
                csm._remoteCreationCount.setCount(0L);
            }
        } else if (this._csmObject != null && this._csmObject._enable) {
            if (this._csmObject._hitsInMemoryCount != null) {
                this._csmObject._hitsInMemoryCount.setCount(0L);
            }
            if (this._csmObject._hitsOnDiskCount != null) {
                this._csmObject._hitsOnDiskCount.setCount(0L);
            }
            if (this._csmObject._explicitInvalidationCount != null) {
                this._csmObject._explicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._lruInvalidationCount != null) {
                this._csmObject._lruInvalidationCount.setCount(0L);
            }
            if (this._csmObject._timeoutInvalidationCount != null) {
                this._csmObject._timeoutInvalidationCount.setCount(0L);
            }
            if (this._csmObject._inMemoryAndDiskCacheEntryCount != null) {
                this._csmObject._inMemoryAndDiskCacheEntryCount.setCount(0L);
            }
            if (this._csmObject._remoteHitCount != null) {
                this._csmObject._remoteHitCount.setCount(0L);
            }
            if (this._csmObject._missCount != null) {
                this._csmObject._missCount.setCount(0L);
            }
            if (this._csmObject._clientRequestCount != null) {
                this._csmObject._clientRequestCount.setCount(0L);
            }
            if (this._csmObject._distributedRequestCount != null) {
                this._csmObject._distributedRequestCount.setCount(0L);
            }
            if (this._csmObject._explicitMemoryInvalidationCount != null) {
                this._csmObject._explicitMemoryInvalidationCount.setCount(0L);
            }
            if (this._csmObject._explicitDiskInvalidationCount != null) {
                this._csmObject._explicitDiskInvalidationCount.setCount(0L);
            }
            if (this._csmObject._localExplicitInvalidationCount != null) {
                this._csmObject._localExplicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._remoteExplicitInvalidationCount != null) {
                this._csmObject._remoteExplicitInvalidationCount.setCount(0L);
            }
            if (this._csmObject._remoteCreationCount != null) {
                this._csmObject._remoteCreationCount.setCount(0L);
            }
        }
    }

    public void updateCacheSizes(long max, long current) {
        String methodName = "updateCacheSizes()";
        if (tc.isDebugEnabled() && null != this._maxInMemoryCacheEntryCount && null != this._inMemoryCacheEntryCount && max != this._maxInMemoryCacheEntryCount.getCount() && this._inMemoryCacheEntryCount.getCount() != current) {
            Tr.debug((TraceComponent)tc, (String)("updateCacheSizes() cacheName=" + this._sCacheName + " max=" + max + " current=" + current + " enable=" + this._enable), (Object[])new Object[]{this});
        }
        if (this._enable) {
            if (this._maxInMemoryCacheEntryCount != null) {
                this._maxInMemoryCacheEntryCount.setCount(max);
            }
            if (this._inMemoryCacheEntryCount != null) {
                this._inMemoryCacheEntryCount.setCount(current);
            }
        }
    }

    public void updateDiskCacheStatistics(long objectsOnDisk, long pendingRemoval, long depidsOnDisk, long depidsBuffered, long depidsOffloaded, long depidBasedInvalidations, long templatesOnDisk, long templatesBuffered, long templatesOffloaded, long templateBasedInvalidations) {
        String methodName = "updateDiskCacheStatistics()";
        boolean anyStatChangedValue = false;
        if (this._csmDisk != null && this._csmDisk._enable) {
            if (this._csmDisk._objectsOnDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._objectsOnDisk, objectsOnDisk);
                }
                this._csmDisk._objectsOnDisk.setCount(objectsOnDisk);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._pendingRemovalFromDisk, pendingRemoval);
                }
                this._csmDisk._pendingRemovalFromDisk.setCount(pendingRemoval);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._dependencyIdsOnDisk, depidsOnDisk);
                }
                this._csmDisk._dependencyIdsOnDisk.setCount(depidsOnDisk);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._dependencyIdsBufferedForDisk, depidsBuffered);
                }
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(depidsBuffered);
            }
            if (this._csmDisk._dependencyIdsOffloadedToDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._dependencyIdsOffloadedToDisk, depidsOffloaded);
                }
                this._csmDisk._dependencyIdsOffloadedToDisk.setCount(depidsOffloaded);
            }
            if (this._csmDisk._dependencyIdBasedInvalidationsFromDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._dependencyIdBasedInvalidationsFromDisk, depidBasedInvalidations);
                }
                this._csmDisk._dependencyIdBasedInvalidationsFromDisk.setCount(depidBasedInvalidations);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._templatesOnDisk, templatesOnDisk);
                }
                this._csmDisk._templatesOnDisk.setCount(templatesOnDisk);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._templatesBufferedForDisk, templatesBuffered);
                }
                this._csmDisk._templatesBufferedForDisk.setCount(templatesBuffered);
            }
            if (this._csmDisk._templatesOffloadedToDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._templatesOffloadedToDisk, templatesOffloaded);
                }
                this._csmDisk._templatesOffloadedToDisk.setCount(templatesOffloaded);
            }
            if (this._csmDisk._templateBasedInvalidationsFromDisk != null) {
                if (!anyStatChangedValue) {
                    anyStatChangedValue = this.anyValueChanged(this._csmDisk._templateBasedInvalidationsFromDisk, templateBasedInvalidations);
                }
                this._csmDisk._templateBasedInvalidationsFromDisk.setCount(templateBasedInvalidations);
            }
            if (tc.isDebugEnabled() && anyStatChangedValue) {
                Tr.debug((TraceComponent)tc, (String)("updateDiskCacheStatistics() cacheName=" + this._sCacheName + " updateCacheStatistics, objectsOnDisk=" + objectsOnDisk + " pendingRemovalFromDisk=" + pendingRemoval + " dependencyIdsOnDisk=" + depidsOnDisk + " dependencyIdsBufferedForDisk=" + depidsBuffered + " dependencyIdsOffloadedToDisk=" + depidsOffloaded + " dependencyIdBasedInvalidations=" + depidBasedInvalidations + " templatesOnDisk=" + templatesOnDisk + " templatesBufferedForDisk=" + templatesBuffered + " templatesOffloadedToDisk=" + templatesOffloaded + " templateBasedInvalidations=" + templateBasedInvalidations + " enable=" + this._csmDisk._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
            }
        }
    }

    private boolean anyValueChanged(SPICountStatistic s, long passedIn) {
        return s.getCount() != passedIn;
    }

    public void onCacheHit(String template, int locality) {
        String methodName = "onCacheHit()";
        CacheStatsModule csm = null;
        csm = this.getCSM(template);
        if (csm == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheHit() cacheName=" + this._sCacheName + " template=" + template + " locality=" + locality + " enable=" + csm._enable + " parentEnable=" + this._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        switch (locality) {
            case 2: {
                if (!csm._enable) break;
                if (csm._remoteHitCount != null) {
                    csm._remoteHitCount.increment();
                }
                if (csm._inMemoryAndDiskCacheEntryCount != null) {
                    csm._inMemoryAndDiskCacheEntryCount.increment();
                }
                if (csm._remoteCreationCount == null) break;
                csm._remoteCreationCount.increment();
                break;
            }
            case 1: {
                if (!csm._enable || csm._hitsInMemoryCount == null) break;
                csm._hitsInMemoryCount.increment();
                break;
            }
            case 3: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._hitsOnDisk != null) {
                    this._csmDisk._hitsOnDisk.increment();
                }
                if (!csm._enable || csm._hitsOnDiskCount == null) break;
                csm._hitsOnDiskCount.increment();
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("onCacheHit() Error - Unrecognized locality " + locality + " cacheName=" + this._sCacheName), (Object[])new Object[0]);
            }
        }
    }

    public void onCacheMiss(String template, int locality) {
        String methodName = "onCacheMiss()";
        CacheStatsModule csm = null;
        csm = this.getCSM(template);
        if (csm == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheMiss() cacheName=" + this._sCacheName + " template=" + template + " locality=" + locality + " enable=" + csm._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (csm._enable && csm._missCount != null) {
            csm._missCount.increment();
        }
    }

    public void onEntryCreation(String template, int source) {
        String methodName = "onEntryCreation()";
        CacheStatsModule csm = null;
        csm = this.getCSM(template);
        if (csm == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onEntryCreation() cacheName=" + this._sCacheName + " template=" + template + " source=" + source + " enable=" + csm._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (csm._enable) {
            if (source == 2 && csm._remoteCreationCount != null) {
                csm._remoteCreationCount.increment();
            }
            if (csm._inMemoryAndDiskCacheEntryCount != null) {
                csm._inMemoryAndDiskCacheEntryCount.increment();
            }
        }
    }

    public void onRequest(String template, int source) {
        String methodName = "onRequest()";
        CacheStatsModule csm = null;
        csm = this.getCSM(template);
        if (csm == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onRequest() cacheName=" + this._sCacheName + " template=" + template + " source=" + source + " enable=" + csm._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (csm._enable) {
            if (source == 5) {
                if (csm._clientRequestCount != null) {
                    csm._clientRequestCount.increment();
                }
            } else if (source == 2 && csm._distributedRequestCount != null) {
                csm._distributedRequestCount.increment();
            }
        }
    }

    public void batchOnInvalidate(String template, int cause, int locality, int source, int dels) {
        String methodName = "batchOnInvalidate()";
        CacheStatsModule csm = null;
        csm = this.getCSM(template);
        if (csm == null) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("batchOnInvalidate() cacheName=" + this._sCacheName + " template=" + template + " cause=" + cause + " locality=" + locality + " source=" + source + " delete=" + dels + " disk=" + (Object)((Object)this._csmDisk) + " parentEnable=" + this._enable + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        block0 : switch (cause) {
            case 1: {
                if (csm._enable && csm._explicitInvalidationCount != null) {
                    csm._explicitInvalidationCount.increment((long)dels);
                }
                switch (locality) {
                    case 1: {
                        if (!csm._enable) break;
                        if (csm._explicitMemoryInvalidationCount != null) {
                            csm._explicitMemoryInvalidationCount.increment((long)dels);
                        }
                        if (csm._inMemoryAndDiskCacheEntryCount == null) break;
                        csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                        break;
                    }
                    case 3: {
                        if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._explicitInvalidationsFromDisk != null) {
                            this._csmDisk._explicitInvalidationsFromDisk.increment((long)dels);
                        }
                        if (!csm._enable) break;
                        if (csm._explicitDiskInvalidationCount != null) {
                            csm._explicitDiskInvalidationCount.increment((long)dels);
                        }
                        if (csm._inMemoryAndDiskCacheEntryCount == null) break;
                        csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                        break;
                    }
                }
                switch (source) {
                    case 5: {
                        if (!csm._enable || csm._localExplicitInvalidationCount == null) break block0;
                        csm._localExplicitInvalidationCount.increment((long)dels);
                        break block0;
                    }
                    case 2: {
                        if (!csm._enable || csm._remoteExplicitInvalidationCount == null) break block0;
                        csm._remoteExplicitInvalidationCount.increment((long)dels);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                if (csm._enable && csm._lruInvalidationCount != null) {
                    csm._lruInvalidationCount.increment((long)dels);
                }
                if (locality == 3 || !csm._enable || csm._inMemoryAndDiskCacheEntryCount == null) break;
                csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                break;
            }
            case 3: {
                if (this._csmDisk != null && locality == 3 && this._csmDisk._enable && this._csmDisk._timeoutInvalidationsFromDisk != null) {
                    this._csmDisk._timeoutInvalidationsFromDisk.increment((long)dels);
                }
                if (!csm._enable) break;
                if (csm._timeoutInvalidationCount != null) {
                    csm._timeoutInvalidationCount.increment((long)dels);
                }
                if (csm._inMemoryAndDiskCacheEntryCount == null) break;
                csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                break;
            }
            case 7: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._garbageCollectorInvalidationsFromDisk != null) {
                    this._csmDisk._garbageCollectorInvalidationsFromDisk.increment((long)dels);
                }
                if (!csm._enable || csm._inMemoryAndDiskCacheEntryCount == null) break;
                csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                break;
            }
            case 8: {
                if (this._csmDisk != null && this._csmDisk._enable && this._csmDisk._overflowInvalidationsFromDisk != null) {
                    this._csmDisk._overflowInvalidationsFromDisk.increment((long)dels);
                }
                if (!csm._enable || csm._inMemoryAndDiskCacheEntryCount == null) break;
                csm._inMemoryAndDiskCacheEntryCount.decrement((long)dels);
                break;
            }
        }
    }

    public void onInvalidate(String template, int cause, int locality, int source) {
        String methodName = "onInvalidate()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onInvalidate() cacheName=" + this._sCacheName + " template=" + template + " cause=" + cause + " locality=" + locality + " source=" + source), (Object[])new Object[0]);
        }
        this.batchOnInvalidate(template, cause, locality, source, 1);
    }

    public void onCacheClear(boolean memory, boolean disk) {
        String methodName = "onCacheClear()";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onCacheClear() cacheName=" + this._sCacheName + " memory=" + memory + " disk=" + disk + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        if (this._enable && this._inMemoryCacheEntryCount != null && memory) {
            this._inMemoryCacheEntryCount.setCount(0L);
        }
        if (this._csmDisk != null && this._csmDisk._enable && disk) {
            if (this._csmDisk._objectsOnDisk != null) {
                this._csmDisk._objectsOnDisk.setCount(0L);
            }
            if (this._csmDisk._pendingRemovalFromDisk != null) {
                this._csmDisk._pendingRemovalFromDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsOnDisk != null) {
                this._csmDisk._dependencyIdsOnDisk.setCount(0L);
            }
            if (this._csmDisk._dependencyIdsBufferedForDisk != null) {
                this._csmDisk._dependencyIdsBufferedForDisk.setCount(0L);
            }
            if (this._csmDisk._templatesOnDisk != null) {
                this._csmDisk._templatesOnDisk.setCount(0L);
            }
            if (this._csmDisk._templatesBufferedForDisk != null) {
                this._csmDisk._templatesBufferedForDisk.setCount(0L);
            }
        }
        if (this._iCacheType == 1 && (memory || disk)) {
            for (Map.Entry<String, CacheStatsModule> entry : this.templatesPassed.entrySet()) {
                CacheStatsModule csm = entry.getValue();
                if (csm == null || !csm._enable) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("***** clear _inMemoryAndDiskCacheEntryCount for template=" + (Object)((Object)entry.getValue()) + " cacheName=" + this._sCacheName), (Object[])new Object[0]);
                }
                if (csm._inMemoryAndDiskCacheEntryCount == null) continue;
                csm._inMemoryAndDiskCacheEntryCount.setCount(0L);
            }
        } else if (this._csmObject != null && this._csmObject._enable && (memory || disk)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("***** clear _inMemoryAndDiskCacheEntryCount for cacheName=" + this._sCacheName), (Object[])new Object[0]);
            }
            if (this._csmObject._inMemoryAndDiskCacheEntryCount != null) {
                this._csmObject._inMemoryAndDiskCacheEntryCount.setCount(0L);
            }
        }
    }

    public void removePMICounters() {
        block7: {
            try {
                if (null != this._statsInstance) {
                    StatsFactory.removeStatsInstance((StatsInstance)this._statsInstance);
                }
                if (null != this._cacheObjectStatsGroup) {
                    StatsFactory.removeStatsGroup((StatsGroup)this._cacheObjectStatsGroup);
                }
                if (null != this._cacheDiskStatsGroup) {
                    StatsFactory.removeStatsGroup((StatsGroup)this._cacheDiskStatsGroup);
                }
                if (null != this._cacheTemplateStatsGroup) {
                    StatsFactory.removeStatsGroup((StatsGroup)this._cacheTemplateStatsGroup);
                }
                if (null != _cacheRootStatsGroup) {
                    StatsFactory.removeStatsGroup((StatsGroup)_cacheRootStatsGroup);
                }
            }
            catch (StatsFactoryException e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Could NOT unregister PMI for cache instance {0} due to {1}", (Object[])new Object[]{this._sCacheName, e, this});
            }
        }
    }
}

