/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateIssuerUniqueIdentity;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateSubjectUniqueIdentity;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.UniqueIdentity;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509AttributeName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class X509CertInfo
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version = new CertificateVersion();
    protected CertificateSerialNumber serialNum = null;
    protected CertificateAlgorithmId algId = null;
    protected CertificateIssuerName issuer = null;
    protected CertificateValidity interval = null;
    protected CertificateSubjectName subject = null;
    protected CertificateX509Key pubKey = null;
    protected CertificateIssuerUniqueIdentity issuerUniqueId = null;
    protected CertificateSubjectUniqueIdentity subjectUniqueId = null;
    protected CertificateExtensions extensions = null;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo = null;
    private static final HashMap<String, Integer> map = new HashMap();
    private String provider = null;
    private static Debug debug;
    private static String className;

    public X509CertInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo");
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo");
            if (provider != null) {
                this.provider = new String(provider);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(byte[] cert) throws CertificateParsingException {
        this(cert, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertInfo", (Object)cert);
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(byte[] cert, String provider) throws CertificateParsingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo", cert, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            DerValue in = new DerValue(cert);
            this.parse(in);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CertInfo", e2);
            }
            throw new CertificateParsingException(e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(DerValue derVal) throws CertificateParsingException {
        this(derVal, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X509CertInfo", derVal);
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    public X509CertInfo(DerValue derVal, String provider) throws CertificateParsingException {
        if (debug != null) {
            debug.entry(16384L, className, "X509CertInfo", derVal, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        try {
            this.parse(derVal);
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "X509CertInfo", e2);
            }
            throw new CertificateParsingException(e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X509CertInfo");
        }
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.rawCertInfo == null) {
            DerOutputStream tmp = new DerOutputStream();
            this.emit(tmp);
            this.rawCertInfo = tmp.toByteArray();
        }
        out.write((byte[])this.rawCertInfo.clone());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(VERSION);
        elements.addElement(SERIAL_NUMBER);
        elements.addElement(ALGORITHM_ID);
        elements.addElement(ISSUER);
        elements.addElement(VALIDITY);
        elements.addElement(SUBJECT);
        elements.addElement(KEY);
        elements.addElement(ISSUER_ID);
        elements.addElement(SUBJECT_ID);
        elements.addElement(EXTENSIONS);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        if (debug != null) {
            debug.entry(16384L, className, "getEncodedInfo");
        }
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream tmp = new DerOutputStream();
                this.emit(tmp);
                this.rawCertInfo = tmp.toByteArray();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncodedInfo", this.rawCertInfo.clone());
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedInfo", e2);
            }
            throw new CertificateEncodingException(e2.toString());
        }
        catch (CertificateException e3) {
            if (debug != null) {
                debug.exception(16384L, className, "getEncodedInfo", e3);
            }
            throw new CertificateEncodingException(e3.toString());
        }
    }

    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other instanceof X509CertInfo) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((X509CertInfo)other)));
            }
            return this.equals((X509CertInfo)other);
        }
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public boolean equals(X509CertInfo other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", new Boolean(true));
            }
            return true;
        }
        if (this.rawCertInfo == null || other.rawCertInfo == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", new Boolean(false));
            }
            return false;
        }
        if (this.rawCertInfo.length != other.rawCertInfo.length) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", new Boolean(false));
            }
            return false;
        }
        for (int i2 = 0; i2 < this.rawCertInfo.length; ++i2) {
            if (this.rawCertInfo[i2] == other.rawCertInfo[i2]) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hasCode");
        }
        int retval = 0;
        for (int i2 = 1; i2 < this.rawCertInfo.length; ++i2) {
            retval += this.rawCertInfo[i2] * i2;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hasCode", retval);
        }
        return retval;
    }

    @Override
    public String toString() {
        if (this.subject == null || this.pubKey == null || this.interval == null || this.issuer == null || this.algId == null || this.serialNum == null) {
            throw new NullPointerException("X.509 cert is incomplete");
        }
        StringBuilder sb2 = new StringBuilder();
        sb2.append("[\r\n");
        sb2.append("  " + this.version.toString() + "\r\n");
        sb2.append("  Subject: " + this.subject.toString() + "\r\n");
        sb2.append("  Signature Algorithm: " + this.algId.toString() + "\r\n");
        sb2.append("  Key:  " + this.pubKey.toString() + "\r\n");
        sb2.append("  " + this.interval.toString() + "\r\n");
        sb2.append("  Issuer: " + this.issuer.toString() + "\r\n");
        sb2.append("  " + this.serialNum.toString() + "\r\n");
        if (this.issuerUniqueId != null) {
            sb2.append("  Issuer Id:\r\n" + this.issuerUniqueId.toString() + "\r\n");
        }
        if (this.subjectUniqueId != null) {
            sb2.append("  Subject Id:\r\n" + this.subjectUniqueId.toString() + "\r\n");
        }
        if (this.extensions != null) {
            HexDumpEncoder enc;
            Collection<Extension> allExts = this.extensions.getAllExtensions();
            Object[] objs = allExts.toArray();
            sb2.append("\r\nCertificate Extensions: " + objs.length);
            for (int i2 = 0; i2 < objs.length; ++i2) {
                sb2.append("\r\n[" + (i2 + 1) + "]: ");
                Extension ext = (Extension)objs[i2];
                try {
                    if (OIDMap.getClass(ext.getExtensionId()) == null) {
                        sb2.append(ext.toString());
                        byte[] extValue = ext.getExtensionValue();
                        if (extValue == null) continue;
                        DerOutputStream out = new DerOutputStream();
                        out.putOctetString(extValue);
                        extValue = out.toByteArray();
                        enc = new HexDumpEncoder();
                        sb2.append("Extension unknown: DER encoded OCTET string =\r\n" + enc.encodeBuffer(extValue) + "\r\n");
                        continue;
                    }
                    sb2.append(ext.toString());
                    continue;
                }
                catch (Exception e2) {
                    sb2.append(", Error parsing this extension");
                }
            }
            Map<String, Extension> invalid = this.extensions.getUnparseableExtensions();
            if (!invalid.isEmpty()) {
                sb2.append("\nUnparseable certificate extensions: " + invalid.size());
                int i3 = 1;
                for (Extension ext : invalid.values()) {
                    sb2.append("\n[" + i3++ + "]: ");
                    sb2.append(ext);
                    enc = new HexDumpEncoder();
                    sb2.append(enc.encodeBuffer(ext.getExtensionValue()));
                }
            }
        }
        sb2.append("\r\n]");
        return sb2.toString();
    }

    @Override
    public void set(String name, Object val) throws CertificateException, IOException {
        X509AttributeName attrName;
        int attr;
        if (debug != null) {
            debug.entry(16384L, className, "set", name, val);
        }
        if ((attr = this.attributeMap((attrName = new X509AttributeName(name)).getPrefix())) == 0) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized: " + name);
            }
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 1: {
                if (suffix == null) {
                    this.setVersion(val);
                    break;
                }
                this.version.set(suffix, val);
                break;
            }
            case 2: {
                if (suffix == null) {
                    this.setSerialNumber(val);
                    break;
                }
                this.serialNum.set(suffix, val);
                break;
            }
            case 3: {
                if (suffix == null) {
                    this.setAlgorithmId(val);
                    break;
                }
                this.algId.set(suffix, val);
                break;
            }
            case 4: {
                if (suffix == null) {
                    this.setIssuer(val);
                    break;
                }
                this.issuer.set(suffix, val);
                break;
            }
            case 5: {
                if (suffix == null) {
                    this.setValidity(val);
                    break;
                }
                if (this.interval == null) {
                    this.interval = new CertificateValidity();
                }
                this.interval.set(suffix, val);
                break;
            }
            case 6: {
                if (suffix == null) {
                    this.setSubject(val);
                    break;
                }
                this.subject.set(suffix, val);
                break;
            }
            case 7: {
                if (suffix == null) {
                    this.setKey(val);
                    break;
                }
                this.pubKey.set(suffix, val);
                break;
            }
            case 8: {
                if (suffix == null) {
                    this.setIssuerUniqueId(val);
                    break;
                }
                this.issuerUniqueId.set(suffix, val);
                break;
            }
            case 9: {
                if (suffix == null) {
                    this.setSubjectUniqueId(val);
                    break;
                }
                this.subjectUniqueId.set(suffix, val);
                break;
            }
            case 10: {
                if (suffix == null) {
                    this.setExtensions(val);
                    break;
                }
                if (this.extensions == null) {
                    this.extensions = new CertificateExtensions();
                }
                this.extensions.set(suffix, val);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public void delete(String name) throws CertificateException, IOException {
        X509AttributeName attrName;
        int attr;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if ((attr = this.attributeMap((attrName = new X509AttributeName(name)).getPrefix())) == 0) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized: " + name);
            }
            throw new CertificateException("Attribute name not recognized: " + name);
        }
        this.rawCertInfo = null;
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 1: {
                if (suffix == null) {
                    this.version = null;
                    break;
                }
                this.version.delete(suffix);
                break;
            }
            case 2: {
                if (suffix == null) {
                    this.serialNum = null;
                    break;
                }
                this.serialNum.delete(suffix);
                break;
            }
            case 3: {
                if (suffix == null) {
                    this.algId = null;
                    break;
                }
                this.algId.delete(suffix);
                break;
            }
            case 4: {
                if (suffix == null) {
                    this.issuer = null;
                    break;
                }
                this.issuer.delete(suffix);
                break;
            }
            case 5: {
                if (suffix == null) {
                    this.interval = null;
                    break;
                }
                this.interval.delete(suffix);
                break;
            }
            case 6: {
                if (suffix == null) {
                    this.subject = null;
                    break;
                }
                this.subject.delete(suffix);
                break;
            }
            case 7: {
                if (suffix == null) {
                    this.pubKey = null;
                    break;
                }
                this.pubKey.delete(suffix);
                break;
            }
            case 8: {
                if (suffix == null) {
                    this.issuerUniqueId = null;
                    break;
                }
                this.issuerUniqueId.delete(suffix);
                break;
            }
            case 9: {
                if (suffix == null) {
                    this.subjectUniqueId = null;
                    break;
                }
                this.subjectUniqueId.delete(suffix);
                break;
            }
            case 10: {
                if (suffix == null) {
                    this.extensions = null;
                    break;
                }
                this.extensions.delete(suffix);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    Extension getExt(String name) {
        Extension result = null;
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            if (debug != null) {
                debug.text(16384L, className, "getExt", "Attribute name not recognized: " + name);
            }
            return null;
        }
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 10: {
                result = suffix == null ? null : (this.extensions == null ? null : this.extensions.getExt(suffix));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getExt", result);
        }
        return result;
    }

    @Override
    public Object get(String name) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        Object result = null;
        X509AttributeName attrName = new X509AttributeName(name);
        int attr = this.attributeMap(attrName.getPrefix());
        if (attr == 0) {
            if (debug != null) {
                debug.text(16384L, className, "get", "Attribute name not recognized: " + name);
            }
            throw new CertificateParsingException("Attribute name not recognized: " + name);
        }
        String suffix = attrName.getSuffix();
        switch (attr) {
            case 10: {
                if (suffix == null) {
                    result = this.extensions;
                    break;
                }
                if (this.extensions == null) {
                    result = null;
                    break;
                }
                result = this.extensions.get(suffix);
                break;
            }
            case 6: {
                if (suffix == null) {
                    result = this.subject;
                    break;
                }
                result = this.subject.get(suffix);
                break;
            }
            case 4: {
                if (suffix == null) {
                    result = this.issuer;
                    break;
                }
                result = this.issuer.get(suffix);
                break;
            }
            case 7: {
                if (suffix == null) {
                    result = this.pubKey;
                    break;
                }
                result = this.pubKey.get(suffix);
                break;
            }
            case 3: {
                if (suffix == null) {
                    result = this.algId;
                    break;
                }
                result = this.algId.get(suffix);
                break;
            }
            case 5: {
                if (suffix == null) {
                    result = this.interval;
                    break;
                }
                result = this.interval.get(suffix);
                break;
            }
            case 1: {
                if (suffix == null) {
                    result = this.version;
                    break;
                }
                result = this.version.get(suffix);
                break;
            }
            case 2: {
                if (suffix == null) {
                    result = this.serialNum;
                    break;
                }
                result = this.serialNum.get(suffix);
                break;
            }
            case 8: {
                if (suffix == null) {
                    result = this.issuerUniqueId;
                    break;
                }
                if (this.issuerUniqueId == null) {
                    result = null;
                    break;
                }
                result = this.issuerUniqueId.get(suffix);
                break;
            }
            case 9: {
                result = suffix == null ? this.subjectUniqueId : (this.subjectUniqueId == null ? null : this.subjectUniqueId.get(suffix));
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", result);
        }
        return result;
    }

    private void parse(DerValue val) throws CertificateParsingException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "parse", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "signed fields invalid");
            }
            throw new CertificateParsingException("signed fields invalid");
        }
        this.rawCertInfo = val.toByteArray();
        DerInputStream in = val.getData();
        DerValue tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)0)) {
            this.version = new CertificateVersion(tmp);
            tmp = in.getDerValue();
        }
        this.serialNum = new CertificateSerialNumber(tmp);
        this.algId = new CertificateAlgorithmId(in);
        this.issuer = new CertificateIssuerName(in);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Null issuer DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.interval = new CertificateValidity(in);
        this.subject = new CertificateSubjectName(in);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Null subject DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.pubKey = this.provider != null ? new CertificateX509Key(in, this.provider) : new CertificateX509Key(in);
        if (in.available() != 0) {
            if (this.version.compare(0) == 0) {
                if (debug != null) {
                    debug.text(8192L, className, "parse", "no more data allowed for version 1 certificate");
                }
                throw new CertificateParsingException("no more data allowed for version 1 certificate");
            }
        } else {
            if (debug != null) {
                debug.exit(8192L, className, "parse_1");
            }
            return;
        }
        tmp = in.getDerValue();
        if (tmp.isContextSpecific((byte)1)) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity(tmp);
            if (in.available() == 0) {
                if (debug != null) {
                    debug.exit(8192L, className, "parse_2");
                }
                return;
            }
            tmp = in.getDerValue();
        }
        if (tmp.isContextSpecific((byte)2)) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity(tmp);
            if (in.available() == 0) {
                if (debug != null) {
                    debug.exit(8192L, className, "parse_3");
                }
                return;
            }
            tmp = in.getDerValue();
        }
        if (this.version.compare(2) != 0) {
            if (debug != null) {
                debug.text(8192L, className, "parse", "Extensions not allowed in v2 certificate");
            }
            throw new CertificateParsingException("Extensions not allowed in v2 certificate");
        }
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)3)) {
            this.extensions = new CertificateExtensions(tmp.getData());
        }
        if (this.subject == null || this.subject.toString() == null || this.subject.toString().length() == 0) {
            if (this.extensions == null) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions");
            }
            SubjectAlternativeNameExtension subjectAltNameExt = null;
            Object extValue = null;
            GeneralNames names = null;
            try {
                subjectAltNameExt = (SubjectAlternativeNameExtension)this.extensions.get("SubjectAlternativeName");
                names = (GeneralNames)subjectAltNameExt.get("subject_name");
            }
            catch (IOException e2) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent");
            }
            if (names == null || names.isEmpty()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty");
            }
            if (!subjectAltNameExt.isCritical()) {
                throw new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty");
            }
        }
        if (debug != null) {
            debug.exit(8192L, className, "parse");
        }
    }

    private void emit(DerOutputStream out) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "emit", out);
        }
        DerOutputStream tmp = new DerOutputStream();
        this.version.encode(tmp);
        this.serialNum.encode(tmp);
        this.algId.encode(tmp);
        if (this.version.compare(0) == 0 && this.issuer.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "emit", "Null issuer DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null issuer DN not allowed in v1 certificate");
        }
        this.issuer.encode(tmp);
        this.interval.encode(tmp);
        if (this.version.compare(0) == 0 && this.subject.toString() == null) {
            if (debug != null) {
                debug.text(8192L, className, "emit", "Null subject DN not allowed in v1 certificate");
            }
            throw new CertificateParsingException("Null subject DN not allowed in v1 certificate");
        }
        this.subject.encode(tmp);
        this.pubKey.encode(tmp);
        if (this.issuerUniqueId != null) {
            this.issuerUniqueId.encode(tmp);
        }
        if (this.subjectUniqueId != null) {
            this.subjectUniqueId.encode(tmp);
        }
        if (this.extensions != null) {
            this.extensions.encode(tmp);
        }
        out.write((byte)48, tmp);
        if (debug != null) {
            debug.exit(8192L, className, "emit");
        }
    }

    private int attributeMap(String name) {
        Integer num;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "attributeMap", name);
        }
        if ((num = map.get(name)) == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "attributeMap_1", new Integer(0));
            }
            return 0;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "attributeMap", new Integer(num));
        }
        return num;
    }

    private void setVersion(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setVersion", val);
        }
        if (val instanceof CertificateVersion) {
            CertificateVersion cval = (CertificateVersion)val;
            try {
                if (cval.compare(0) == 0) {
                    this.version = new CertificateVersion(0);
                }
                DerOutputStream derout = new DerOutputStream();
                ((CertificateVersion)val).encode(derout);
                this.version = new CertificateVersion(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setVersion", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof Integer) {
            try {
                this.version = new CertificateVersion((Integer)val);
            }
            catch (IOException e3) {
                if (debug != null) {
                    debug.exception(8192L, className, "setVersion", e3);
                }
                throw new CertificateException(e3.toString());
            }
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setVersion", "Version class type invalid.");
            }
            throw new CertificateException("Version class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setVersion");
        }
    }

    private void setSerialNumber(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSerialNumber", val);
        }
        if (val instanceof CertificateSerialNumber) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateSerialNumber)val).encode(derout);
                this.serialNum = new CertificateSerialNumber(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSerialNumber", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof BigInteger) {
            this.serialNum = new CertificateSerialNumber((BigInteger)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSerialNumber", "SerialNumber class type invalid.");
            }
            throw new CertificateException("SerialNumber class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setSerialNumber");
        }
    }

    private void setAlgorithmId(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setAlgorithmId", val);
        }
        if (val instanceof CertificateAlgorithmId) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateAlgorithmId)val).encode(derout);
                this.algId = new CertificateAlgorithmId(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setAlgorithmId", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof AlgorithmId) {
            this.algId = new CertificateAlgorithmId((AlgorithmId)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setAlgorithmId", "AlgorithmId class type invalid.");
            }
            throw new CertificateException("AlgorithmId class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setAlgorithmId");
        }
    }

    private void setIssuer(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuer", val);
        }
        if (val instanceof CertificateIssuerName) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateIssuerName)val).encode(derout);
                this.issuer = new CertificateIssuerName(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setIssuer", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof X500Name) {
            this.issuer = new CertificateIssuerName((X500Name)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setIssuer", "Issuer class type invalid.");
            }
            throw new CertificateException("Issuer class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setIssuer");
        }
    }

    private void setValidity(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setValidity", val);
        }
        if (!(val instanceof CertificateValidity)) {
            if (debug != null) {
                debug.text(8192L, className, "setValidity", "CertificateValidity class type invalid.");
            }
            throw new CertificateException("CertificateValidity class type invalid.");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            ((CertificateValidity)val).encode(derout);
            this.interval = new CertificateValidity(new DerInputStream(derout.toByteArray()));
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(8192L, className, "setValidity", e2);
            }
            throw new CertificateException(e2.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setValidity");
        }
    }

    private void setSubject(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSubject", val);
        }
        if (val instanceof CertificateSubjectName) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateSubjectName)val).encode(derout);
                this.subject = new CertificateSubjectName(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSubject", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof X500Name) {
            this.subject = new CertificateSubjectName((X500Name)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSubject", "Subject class type invalid.");
            }
            throw new CertificateException("Subject class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setSubject");
        }
    }

    private void setKey(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setKey", val);
        }
        if (val instanceof CertificateX509Key) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateX509Key)val).encode(derout);
                if (this.provider != null) {
                    this.pubKey = new CertificateX509Key(new DerInputStream(derout.toByteArray()), this.provider);
                }
                this.pubKey = new CertificateX509Key(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setKey", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof PublicKey) {
            this.pubKey = this.provider != null ? new CertificateX509Key((PublicKey)val, this.provider) : new CertificateX509Key((PublicKey)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setKey", "Key class type invalid.");
            }
            throw new CertificateException("Key class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setKey");
        }
    }

    private void setIssuerUniqueId(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setIssuerUniqueId", val);
        }
        if (this.version.compare(1) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setIssuerUniqueId", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (val instanceof CertificateIssuerUniqueIdentity) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateIssuerUniqueIdentity)val).encode(derout);
                this.issuerUniqueId = new CertificateIssuerUniqueIdentity(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setIssuerUniqueId", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof UniqueIdentity) {
            this.issuerUniqueId = new CertificateIssuerUniqueIdentity((UniqueIdentity)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setIssuerUniqueId", "IssuerUniqueId class type invalid.");
            }
            throw new CertificateException("IssuerUniqueId class type invalid.");
        }
        if (debug != null) {
            debug.exit(8192L, className, "setIssuerUniqueId");
        }
    }

    private void setSubjectUniqueId(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSubjectUniqueId", val);
        }
        if (this.version.compare(1) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setSubjectUniqueId", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (val instanceof CertificateSubjectUniqueIdentity) {
            try {
                DerOutputStream derout = new DerOutputStream();
                ((CertificateSubjectUniqueIdentity)val).encode(derout);
                this.subjectUniqueId = new CertificateSubjectUniqueIdentity(new DerInputStream(derout.toByteArray()));
            }
            catch (IOException e2) {
                if (debug != null) {
                    debug.exception(8192L, className, "setSubjectUniqueId", e2);
                }
                throw new CertificateException(e2.toString());
            }
        } else if (val instanceof UniqueIdentity) {
            this.subjectUniqueId = new CertificateSubjectUniqueIdentity((UniqueIdentity)val);
        } else {
            if (debug != null) {
                debug.text(8192L, className, "setSubjectUniqueId", "SubjectUniqueId class type invalid.");
            }
            throw new CertificateException("SubjectUniqueId class type invalid.");
        }
    }

    private void setExtensions(Object val) throws CertificateException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setExtensions", val);
        }
        if (this.version.compare(2) < 0) {
            if (debug != null) {
                debug.text(8192L, className, "setExtensions", "Invalid version");
            }
            throw new CertificateException("Invalid version");
        }
        if (!(val instanceof CertificateExtensions)) {
            if (debug != null) {
                debug.text(8192L, className, "setExtensions", "Extensions class type invalid.");
            }
            throw new CertificateException("Extensions class type invalid.");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((CertificateExtensions)val).encode(out);
            byte[] bytes = out.toByteArray();
            this.extensions = new CertificateExtensions();
            this.extensions.decodeThis(new ByteArrayInputStream(bytes));
        }
        catch (IOException e2) {
            if (debug != null) {
                debug.exception(8192L, className, "setExtensions", e2);
            }
            throw new CertificateException(e2.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "setExtensions");
        }
    }

    static {
        map.put(VERSION, new Integer(1));
        map.put(SERIAL_NUMBER, new Integer(2));
        map.put(ALGORITHM_ID, new Integer(3));
        map.put(ISSUER, new Integer(4));
        map.put(VALIDITY, new Integer(5));
        map.put(SUBJECT, new Integer(6));
        map.put(KEY, new Integer(7));
        map.put(ISSUER_ID, new Integer(8));
        map.put(SUBJECT_ID, new Integer(9));
        map.put(EXTENSIONS, new Integer(10));
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.X509CertInfo";
    }
}

