/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.DigestInfo;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;

public final class MacData
extends PKCSDerObject
implements Cloneable {
    private DigestInfo mac;
    private byte[] salt;
    private BigInteger iCount = BigInteger.ONE;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.MacData";
    private volatile int cachedHashVal = 0;

    public MacData(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MacData", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "MacData", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(DigestInfo mac, byte[] salt, int iterations) {
        if (debug != null) {
            Object[] parms = new Object[]{mac, salt, new Integer(iterations)};
            debug.entry(16384L, (Object)className, "MacData", parms);
        }
        this.mac = mac;
        this.salt = salt;
        this.iCount = BigInteger.valueOf(iterations);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(DigestInfo mac, byte[] salt, int iterations, String provider) {
        super(provider);
        if (debug != null) {
            Object[] parms = new Object[]{mac, salt, new Integer(iterations), provider};
            debug.entry(16384L, (Object)className, "MacData", parms);
        }
        this.mac = mac;
        this.salt = salt;
        this.iCount = BigInteger.valueOf(iterations);
        if (debug != null) {
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "MacData", parms);
            debug.exit(16384L, className, "MacData");
        }
    }

    public MacData(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "MacData", parms);
            debug.exit(16384L, className, "MacData");
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        this.mac.encode(bytes);
        bytes.putOctetString(this.salt);
        bytes.putInteger(this.iCount);
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (other instanceof MacData) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((MacData)other));
            }
            return this.equals((MacData)other);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            MacData retobj = new MacData(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    @Override
    public String toString() {
        String out = "";
        HexDumpEncoder hd = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = out + "MAC Data:\r\n";
        out = out + "MAC Digest info:\r\n";
        out = out + this.mac.toString();
        out = out + "\r\n";
        out = out + "MAC salt:";
        out = out + "\r\n";
        out = out + hd.encodeBuffer(this.salt);
        out = out + "\r\n";
        out = out + "MAC iteration count: " + this.iCount.intValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }

    public DigestInfo getMac() {
        if (debug != null) {
            debug.entry(16384L, className, "getMac");
            debug.exit(16384L, (Object)className, "getMac", (DigestInfo)this.mac.clone());
        }
        return (DigestInfo)this.mac.clone();
    }

    public byte[] getSalt() {
        if (debug != null) {
            debug.entry(16384L, className, "getSalt");
            debug.exit(16384L, (Object)className, "getSalt", (byte[])this.salt.clone());
        }
        return (byte[])this.salt.clone();
    }

    public int getIterations() {
        if (debug != null) {
            debug.entry(16384L, className, "getIterations");
            debug.exit(16384L, (Object)className, "getIterations", this.iCount.intValue());
        }
        return this.iCount.intValue();
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "MacData parsing error, not a SEQUENCE");
            }
            throw new IOException("MacData parsing error, not a SEQUENCE");
        }
        DerValue der = encoding.getData().getDerValue();
        this.mac = new DigestInfo(der.toByteArray(), this.provider);
        this.salt = encoding.getData().getOctetString();
        if (encoding.getData().available() != 0) {
            this.iCount = encoding.getData().getInteger();
        }
        if (encoding.getData().available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "MacData parsing error - data overrun, bytes = " + encoding.getData().available());
            }
            throw new IOException("MacData parsing error - data overrun, bytes = " + encoding.getData().available());
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(MacData other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            other.encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", true);
        }
        return true;
    }
}

