/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.POPOSigningKeyInput;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class POPOSigningKey
extends CMPDerObject {
    private POPOSigningKeyInput poposkInput;
    private AlgorithmId algorithmIdentifier;
    byte[] signature;
    private static final byte TAG_POPOSKINPUT = 0;

    public POPOSigningKey(POPOSigningKeyInput pOPOSigningKeyInput, AlgorithmId algorithmId, byte[] byArray) {
        if (algorithmId == null) {
            throw new IllegalArgumentException("POPOSigningKey error, AlgorithmId not specified");
        }
        this.algorithmIdentifier = algorithmId;
        if (byArray == null) {
            throw new IllegalArgumentException("POPOSigningKey error, signature not specified");
        }
        this.signature = byArray;
        this.poposkInput = pOPOSigningKeyInput;
    }

    public POPOSigningKey(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new POPOSigningKey(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("POPOSigningKey parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("POPOSigningKey parsing error, data missing");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.poposkInput = null;
        this.algorithmIdentifier = null;
        this.signature = null;
        if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
            derValue2.resetTag((byte)48);
            this.poposkInput = new POPOSigningKeyInput(derValue2.toByteArray());
            if (derValue.getData().available() == 0) {
                throw new IOException("POPOSigningKey parsing error, data missing");
            }
            derValue2 = derValue.getData().getDerValue();
        } else {
            this.poposkInput = null;
        }
        this.algorithmIdentifier = AlgorithmId.parse(derValue2);
        if (derValue.getData().available() == 0) {
            throw new IOException("POPOSigningKey parsing error, data missing");
        }
        this.signature = derValue.getData().getBitString();
        if (derValue.getData().available() != 0) {
            throw new IOException("POPOSigningKey parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.poposkInput != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.poposkInput.encode(derOutputStream3);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        }
        this.algorithmIdentifier.encode(derOutputStream);
        derOutputStream.putBitString(this.signature);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(POPOSigningKey pOPOSigningKey) {
        DerValue derValue;
        DerValue derValue2;
        if (pOPOSigningKey == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pOPOSigningKey.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof POPOSigningKey) {
            return this.equals((POPOSigningKey)object);
        }
        return false;
    }

    public AlgorithmId getAlgorithmId() throws IOException {
        if (this.algorithmIdentifier == null) {
            return null;
        }
        return new AlgorithmId(this.algorithmIdentifier.getOID(), this.algorithmIdentifier.getParameters());
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public String toString() {
        String string = "POPOSigningKey:";
        if (this.poposkInput != null) {
            string = String.valueOf(string) + "\r\n\tpoposkInput: " + this.poposkInput.toString();
        }
        string = String.valueOf(string) + "\r\n\talgorithmIdentifier: " + this.algorithmIdentifier.toString();
        string = String.valueOf(string) + "\r\n\tsignature: " + new String(this.signature);
        return string;
    }
}

