/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.beans.PkCertGen;
import com.ibm.security.certclient.util.PkCertUtils;
import com.ibm.security.certclient.util.PkUtils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertAndKeyGen;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;

public class PkCASetUp
implements PkConstants {
    private static Debug debug = Debug.getInstance("keycertmanage");
    private static final Object className = "PkCASetUp";
    public static final int CERT = 0;
    public static final int SERVER = 1;
    public static final int CRL = 2;
    public static final int CA = 3;
    public static final int CA_ALL = 4;
    private PrivateKey privateKey;
    private X509Key publicKey;
    private X500Name subjectName;
    private String sigAlg;
    private X509Certificate certificate;
    private String[] keyUsageType = new String[1];
    private long validity;
    private String providerName;

    public PkCASetUp(String name, String keyType, String sigAlg, int keyBits, long validity, String keyUsageType) throws GeneralSecurityException, IOException, PkException {
        X500Name subjectName = new X500Name(name);
        CertAndKeyGen candg = new CertAndKeyGen(keyType, sigAlg);
        candg.generate(keyBits);
        Key pubKey = candg.newGetPublicKey();
        PrivateKey priKey = candg.getPrivateKey();
        KeyFactory kf = null;
        X509Key xpubKey = null;
        PrivateKey xpriKey = null;
        if (keyType.equalsIgnoreCase("rsa") || keyType.equalsIgnoreCase("dsa")) {
            kf = keyType.equalsIgnoreCase("rsa") ? KeyFactory.getInstance("RSA", PkEeFactory.getProvider()) : KeyFactory.getInstance("DSA", PkEeFactory.getProvider());
            xpubKey = (X509Key)kf.translateKey(pubKey);
            xpriKey = (PrivateKey)kf.translateKey(priKey);
        } else {
            xpubKey = (X509Key)pubKey;
            xpriKey = priKey;
        }
        this.privateKey = xpriKey;
        this.publicKey = xpubKey;
        this.subjectName = subjectName;
        this.sigAlg = sigAlg;
        this.keyUsageType[0] = keyUsageType;
        this.validity = validity * 1000L;
        this.setSelfSignedCert(new BigInteger("0"), subjectName, this.keyUsageType);
    }

    public PkCASetUp(String name, String keyType, String sigAlg, int keyBits, long validity, String[] keyUsageType, String providerName) throws GeneralSecurityException, IOException, PkException {
        X500Name subjectName = new X500Name(name);
        this.providerName = providerName;
        if (providerName.equalsIgnoreCase("IBMJCE4758")) {
            this.keyPairGenerate(keyType, keyBits, providerName);
            this.keyPairGenerate(keyType, keyBits, providerName);
        } else {
            this.keyPairGenerate(keyType, keyBits, providerName);
        }
        this.subjectName = subjectName;
        this.sigAlg = sigAlg;
        this.keyUsageType = keyUsageType;
        this.validity = validity * 1000L;
        this.setSelfSignedCert(new BigInteger("0"), subjectName, this.keyUsageType);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private X509Key getPublicKey() {
        return this.publicKey;
    }

    private X500Name getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    @Deprecated
    public static byte[] computeKID(PublicKey key, boolean shortValue) throws NoSuchAlgorithmException {
        return PkUtils.computeKID(key, shortValue);
    }

    private static AuthorityKeyIdentifierExtension computeAuthorityKID(PublicKey key) throws NoSuchAlgorithmException, IOException {
        SubjectKeyIdentifierExtension ski = null;
        byte[] kIDTmp = PkUtils.computeKID(key, false);
        ski = new SubjectKeyIdentifierExtension(kIDTmp);
        return new AuthorityKeyIdentifierExtension(new KeyIdentifier(kIDTmp), null, null);
    }

    private static X509CertInfo makeCertInfo(X509Certificate c2) throws CertificateException, IOException {
        byte[] k2 = c2.getEncoded();
        try {
            return new X509CertInfo(k2);
        }
        catch (CertificateParsingException e2) {
            if (debug != null) {
                debug.exception(1L, className, "makeCertInfo", e2);
            }
            DerInputStream work = new DerInputStream(k2);
            DerValue[] ents = work.getSequence(3);
            return new X509CertInfo(ents[0]);
        }
    }

    private void setSelfSignedCert(BigInteger serialNum, X500Name issuerName, String[] keyUsageType) throws GeneralSecurityException, IOException, PkException {
        if (this.publicKey == null) {
            throw new PkException(PkNLSConstants.CASETUP_PUBLICKEY_NULL);
        }
        PkCertGen certGen = new PkCertGen(PkEeFactory.getProvider());
        PkAttrs attrs = new PkAttrs();
        attrs.add("cert.oper.privateKey", 2, this.privateKey);
        int type = 3;
        attrs.add("x509.info.version", type, CERT_VERSION_3);
        attrs.add("x509.info.serialNumber", type, serialNum);
        attrs.add("x509.info.algorithmID", type, AlgorithmId.get(this.sigAlg));
        attrs.add("x509.info.issuer", type, issuerName);
        attrs.add("x509.info.validity.notBefore", type, new Date());
        GregorianCalendar calendar = new GregorianCalendar();
        Date dt = calendar.getTime();
        long tme = dt.getTime();
        dt.setTime(tme += this.validity);
        if (debug != null) {
            debug.text(0L, className, "setSelfSignedCert", "notAfter {0}", dt);
        }
        attrs.add("x509.info.validity.notAfter", type, dt);
        attrs.add("x509.info.subject", type, this.subjectName);
        attrs.add("x509.info.key", type, this.publicKey);
        if (this.publicKey == null) {
            throw new PkException(PkNLSConstants.CASETUP_PUBLICKEY_NULL);
        }
        KeyUsageExtension keyUsage = new KeyUsageExtension();
        for (int i2 = 0; i2 < keyUsageType.length; ++i2) {
            keyUsage.set(keyUsageType[i2], Boolean.TRUE);
        }
        attrs.add("x509.info.extensions.KeyUsage", 3, keyUsage);
        BasicConstraintsExtension bConst = new BasicConstraintsExtension(true, 1);
        attrs.add("x509.info.extensions.BasicConstraints", 3, bConst);
        SubjectKeyIdentifierExtension ski = null;
        byte[] kIDTmp = PkUtils.computeKID(this.publicKey, false);
        ski = new SubjectKeyIdentifierExtension(kIDTmp);
        AuthorityKeyIdentifierExtension ake = new AuthorityKeyIdentifierExtension(new KeyIdentifier(kIDTmp), null, null);
        attrs.add("x509.info.extensions.SubjectKeyIdentifier", 3, ski);
        attrs.add("x509.info.extensions.AuthorityKeyIdentifier", 3, ake);
        PkCertReqEvent ev = new PkCertReqEvent("", null, attrs);
        PkCertRepEvent reply = null;
        try {
            reply = (PkCertRepEvent)ev.executeOn(certGen);
        }
        catch (PkException e2) {
            e2.printStackTrace();
        }
        this.certificate = (X509Certificate)reply.getCert();
    }

    public X509Certificate recertify(X509Certificate b2, int certType, PrivateKey pKey, Date notBefore, Date notAfter, String providerName) throws GeneralSecurityException {
        boolean inBad = true;
        try {
            X509CertInfo info = PkCASetUp.makeCertInfo(b2);
            inBad = false;
            X509CertInfo ca = PkCASetUp.makeCertInfo(this.certificate);
            boolean isCA = false;
            CertificateExtensions ext = new CertificateExtensions();
            Date now = new Date();
            info.set("version", new CertificateVersion(2));
            info.set("serialNumber", new CertificateSerialNumber(0));
            info.set("algorithmID", ca.get("algorithmID"));
            info.set("issuer", ca.get("issuer"));
            KeyUsageExtension ku = new KeyUsageExtension();
            switch (certType) {
                case 1: {
                    ku.set("key_encipherment", Boolean.TRUE);
                }
                case 0: {
                    ku.set("digital_signature", Boolean.TRUE);
                    break;
                }
                case 4: {
                    ku.set("crl_sign", Boolean.TRUE);
                }
                case 3: {
                    ku.set("key_certsign", Boolean.TRUE);
                    isCA = true;
                    break;
                }
                case 2: {
                    ku.set("crl_sign", Boolean.TRUE);
                    isCA = true;
                    break;
                }
                default: {
                    throw new CertificateEncodingException(PkNLSConstants.CASETUP_BAD_KEY_USAGE);
                }
            }
            ext.set("x509.info.extensions.KeyUsage", ku);
            ext.set("x509.info.extensions.BasicConstraints", new BasicConstraintsExtension(true, 1));
            Object eca = null;
            byte[] kid = null;
            try {
                CertificateX509Key kca = (CertificateX509Key)info.get("key");
                kid = PkUtils.computeKID((PublicKey)kca.get("value"), false);
            }
            catch (GeneralSecurityException ex) {
                // empty catch block
            }
            if (kid != null && isCA) {
                ext.set("x509.info.extensions.SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(kid));
                ext.set("x509.info.extensions.AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(kid), null, null));
            }
            if (!isCA) {
                try {
                    CertificateX509Key k0 = (CertificateX509Key)info.get("key");
                    kid = PkUtils.computeKID((PublicKey)k0.get("value"), false);
                    if (kid != null) {
                        ext.set("x509.info.extensions.SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(kid));
                    }
                }
                catch (GeneralSecurityException ex) {
                    // empty catch block
                }
            }
            info.set("extensions", ext);
            X509CertImpl cert = new X509CertImpl(info);
            if (notBefore != null) {
                cert.set("x509.info.validity.notBefore", notBefore);
            }
            if (notAfter != null) {
                cert.set("x509.info.validity.notAfter", notAfter);
            }
            cert.sign(pKey, this.sigAlg, providerName);
            return cert;
        }
        catch (IOException e2) {
            throw new CertificateEncodingException(PkNLSConstants.CASETUP_RECERTIFICATION_FAILED + e2.getMessage());
        }
        catch (GeneralSecurityException e3) {
            if (inBad) {
                System.err.println(b2.toString());
            } else {
                System.err.println(this.certificate.toString());
            }
            throw e3;
        }
    }

    public void keyPairGenerate(String keyType, int keyBits, String providerName) throws GeneralSecurityException {
        try {
            Key[] keyPair = PkCertUtils.generateKeyPair(keyType, keyBits, providerName);
            this.publicKey = (X509Key)keyPair[0];
            this.privateKey = (PrivateKey)keyPair[1];
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

