/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkInitRepEvent;
import com.ibm.security.certclient.base.PkInitReqEvent;
import com.ibm.security.certclient.base.PkKupdRepEvent;
import com.ibm.security.certclient.base.PkKupdReqEvent;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkSecnRepEvent;
import com.ibm.security.certclient.base.PkSecnReqEvent;
import com.ibm.security.certclient.base.PkXcerRepEvent;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import com.ibm.security.certclient.util.PkUtils;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;

public class PkCertGen
extends PkPipe
implements PkConstants {
    private static Debug debug = Debug.getInstance("keycertmanage");
    private static final Object className = "com.ibm.security.certclient.PkCertGen";
    private String provider;

    public PkCertGen(String provider) {
        this.provider = provider;
    }

    private X509CertImpl getCert(PkCertReqEvent ev) throws PkException {
        X509CertImpl c2;
        PkAttr pkeyAttr = ev.getAttrs().get("cert.oper.privateKey");
        PrivateKey privateKey = (PrivateKey)pkeyAttr.getValue();
        PkAttrs attrs = ev.getAttrs();
        PkAttr attr = attrs.get("x509.info.algorithmID");
        String algorithm = ((AlgorithmId)attr.getValue()).getName();
        PublicKey subjectPubKey = (PublicKey)attrs.getValue("x509.info.key");
        SubjectKeyIdentifierExtension ski = null;
        try {
            byte[] kIDTmp = PkUtils.computeKID(subjectPubKey, false);
            ski = new SubjectKeyIdentifierExtension(kIDTmp);
        }
        catch (IOException e2) {
            throw new PkException(e2);
        }
        catch (GeneralSecurityException e3) {
            throw new PkException(e3);
        }
        attrs.repOrAdd("x509.info.extensions.SubjectKeyIdentifier", 3, ski);
        try {
            KeyIdentifier ki = (KeyIdentifier)ski.get("key_id");
            if (debug != null) {
                debug.text(0L, className, "getCert", "########### from PkCertGen....ki = {0}", ki);
            }
        }
        catch (IOException e4) {
            // empty catch block
        }
        if (debug != null) {
            debug.text(0L, className, "PkCertGen", "########### from PkCertGen.... attrs = {0}", attrs);
        }
        try {
            c2 = new X509CertImpl((X509CertInfo)null);
        }
        catch (CertificateParsingException e5) {
            throw new PkException(e5);
        }
        catch (CertificateEncodingException e6) {
            throw new PkException(e6);
        }
        PkAttrs.Iter iter = ev.getAttrs().iterator();
        while (iter.hasNext()) {
            PkAttr a2 = iter.nextAttr();
            if (!a2.isApplied() || !a2.isApproved()) continue;
            try {
                c2.set(a2.getName(), a2.getValue());
            }
            catch (CertificateException e7) {
                throw new PkException(e7);
            }
            catch (IOException e8) {
                throw new PkException(e8);
            }
        }
        Object subject = attrs.getValue("x509.info.subject", "?");
        if (debug != null) {
            debug.text(0L, className, "PkCertGen", "####### subject = {0}", subject);
        }
        try {
            c2.sign(privateKey, algorithm, this.provider);
            if (debug != null) {
                debug.text(0L, className, "PkCertGen", "issued certificate to {0}", subject);
            }
        }
        catch (GeneralSecurityException e9) {
            throw new PkException(e9);
        }
        return c2;
    }

    private byte[] getEncoded(X509CertImpl c2) throws PkException {
        try {
            return c2.getEncoded();
        }
        catch (CertificateEncodingException e2) {
            throw new PkException(e2);
        }
    }

    @Override
    public PkCertRepEvent doCertReq(PkCertReqEvent req) throws PkException {
        X509CertImpl c2 = this.getCert(req);
        PkCertRepEvent rp = new PkCertRepEvent(this, null, req, c2);
        if (debug != null) {
            debug.text(0L, className, "doCertReq", rp.getCert().toString());
        }
        return rp;
    }

    @Override
    public PkInitRepEvent doInitReq(PkInitReqEvent req) throws PkException {
        Boolean ra_enroll = (Boolean)req.getAttrs().getValue("cert.oper.raEnrollment", Boolean.FALSE);
        if (!ra_enroll.booleanValue()) {
            X509CertImpl c2 = this.getCert(req);
            PkInitRepEvent rp = new PkInitRepEvent(this, null, req, c2);
            if (debug != null) {
                debug.text(0L, className, "doInitReq", rp.getCert().toString());
            }
            return rp;
        }
        X509CertImpl c1 = this.getCert(req);
        PkInitRepEvent rp = new PkInitRepEvent(this, null, req, c1);
        if (debug != null) {
            debug.text(0L, className, "doInitReq", rp.getCert().toString());
        }
        return rp;
    }

    @Override
    public PkSecnRepEvent doSecnReq(PkSecnReqEvent req) throws PkException {
        X509CertImpl c2 = this.getCert(req);
        PkSecnRepEvent rp = new PkSecnRepEvent(this, null, req, c2);
        if (debug != null) {
            debug.text(0L, className, "doSecnReq", rp.getCert().toString());
        }
        return rp;
    }

    @Override
    public PkKupdRepEvent doKupdReq(PkKupdReqEvent req) throws PkException {
        X509CertImpl c2 = this.getCert(req);
        PkKupdRepEvent rp = new PkKupdRepEvent(this, null, req, c2);
        if (debug != null) {
            debug.text(0L, className, "doKupdReq", rp.getCert().toString());
        }
        return rp;
    }

    @Override
    public PkXcerRepEvent doXcerReq(PkXcerReqEvent req) throws PkException {
        X509CertImpl c2 = this.getCert(req);
        PkXcerRepEvent rp = new PkXcerRepEvent(this, null, req, c2);
        if (debug != null) {
            debug.text(0L, className, "doXcerReq", rp.getCert().toString());
        }
        return rp;
    }
}

