/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkAttrKind;
import com.ibm.security.certclient.base.PkNLSConstants;
import java.io.Serializable;

public final class PkAttr
implements PkAttrKind,
Serializable,
Cloneable,
Comparable {
    private static final String sccsid = "@(#) 30 1.2    com/tivoli/pki/base/PkAttr.java, PkBase, javapki, 04302002 4/24/02 12:26:33";
    private static final long serialVersionUID = -5643396981708933860L;
    public static final PkAttr NULL = new PkAttr("null", 0, null, true);
    private final String name;
    private int kind;
    private Object value;
    private boolean readOnly;

    public PkAttr(String name) {
        this.name = name;
    }

    public PkAttr(String name, int kind, Object value) {
        this.name = name;
        this.kind = kind;
        this.value = value;
    }

    public PkAttr(String name, int kind, Object value, boolean readOnly) {
        this.name = name;
        this.kind = kind;
        this.value = value;
        this.readOnly = readOnly;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isApplied() {
        return (this.kind & 1) != 0;
    }

    public boolean isApproved() {
        return (this.kind & 2) != 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNameOid() {
        for (int i2 = 0; i2 < this.name.length(); ++i2) {
            if (".0123456789".indexOf(this.name.charAt(i2)) != -1) continue;
            return false;
        }
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public String getString() {
        return (String)this.value;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public void setKind(int kind) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind = kind;
    }

    public void setApplied(boolean b2) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind |= b2 ? 1 : -2;
    }

    public void setApproved(boolean b2) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.kind |= b2 ? 2 : -3;
    }

    public void setValue(Object value) {
        if (this.readOnly) {
            throw new IllegalStateException(PkNLSConstants.ATTR_READ_ONLY + " " + this);
        }
        this.value = value;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name);
        result.append(ATTR_NAMES[this.kind]);
        result.append(" = ");
        result.append(this.value);
        return result.toString();
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode() + this.kind;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PkAttr)) {
            return false;
        }
        PkAttr other = (PkAttr)obj;
        return this.name.equals(other.name) && this.kind == other.kind && this.value.equals(other.value);
    }

    public int compareTo(PkAttr other) {
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        result = this.kind - other.kind;
        if (result != 0) {
            return result;
        }
        if (this.value instanceof Comparable) {
            return ((Comparable)this.value).compareTo(other.value);
        }
        if (this.value.equals(other.value)) {
            return 0;
        }
        return this.value.hashCode() - other.value.hashCode();
    }

    public int compareTo(Object other) {
        return this.compareTo((PkAttr)other);
    }
}

