/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.CEFormatException;
import com.ibm.misc.CEStreamExhausted;
import com.ibm.misc.CharacterDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BASE64Decoder
extends CharacterDecoder {
    private static final char[] pem_array;
    private static final byte[] pem_convert_array;
    byte[] decode_buffer = new byte[4];

    @Override
    protected int bytesPerAtom() {
        return 4;
    }

    @Override
    protected int bytesPerLine() {
        return 72;
    }

    @Override
    protected void decodeAtom(InputStream inStream, OutputStream outStream, int rem) throws IOException {
        int a2 = -1;
        int b2 = -1;
        int c2 = -1;
        int d2 = -1;
        if (rem < 2) {
            throw new CEFormatException("BASE64Decoder: Not enough bytes for an atom.");
        }
        int i2 = this.readFully(inStream, this.decode_buffer, 0, rem);
        if (i2 == -1) {
            throw new CEStreamExhausted();
        }
        if (rem > 3 && this.decode_buffer[3] == 61) {
            rem = 3;
        }
        if (rem > 2 && this.decode_buffer[2] == 61) {
            rem = 2;
        }
        switch (rem) {
            case 4: {
                d2 = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                c2 = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                b2 = pem_convert_array[this.decode_buffer[1] & 0xFF];
                a2 = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        switch (rem) {
            case 2: {
                outStream.write((byte)(a2 << 2 & 0xFC | b2 >>> 4 & 3));
                break;
            }
            case 3: {
                outStream.write((byte)(a2 << 2 & 0xFC | b2 >>> 4 & 3));
                outStream.write((byte)(b2 << 4 & 0xF0 | c2 >>> 2 & 0xF));
                break;
            }
            case 4: {
                outStream.write((byte)(a2 << 2 & 0xFC | b2 >>> 4 & 3));
                outStream.write((byte)(b2 << 4 & 0xF0 | c2 >>> 2 & 0xF));
                outStream.write((byte)(c2 << 6 & 0xC0 | d2 & 0x3F));
            }
        }
    }

    @Override
    protected int readFully(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        for (int i2 = 0; i2 < len; ++i2) {
            int q2 = in.read();
            if (q2 == -1) {
                return i2 == 0 ? -1 : i2;
            }
            if (q2 == 13 || q2 == 10 || q2 == 32 || q2 == 9) {
                --i2;
                continue;
            }
            buffer[i2 + offset] = (byte)q2;
        }
        return len;
    }

    static {
        int i2;
        pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        pem_convert_array = new byte[256];
        for (i2 = 0; i2 < 255; ++i2) {
            BASE64Decoder.pem_convert_array[i2] = -1;
        }
        for (i2 = 0; i2 < pem_array.length; ++i2) {
            BASE64Decoder.pem_convert_array[BASE64Decoder.pem_array[i2]] = (byte)i2;
        }
    }
}

