/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;

final class RSAPublicKey
extends X509Key
implements java.security.interfaces.RSAPublicKey,
Serializable {
    static final long serialVersionUID = -6195576206650062694L;
    private BigInteger modulus;
    private BigInteger publicExponent;
    private static String[] z;

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
        RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
        try {
            DerValue[] derValueArray = new DerValue[]{new DerValue(2, bigInteger.toByteArray()), new DerValue(2, bigInteger2.toByteArray())};
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putSequence(derValueArray);
            this.key = derOutputStream.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0] + iOException.getMessage());
        }
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.a(this.modulus.bitLength(), this.publicExponent);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public String toString() {
        return z[2] + this.modulus.toString() + "\n" + z[3] + this.publicExponent.toString() + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            this.modulus = derValueArray[0].getInteger();
            if (this.modulus.signum() < 0) {
                this.modulus = new BigInteger(1, this.modulus.toByteArray());
            }
            this.publicExponent = derValueArray[1].getInteger();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(z[1] + exception.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block39: {
            int n2;
            int n3;
            block38: {
                char[] cArray2;
                Object var0;
                block37: {
                    int n4;
                    block36: {
                        char[] cArray3;
                        block35: {
                            int n5;
                            block34: {
                                char[] cArray4;
                                block33: {
                                    int n6;
                                    block32: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray5 = "\f\u001aK39O\u001bQ+}+0l\u007f8\u0001\u0016Q;8UU".toCharArray();
                                        cArray4 = cArray5;
                                        n6 = cArray5.length;
                                        n3 = 0;
                                        if (!true) break block32;
                                        n6 = n6;
                                        if (n6 <= n3) break block33;
                                    }
                                    do {
                                        int n7;
                                        cArray4 = cArray4;
                                        int n8 = n3;
                                        char c2 = cArray4[n8];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n7 = 111;
                                                break;
                                            }
                                            case 1: {
                                                n7 = 117;
                                                break;
                                            }
                                            case 2: {
                                                n7 = 62;
                                                break;
                                            }
                                            case 3: {
                                                n7 = 95;
                                                break;
                                            }
                                            default: {
                                                n7 = 93;
                                            }
                                        }
                                        cArray4[n8] = (char)(c2 ^ n7);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray6 = "&\u001bH>1\u0006\u0011\u001e48\u0016UH>1\u001a\u0010\u001eU".toCharArray();
                                cArray3 = cArray6;
                                n5 = cArray6.length;
                                n3 = 0;
                                if (!true) break block34;
                                n5 = n5;
                                if (n5 <= n3) break block35;
                            }
                            do {
                                int n9;
                                cArray3 = cArray3;
                                int n10 = n3;
                                char c3 = cArray3[n10];
                                switch (n3 % 5) {
                                    case 0: {
                                        n9 = 111;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 117;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 62;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 95;
                                        break;
                                    }
                                    default: {
                                        n9 = 93;
                                    }
                                }
                                cArray3[n10] = (char)(c3 ^ n9);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray7 = "&7s\u0015\u001e*Ul\f\u001cO%K=1\u0006\u0016\u001e\u00148\u0016O422\u000b\u0000R*.U\u007f".toCharArray();
                        cArray2 = cArray7;
                        n4 = cArray7.length;
                        n3 = 0;
                        if (!true) break block36;
                        n4 = n4;
                        if (n4 <= n3) break block37;
                    }
                    do {
                        int n11;
                        cArray2 = cArray2;
                        int n12 = n3;
                        char c4 = cArray2[n12];
                        switch (n3 % 5) {
                            case 0: {
                                n11 = 111;
                                break;
                            }
                            case 1: {
                                n11 = 117;
                                break;
                            }
                            case 2: {
                                n11 = 62;
                                break;
                            }
                            case 3: {
                                n11 = 95;
                                break;
                            }
                            default: {
                                n11 = 93;
                            }
                        }
                        cArray2[n12] = (char)(c4 ^ n11);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray8 = "\u001f\u0000\\34\fU['-\u0000\u001b[1)U\u007f".toCharArray();
                cArray = cArray8;
                n2 = cArray8.length;
                n3 = 0;
                if (!true) break block38;
                n2 = n2;
                if (n2 <= n3) break block39;
            }
            do {
                int n13;
                cArray = cArray;
                int n14 = n3;
                char c5 = cArray[n14];
                switch (n3 % 5) {
                    case 0: {
                        n13 = 111;
                        break;
                    }
                    case 1: {
                        n13 = 117;
                        break;
                    }
                    case 2: {
                        n13 = 62;
                        break;
                    }
                    case 3: {
                        n13 = 95;
                        break;
                    }
                    default: {
                        n13 = 93;
                    }
                }
                cArray[n14] = (char)(c5 ^ n13);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
    }
}

