/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.PagesVersionHandler;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.JspVisitorResult;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspVisitor;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public abstract class JspVisitor {
    protected JspVisitorUsage visitorUsage;
    protected JspConfiguration jspConfiguration;
    protected JspCoreContext context;
    protected HashMap resultMap;
    protected JspVisitorInputMap inputMap;
    protected int visitCount;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.JspVisitor";
    static final long serialVersionUID = 6500079292618846443L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{visitorUsage, jspConfiguration, context, resultMap, inputMap});
        }
        this.visitorUsage = null;
        this.jspConfiguration = null;
        this.context = null;
        this.resultMap = null;
        this.inputMap = null;
        this.visitCount = 0;
        this.visitorUsage = visitorUsage;
        this.jspConfiguration = jspConfiguration;
        this.context = context;
        this.resultMap = resultMap;
        this.inputMap = inputMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    protected abstract void visitJspRootStart(Element var1) throws JspCoreException;

    protected abstract void visitJspRootEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspTextStart(Element var1) throws JspCoreException;

    protected abstract void visitJspTextEnd(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitIncludeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitPageDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitTagDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitAttributeDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveStart(Element var1) throws JspCoreException;

    protected abstract void visitVariableDirectiveEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDeclarationEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionStart(Element var1) throws JspCoreException;

    protected abstract void visitJspExpressionEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletStart(Element var1) throws JspCoreException;

    protected abstract void visitJspScriptletEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsStart(Element var1) throws JspCoreException;

    protected abstract void visitJspParamsEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackStart(Element var1) throws JspCoreException;

    protected abstract void visitJspFallbackEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspIncludeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardStart(Element var1) throws JspCoreException;

    protected abstract void visitJspForwardEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanStart(Element var1) throws JspCoreException;

    protected abstract void visitJspUseBeanEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspGetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspSetPropertyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginStart(Element var1) throws JspCoreException;

    protected abstract void visitJspPluginEnd(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagStart(Element var1) throws JspCoreException;

    protected abstract void visitCustomTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspAttributeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspElementStart(Element var1) throws JspCoreException;

    protected abstract void visitJspElementEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeStart(Element var1) throws JspCoreException;

    protected abstract void visitJspInvokeEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyStart(Element var1) throws JspCoreException;

    protected abstract void visitJspDoBodyEnd(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputStart(Element var1) throws JspCoreException;

    protected abstract void visitJspOutputEnd(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagStart(Element var1) throws JspCoreException;

    protected abstract void visitUninterpretedTagEnd(Element var1) throws JspCoreException;

    protected abstract void visitCDataTag(CDATASection var1) throws JspCoreException;

    public abstract JspVisitorResult getResult() throws JspCoreException;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isElementTagDependent(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isElementTagDependent", new Object[]{jspElement});
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isElementTagDependent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean isNodeTagDependent(Node node) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isNodeTagDependent", new Object[]{node});
        }
        if (node == null || node.getNodeType() != 1) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isNodeTagDependent", bl);
            }
            return bl;
        }
        boolean bl = this.isElementTagDependent((Element)node);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isNodeTagDependent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean shouldSkipChildrenForThisVisitor() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "shouldSkipChildrenForThisVisitor", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "shouldSkipChildrenForThisVisitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected boolean shouldSkipChildren(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "shouldSkipChildren", new Object[]{jspElement});
        }
        if (!this.shouldSkipChildrenForThisVisitor()) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
            }
            return bl;
        }
        String uri = jspElement.getNamespaceURI();
        String name = jspElement.getLocalName();
        if (uri.equalsIgnoreCase("http://java.sun.com/JSP/Page") && name.equalsIgnoreCase("body")) {
            boolean bl = this.isNodeTagDependent(jspElement.getParentNode());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
            }
            return bl;
        }
        if (!this.isElementTagDependent(jspElement)) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
            }
            return bl;
        }
        NodeList children = jspElement.getChildNodes();
        if (children.getLength() == 0) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
            }
            return bl;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            String elemURI;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !(elemURI = (element = (Element)node).getNamespaceURI()).equalsIgnoreCase("http://java.sun.com/JSP/Page")) continue;
            String elemName = element.getLocalName();
            if (elemName.equalsIgnoreCase("attribute") || elemName.equalsIgnoreCase("body")) {
                boolean bl = false;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    bl = bl;
                    logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
                }
                return bl;
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "shouldSkipChildren", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void visit(Document jspDocument, int visitCount) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visit", new Object[]{jspDocument, visitCount});
        }
        this.visitCount = visitCount;
        NodeList jspNodes = jspDocument.getChildNodes();
        for (int i = 0; i < jspNodes.getLength(); ++i) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visit", "jspNodes.item(i) =[" + jspNodes.item(i) + "]");
            }
            Node jspNode = jspNodes.item(i);
            this.processJspElement(jspNode);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void processJspElement(Node jspNode) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "processJspElement", new Object[]{jspNode});
        }
        if (jspNode.getNodeType() == 1) {
            Element jspElement = (Element)jspNode;
            String namespaceURI = jspElement.getNamespaceURI();
            String jspElementType = jspElement.getLocalName();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "jspElement =[" + jspElement + "]  namespaceURI= [" + namespaceURI + "] jspElementType= [ " + jspElementType + "]");
            }
            if (namespaceURI != null && namespaceURI.equals("http://java.sun.com/JSP/Page")) {
                if (jspElementType.equals("root")) {
                    this.visitJspRootStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspRootEnd(jspElement);
                } else if (jspElementType.equals("text")) {
                    this.visitJspTextStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspTextEnd(jspElement);
                } else if (jspElementType.equals("directive.include")) {
                    this.visitIncludeDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitIncludeDirectiveEnd(jspElement);
                } else if (jspElementType.equals("directive.page")) {
                    this.visitPageDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitPageDirectiveEnd(jspElement);
                } else if (jspElementType.equals("directive.tag")) {
                    this.visitTagDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitTagDirectiveEnd(jspElement);
                } else if (jspElementType.equals("directive.attribute")) {
                    this.visitAttributeDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitAttributeDirectiveEnd(jspElement);
                } else if (jspElementType.equals("directive.variable")) {
                    this.visitVariableDirectiveStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitVariableDirectiveEnd(jspElement);
                } else if (jspElementType.equals("declaration")) {
                    this.visitJspDeclarationStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspDeclarationEnd(jspElement);
                } else if (jspElementType.equals("expression")) {
                    this.visitJspExpressionStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspExpressionEnd(jspElement);
                } else if (jspElementType.equals("scriptlet")) {
                    this.visitJspScriptletStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspScriptletEnd(jspElement);
                } else if (jspElementType.equals("param")) {
                    this.visitJspParamStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspParamEnd(jspElement);
                } else if (jspElementType.equals("params")) {
                    if (PagesVersionHandler.isPages30OrLowerLoaded()) {
                        this.visitJspParamsStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspParamsEnd(jspElement);
                    } else if (this.getClass().equals(ValidateJspVisitor.class)) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Processing Validation for the jsp:params element");
                        }
                        this.visitJspParamsStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspParamsEnd(jspElement);
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Skipping the jsp:params element as it is a no operation for Pages 3.1+");
                    }
                } else if (jspElementType.equals("fallback")) {
                    if (PagesVersionHandler.isPages30OrLowerLoaded()) {
                        this.visitJspFallbackStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspFallbackEnd(jspElement);
                    } else if (this.getClass().equals(ValidateJspVisitor.class)) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Processing Validation for the jsp:fallback element");
                        }
                        this.visitJspFallbackStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspFallbackEnd(jspElement);
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Skipping the jsp:fallback element as it is a no operation for Pages 3.1+");
                    }
                } else if (jspElementType.equals("include")) {
                    this.visitJspIncludeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspIncludeEnd(jspElement);
                } else if (jspElementType.equals("forward")) {
                    this.visitJspForwardStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspForwardEnd(jspElement);
                } else if (jspElementType.equals("useBean")) {
                    this.visitJspUseBeanStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspUseBeanEnd(jspElement);
                } else if (jspElementType.equals("getProperty")) {
                    this.visitJspGetPropertyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspGetPropertyEnd(jspElement);
                } else if (jspElementType.equals("setProperty")) {
                    this.visitJspSetPropertyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspSetPropertyEnd(jspElement);
                } else if (jspElementType.equals("plugin")) {
                    if (PagesVersionHandler.isPages30OrLowerLoaded()) {
                        this.visitJspPluginStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspPluginEnd(jspElement);
                    } else if (this.getClass().equals(ValidateJspVisitor.class)) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Processing Validation for the jsp:plugin element");
                        }
                        this.visitJspPluginStart(jspElement);
                        this.processChildren(jspElement);
                        this.visitJspPluginEnd(jspElement);
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                        logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "Skipping the jsp:plugin element as it is a no operation for Pages 3.1+");
                    }
                } else if (jspElementType.equals("attribute")) {
                    this.visitJspAttributeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspAttributeEnd(jspElement);
                } else if (jspElementType.equals("element")) {
                    this.visitJspElementStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspElementEnd(jspElement);
                } else if (jspElementType.equals("body")) {
                    this.visitJspBodyStart(jspElement);
                    if (!this.shouldSkipChildren(jspElement)) {
                        this.processChildren(jspElement);
                    }
                    this.visitJspBodyEnd(jspElement);
                } else if (jspElementType.equals("invoke")) {
                    this.visitJspInvokeStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspInvokeEnd(jspElement);
                } else if (jspElementType.equals("doBody")) {
                    this.visitJspDoBodyStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspDoBodyEnd(jspElement);
                } else {
                    if (!jspElementType.equals("output")) throw new JspTranslationException(jspElement, "jsp.error.element.unknown", new Object[]{jspElement.getTagName()});
                    this.visitJspOutputStart(jspElement);
                    this.processChildren(jspElement);
                    this.visitJspOutputEnd(jspElement);
                }
            } else if (jspElement.getTagName().indexOf(58) != -1) {
                this.visitCustomTagStart(jspElement);
                if (!this.shouldSkipChildren(jspElement)) {
                    this.processChildren(jspElement);
                }
                this.visitCustomTagEnd(jspElement);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagStart(jspElement), jspElement =[" + jspElement + "]");
                }
                this.visitUninterpretedTagStart(jspElement);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call processChildren(jspElement), jspElement =[" + jspElement + "]");
                }
                this.processChildren(jspElement);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "processJspElement", "About to call visitUninterpretedTagEnd(jspElement), jspElement =[" + jspElement + "]");
                }
                this.visitUninterpretedTagEnd(jspElement);
            }
        } else if (jspNode.getNodeType() == 4) {
            CDATASection cdata = (CDATASection)jspNode;
            Node parentNode = jspNode.getParentNode();
            if (parentNode.getNamespaceURI() != null && parentNode.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                if (parentNode.getLocalName().equals("text") || parentNode.getLocalName().equals("expression") || parentNode.getLocalName().equals("declaration") || parentNode.getLocalName().equals("scriptlet")) {
                    if (this.isNodeTagDependent(parentNode)) {
                        this.visitCDataTag(cdata);
                    }
                } else {
                    this.visitCDataTag(cdata);
                }
            } else {
                this.visitCDataTag(cdata);
            }
        }
        if (logger == null || !logger.isLoggable(Level.FINER)) return;
        logger.exiting(CLASS_NAME, "processJspElement");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void processChildren(Node jspNode) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "processChildren", new Object[]{jspNode});
        }
        NodeList childJspNodes = jspNode.getChildNodes();
        for (int i = 0; i < childJspNodes.getLength(); ++i) {
            Node n = childJspNodes.item(i);
            this.processJspElement(n);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "processChildren");
        }
    }
}

