/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.parsers.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.util.ManifestHeaderUtils;
import org.apache.aries.util.VersionRange;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManifestHeaderProcessor {
    public static final String NESTED_FILTER_ATTRIBUTE = "org.apache.aries.application.filter.attribute";
    private static final Pattern FILTER_ATTR;
    private static final String LESS_EQ_OP = "<=";
    private static final String GREATER_EQ_OP = ">=";
    private static final String EQ_OP = "=";
    static final long serialVersionUID = -4654825076777364807L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static List<String> split(String value, String delimiter) {
        return ManifestHeaderUtils.split((String)value, (String)delimiter);
    }

    private static List<NameValuePair> genericNameWithNameValuePairProcess(String s) {
        String name;
        Map<String, String> params = null;
        ArrayList<NameValuePair> nameValues = new ArrayList<NameValuePair>();
        ArrayList<String> pkgs = new ArrayList<String>();
        int index = s.indexOf(";");
        if (index == -1) {
            name = s;
            params = new HashMap<String, String>();
            pkgs.add(name);
        } else {
            name = s.substring(0, index).trim();
            String tail = s.substring(index + 1).trim();
            pkgs.add(name);
            StringBuilder parameters = new StringBuilder();
            List<String> tailParts = ManifestHeaderProcessor.split(tail, ";");
            boolean firstParameter = false;
            for (String part : tailParts) {
                if (!part.contains(EQ_OP)) {
                    if (firstParameter) continue;
                    pkgs.add(part);
                    continue;
                }
                if (!firstParameter) {
                    firstParameter = true;
                }
                parameters.append(part + ";");
            }
            if (parameters.length() != 0) {
                if (parameters.toString().endsWith(";")) {
                    parameters = parameters.deleteCharAt(parameters.length() - 1);
                }
                params = ManifestHeaderProcessor.genericNameValueProcess(parameters.toString());
            }
        }
        for (String pkg : pkgs) {
            nameValues.add(new NameValuePair(pkg, params));
        }
        return nameValues;
    }

    private static Map<String, String> genericNameValueProcess(String s) {
        HashMap<String, String> params = new HashMap<String, String>();
        List<String> parameters = ManifestHeaderProcessor.split(s, ";");
        for (String parameter : parameters) {
            String first;
            List<String> parts = ManifestHeaderProcessor.split(parameter, EQ_OP);
            if (parts.size() != 2) continue;
            String second = parts.get(1).trim();
            if (second.startsWith("\"") && second.endsWith("\"")) {
                second = second.substring(1, second.length() - 1);
            }
            if ((first = parts.get(0).trim()).endsWith(":")) {
                first = first.substring(0, first.length() - 1).trim() + ":";
            }
            params.put(first, second);
        }
        return params;
    }

    public static List<GenericMetadata> parseRequirementString(String s) {
        return ManifestHeaderProcessor.parseGenericMetadata(s);
    }

    private static List<GenericMetadata> parseGenericMetadata(String s) {
        ArrayList<GenericMetadata> capabilities = new ArrayList<GenericMetadata>();
        List<String> entries = ManifestHeaderProcessor.split(s, ",");
        for (String e : entries) {
            List<NameValuePair> nvpList = ManifestHeaderProcessor.genericNameWithNameValuePairProcess(e);
            for (NameValuePair nvp : nvpList) {
                String namespace = nvp.getName();
                GenericMetadata cap = new GenericMetadata(namespace);
                capabilities.add(cap);
                Map<String, String> attrMap = nvp.getAttributes();
                for (Map.Entry<String, String> entry : attrMap.entrySet()) {
                    String k = entry.getKey();
                    String v = entry.getValue();
                    if (k.contains(":")) {
                        if (k.endsWith(":")) {
                            cap.getDirectives().put(k.substring(0, k.length() - 1), v);
                            continue;
                        }
                        ManifestHeaderProcessor.parseTypedAttribute(k, v, cap);
                        continue;
                    }
                    cap.getAttributes().put(k, v);
                }
            }
        }
        return capabilities;
    }

    private static void parseTypedAttribute(String k, String v, GenericMetadata cap) {
        int idx = k.indexOf(58);
        String name = k.substring(0, idx);
        String type = k.substring(idx + 1);
        if (type.startsWith("List<") && type.endsWith(">")) {
            String subtype = type.substring("List<".length(), type.length() - 1).trim();
            ArrayList<Object> l = new ArrayList<Object>();
            for (String s : v.split(",")) {
                l.add(ManifestHeaderProcessor.getTypedValue(k, subtype, s));
            }
            cap.getAttributes().put(name, l);
        } else {
            cap.getAttributes().put(name, ManifestHeaderProcessor.getTypedValue(k, type.trim(), v));
        }
    }

    private static Object getTypedValue(String k, String type, String v) {
        if ("String".equals(type)) {
            return v;
        }
        if ("Long".equals(type)) {
            return Long.parseLong(v);
        }
        if ("Double".equals(type)) {
            return Double.parseDouble(v);
        }
        if ("Version".equals(type)) {
            return Version.parseVersion((String)v);
        }
        throw new IllegalArgumentException(k + EQ_OP + v);
    }

    public static VersionRange parseVersionRange(String s) throws IllegalArgumentException {
        return new VersionRange(s);
    }

    public static VersionRange parseVersionRange(String s, boolean exactVersion) throws IllegalArgumentException {
        return new VersionRange(s, exactVersion);
    }

    private static Map<String, String> parseFilterList(String filter) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet<String> negatedVersions = new HashSet<String>();
        HashSet<String> negatedBundleVersions = new HashSet<String>();
        String lowerVersion = null;
        String upperVersion = null;
        String lowerBundleVersion = null;
        String upperBundleVersion = null;
        Matcher m = FILTER_ATTR.matcher(filter);
        while (m.find()) {
            boolean negation = m.group(1) != null;
            String attr = m.group(2);
            String op = m.group(3);
            String value = m.group(4);
            if ("version".equals(attr)) {
                if (negation) {
                    negatedVersions.add(value);
                    continue;
                }
                if (GREATER_EQ_OP.equals(op)) {
                    lowerVersion = value;
                    continue;
                }
                if (LESS_EQ_OP.equals(op)) {
                    upperVersion = value;
                    continue;
                }
                if (EQ_OP.equals(op)) {
                    lowerVersion = value;
                    upperVersion = value;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if ("bundle-version".equals(attr)) {
                if (negation) {
                    negatedBundleVersions.add(value);
                    continue;
                }
                if (GREATER_EQ_OP.equals(op)) {
                    lowerBundleVersion = value;
                    continue;
                }
                if (LESS_EQ_OP.equals(op)) {
                    upperBundleVersion = value;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            result.put(attr, value);
        }
        if (lowerVersion != null) {
            StringBuilder versionAttr = new StringBuilder(lowerVersion);
            if (upperVersion != null) {
                versionAttr.append(",").append(upperVersion).insert(0, negatedVersions.contains(lowerVersion) ? (char)'(' : '[').append(negatedVersions.contains(upperVersion) ? (char)')' : ']');
            }
            result.put("version", versionAttr.toString());
        }
        if (lowerBundleVersion != null) {
            StringBuilder versionAttr = new StringBuilder(lowerBundleVersion);
            if (upperBundleVersion != null) {
                versionAttr.append(",").append(upperBundleVersion).insert(0, negatedBundleVersions.contains(lowerBundleVersion) ? (char)'(' : '[').append(negatedBundleVersions.contains(upperBundleVersion) ? (char)')' : ']');
            }
            result.put("bundle-version", versionAttr.toString());
        }
        return result;
    }

    public static Map<String, String> parseFilter(String filter) {
        Map<String, String> result = filter.startsWith("(&") ? ManifestHeaderProcessor.parseFilterList(filter.substring(2, filter.length() - 1)) : ManifestHeaderProcessor.parseFilterList(filter);
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor", ManifestHeaderProcessor.class, null, null);
        FILTER_ATTR = Pattern.compile("(\\(!)?\\((.*?)([<>]?=)(.*?)\\)\\)?");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NameValueList
    extends ArrayList<NameValuePair>
    implements NameValueCollection,
    List<NameValuePair>,
    Traceable {
        private static final long serialVersionUID = 1808636823825029983L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void addToCollection(String n, Map<String, String> v) {
            this.add(new NameValuePair(n, v));
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            boolean first = true;
            for (NameValuePair nvp : this) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(nvp.toString());
            }
            sb.append("}");
            return sb.toString();
        }

        public String toTraceString() {
            return this.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor$NameValueList", NameValueList.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NameValueMap
    extends HashMap<String, Map<String, String>>
    implements NameValueCollection,
    Map<String, Map<String, String>> {
        private static final long serialVersionUID = -6446338858542599141L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public void addToCollection(String n, Map<String, String> v) {
            this.put(n, v);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (Map.Entry entry : this.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append((String)entry.getKey() + "->" + entry.getValue());
            }
            sb.append("}");
            return sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor$NameValueMap", NameValueMap.class, null, null);
        }
    }

    public static interface NameValueCollection {
        public void addToCollection(String var1, Map<String, String> var2);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class NameValuePair {
        private String name;
        private Map<String, String> attributes;
        static final long serialVersionUID = 6730472350096965942L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public NameValuePair(String name, Map<String, String> value) {
            this.name = name;
            this.attributes = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> value) {
            this.attributes = value;
        }

        public String toString() {
            return "{" + this.name.toString() + "::" + this.attributes.toString() + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameValuePair other = (NameValuePair)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor$NameValuePair", NameValuePair.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class GenericMetadata {
        private final String namespace;
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, String> directives = new HashMap<String, String>();
        static final long serialVersionUID = -1443150752814394761L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public GenericMetadata(String namespace) {
            this.namespace = namespace;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.parsers.internal.ManifestHeaderProcessor$GenericMetadata", GenericMetadata.class, null, null);
        }
    }
}

