/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.utils.TokenBuilder;
import com.ibm.ws.security.jwt.web.JwtRequest;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JwtEndpointServices.class}, name="com.ibm.ws.security.jwt.web.JwtEndpointServices", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JwtEndpointServices {
    private static TraceComponent tc = Tr.register(JwtEndpointServices.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    public static final String KEY_ID = "id";
    public static final String KEY_JWT_CONFIG = "jwtConfig";
    private final ConcurrentServiceReferenceMap<String, JwtConfig> jwtConfigRef = new ConcurrentServiceReferenceMap("jwtConfig");
    static final long serialVersionUID = 1246208993612745366L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtConfig.class, name="jwtConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setJwtConfig(ServiceReference<JwtConfig> ref) {
        ConcurrentServiceReferenceMap<String, JwtConfig> concurrentServiceReferenceMap = this.jwtConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting reference for " + ref.getProperty(KEY_ID)), (Object[])new Object[0]);
            }
            this.jwtConfigRef.putReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtConfig(ServiceReference<JwtConfig> ref) {
        ConcurrentServiceReferenceMap<String, JwtConfig> concurrentServiceReferenceMap = this.jwtConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.jwtConfigRef.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
        }
    }

    @Activate
    protected void activate(ComponentContext cc) {
        this.jwtConfigRef.activate(cc);
        Tr.info((TraceComponent)tc, (String)"JWT_ENDPOINT_SERVICE_ACTIVATED", (Object[])new Object[0]);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.jwtConfigRef.deactivate(cc);
    }

    protected void handleEndpointRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws IOException {
        JwtRequest jwtRequest = this.getJwtRequest(request, response);
        if (jwtRequest == null) {
            return;
        }
        String jwtConfigId = jwtRequest.getJwtConfigId();
        JwtConfig jwtConfig = this.getJwtConfig(response, jwtConfigId);
        if (jwtConfig == null) {
            return;
        }
        JwtRequest.EndpointType endpointType = jwtRequest.getType();
        this.handleJwtRequest(request, response, servletContext, jwtConfig, endpointType);
    }

    private JwtRequest getJwtRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JwtRequest jwtRequest = (JwtRequest)request.getAttribute("JwtRequest");
        if (jwtRequest == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_REQUEST_ATTRIBUTE_MISSING", (Object[])new Object[]{request.getRequestURI(), "JwtRequest"});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404, errorMsg);
        }
        return jwtRequest;
    }

    private JwtConfig getJwtConfig(HttpServletResponse response, String jwtConfigId) throws IOException {
        JwtConfig jwtConfig = (JwtConfig)this.jwtConfigRef.getService((Object)jwtConfigId);
        if (jwtConfig == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONFIG_SERVICE_NOT_AVAILABLE", (Object[])new Object[]{jwtConfigId});
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404, errorMsg);
        }
        return jwtConfig;
    }

    protected void handleJwtRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, JwtConfig jwtConfig, JwtRequest.EndpointType endpointType) throws IOException {
        if (jwtConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No JwtConfig object provided", (Object[])new Object[0]);
            }
            return;
        }
        switch (endpointType) {
            case jwk: {
                this.processJWKRequest(response, jwtConfig);
                return;
            }
            case token: {
                try {
                    if (!this.isTransportSecure(request)) {
                        String url = request.getRequestURL().toString();
                        Tr.error((TraceComponent)tc, (String)"SECURITY.JWT.ERROR.WRONG.HTTP.SCHEME", (Object[])new Object[]{url});
                        response.sendError(404, Tr.formatMessage((TraceComponent)tc, (String)"SECURITY.JWT.ERROR.WRONG.HTTP.SCHEME", (Object[])new Object[]{url}));
                        return;
                    }
                    boolean result = request.authenticate(response);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("request.authenticate result: " + result), (Object[])new Object[0]);
                    }
                    if (!result) {
                        return;
                    }
                }
                catch (ServletException result) {
                    FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.jwt.web.JwtEndpointServices", (String)"183", (Object)this, (Object[])new Object[]{request, response, servletContext, jwtConfig, endpointType});
                    return;
                }
                this.processTokenRequest(response, jwtConfig);
                return;
            }
        }
    }

    private boolean isTransportSecure(HttpServletRequest req) {
        req.getRequestURL().toString();
        if (req.getScheme().equals("https")) {
            return true;
        }
        String value = req.getHeader("X-Forwarded-Proto");
        return value != null && value.toLowerCase().equals("https");
    }

    /*
     * WARNING - void declaration
     */
    private void processTokenRequest(HttpServletResponse response, JwtConfig jwtConfig) throws IOException {
        block3: {
            String tokenString = new TokenBuilder().createTokenString(jwtConfig);
            this.addNoCacheHeaders(response);
            response.setStatus(200);
            if (tokenString == null) {
                return;
            }
            try {
                PrintWriter pw = response.getWriter();
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                pw.write("{\"token\": \"" + tokenString + "\"}");
                pw.flush();
                pw.close();
            }
            catch (IOException pw) {
                void e;
                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.jwt.web.JwtEndpointServices", (String)"240", (Object)this, (Object[])new Object[]{response, jwtConfig});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Caught an exception attempting to get the response writer: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processJWKRequest(HttpServletResponse response, JwtConfig jwtConfig) throws IOException {
        block4: {
            String signatureAlg = jwtConfig.getSignatureAlgorithm();
            if (!this.isPossibleJwkAlgorithm(signatureAlg)) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWK_ENDPOINT_WRONG_ALGORITHM", (Object[])new Object[]{jwtConfig.getId(), signatureAlg, this.getAcceptableJwkSignatureAlgorithms()});
                Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                response.sendError(400, errorMsg);
                return;
            }
            String jwkString = jwtConfig.getJwkJsonString();
            this.addNoCacheHeaders(response);
            response.setStatus(200);
            if (jwkString == null) {
                return;
            }
            try {
                PrintWriter pw = response.getWriter();
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                pw.write(jwkString);
                pw.flush();
                pw.close();
            }
            catch (IOException pw) {
                void e;
                FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.jwt.web.JwtEndpointServices", (String)"289", (Object)this, (Object[])new Object[]{response, jwtConfig});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught an exception attempting to get the response writer: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
    }

    boolean isPossibleJwkAlgorithm(String signatureAlgorithm) {
        return KeyAlgorithmChecker.isRSAlgorithm((String)signatureAlgorithm) || KeyAlgorithmChecker.isESAlgorithm((String)signatureAlgorithm);
    }

    String getAcceptableJwkSignatureAlgorithms() {
        return "RS256, RS384, RS512, ES256, ES384, ES512";
    }

    protected void addNoCacheHeaders(HttpServletResponse response) {
        String cacheControlValue = response.getHeader("Cache-Control");
        cacheControlValue = cacheControlValue != null && !cacheControlValue.isEmpty() ? cacheControlValue + ", " + "no-store" : "no-store";
        response.setHeader("Cache-Control", cacheControlValue);
        response.setHeader("Pragma", "no-cache");
    }
}

