/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.Claims;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.internal.ClaimsImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.registry.RegistryClaims;
import com.ibm.ws.security.jwt.utils.JweHelper;
import com.ibm.ws.security.jwt.utils.JwsSigner;
import com.ibm.ws.security.jwt.utils.JwtData;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtCreator {
    private static final String JTI_CLAIM = "jti";
    static final long serialVersionUID = 8093072144774381461L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={Exception.class})
    public static JwtResult createJwt(JwtData jwtData, Claims jwtclaims) throws JwtTokenException {
        boolean bJwt = jwtData.isJwt();
        try {
            String jwt = null;
            JwtClaims claims = new JwtClaims();
            if (bJwt) {
                claims = JwtCreator.populateClaims(jwtData, jwtclaims);
            }
            jwt = JwsSigner.getSignedJwt(claims, jwtData);
            if (jwtData.isJwe()) {
                jwt = JweHelper.createJweString(jwt, jwtData);
            }
            return new JwtResult(jwt, claims);
        }
        catch (Exception e) {
            JwtTokenException jte = JwtTokenException.newInstance(false, "JWT_CREATE_FAIL", new Object[]{e.getLocalizedMessage()});
            jte.initCause(e);
            throw jte;
        }
    }

    public static JwtClaims populateClaims(JwtData jwtData, Claims jwtclaims) throws MalformedClaimException {
        long nbfOffsetInSeconds;
        String issuer;
        String username;
        List<String> audiences;
        JwtClaims claims = new JwtClaims();
        String token_type = (String)jwtclaims.get("token_type");
        if (token_type != null) {
            claims.setClaim("token_type", (Object)token_type);
        }
        if ((audiences = jwtclaims.getAudience()) != null && audiences.size() > 0) {
            claims.setAudience(audiences);
        }
        if ((username = jwtclaims.getSubject()) != null) {
            claims.setSubject(username);
            if (jwtData.getConfig().getClaims() != null) {
                JwtCreator.addCustomClaims(claims, jwtData.getConfig(), username);
            }
        }
        for (Map.Entry<String, Object> e : jwtclaims.getAllClaims().entrySet()) {
            if (e.getKey() == "aud" || e.getKey() == "exp" || e.getKey() == JTI_CLAIM || e.getKey() == "iss" || e.getKey() == "iat" || e.getKey() == "nbf") continue;
            claims.setClaim(e.getKey(), e.getValue());
        }
        String jti = null;
        jti = jwtclaims.getJwtId();
        if (jti != null) {
            claims.setClaim(JTI_CLAIM, (Object)jti);
        }
        if ((issuer = jwtclaims.getIssuer()) != null) {
            claims.setIssuer(jwtclaims.getIssuer());
        }
        long validForInSeconds = jwtData.getConfig().getValidTime();
        long expTimeInSeconds = jwtclaims.getExpiration();
        long issueTimeInSeconds = jwtclaims.getIssuedAt();
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (expTimeInSeconds > 0L) {
            claims.setExpirationTime(NumericDate.fromSeconds((long)expTimeInSeconds));
        } else if (expTimeInSeconds == -2L) {
            claims.setExpirationTime(NumericDate.fromSeconds((long)(timeInSeconds + validForInSeconds)));
        }
        if (issueTimeInSeconds > 0L) {
            claims.setIssuedAt(NumericDate.fromSeconds((long)issueTimeInSeconds));
        } else if (issueTimeInSeconds == -2L) {
            claims.setIssuedAt(NumericDate.fromSeconds((long)timeInSeconds));
        }
        long notBeforeInSeconds = jwtclaims.getNotBefore();
        if (notBeforeInSeconds > 0L) {
            claims.setNotBefore(NumericDate.fromSeconds((long)notBeforeInSeconds));
        }
        if ((nbfOffsetInSeconds = jwtData.getConfig().getNbfOffsetTime()) >= 0L) {
            claims.setNotBefore(NumericDate.fromSeconds((long)(claims.getIssuedAt().getValue() + nbfOffsetInSeconds)));
        }
        return claims;
    }

    private static void addCustomClaims(JwtClaims claims, JwtConfig jwtConfig, String username) {
        Map<String, Object> customMap = null;
        RegistryClaims regClaims = new RegistryClaims(username);
        customMap = regClaims.fetchExtraClaims(jwtConfig);
        Set<Map.Entry<String, Object>> entries = customMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            claims.setClaim(entry.getKey(), entry.getValue());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JwtCreator", JwtCreator.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class JwtResult {
        private final String compact;
        private Map<String, Object> header;
        private final Claims claims = new ClaimsImpl();
        static final long serialVersionUID = 6362412338749548818L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public JwtResult(String compact, JwtClaims claims) throws Exception {
            this.compact = compact;
            this.initializeHeader();
            this.initializeClaims(claims);
        }

        public String getCompact() {
            return this.compact;
        }

        public Map<String, Object> getHeader() {
            return this.header;
        }

        public Claims getClaims() {
            return this.claims;
        }

        private void initializeClaims(JwtClaims jwtClaims) throws Exception {
            Map claimsMap = jwtClaims.getClaimsMap();
            if (claimsMap != null && !claimsMap.isEmpty()) {
                this.claims.putAll(claimsMap);
            }
        }

        private void initializeHeader() throws Exception {
            if (this.compact == null) {
                this.header = null;
            }
            String[] parts = JwtUtils.splitTokenString(this.compact);
            String headerString = JwtUtils.fromBase64ToJsonString(parts[0]);
            this.header = JwtUtils.claimsFromJson(headerString);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JwtCreator$JwtResult", JwtResult.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        }
    }
}

