/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtData;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivilegedAction;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwsSigner {
    static final long serialVersionUID = 6527624085469856615L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={Exception.class})
    public static String getSignedJwt(JwtClaims claims, JwtData jwtData) throws JwtTokenException {
        String jwt = null;
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        Key key = jwtData.getSigningKey();
        if (key == null && !"none".equals(jwtData.getSignatureAlgorithm())) {
            throw jwtData.getNoKeyException();
        }
        jws.setKey(key);
        String keyId = jwtData.getKeyID();
        if (keyId != null) {
            jws.setKeyIdHeaderValue(keyId);
        }
        if (jwtData.isJwt()) {
            jws.setHeader("typ", "JWT");
        }
        jws.setAlgorithmHeaderValue(jwtData.getSignatureAlgorithm());
        jws.setDoKeyValidation(false);
        try {
            jwt = jws.getCompactSerialization();
        }
        catch (Exception e) {
            throw new JwtTokenException(e.getLocalizedMessage(), e);
        }
        return jwt;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JwsSigner", JwsSigner.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
        AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 898381122016716981L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.setProperty("org.jose4j.jws.default-allow-none", "true");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jwt.utils.JwsSigner$1", 1.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
            }
        });
    }
}

