/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webserver.plugin.utility.tasks;

import com.ibm.ws.product.utility.CommandConsole;
import com.ibm.ws.product.utility.CommandTask;
import com.ibm.ws.webserver.plugin.utility.utils.CommandUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;

public abstract class BasePluginConfigCommandTask
implements CommandTask {
    static final String SLASH = "/";
    static final String NL = System.getProperty("line.separator");
    static final String TAB = "\t";
    protected String scriptName;
    protected Collection<String> reqArgs = new HashSet<String>();
    protected Collection<String> knownArgs = new HashSet<String>();

    public BasePluginConfigCommandTask(String scriptName) {
        this.scriptName = scriptName;
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    protected String getOption(String key, Object ... args) {
        return CommandUtils.getOption(key, args);
    }

    protected String buildScriptOptions(String optionKeyPrefix, String optionDescPrefix) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefix != null && !optionDescPrefix.isEmpty()) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                    scriptOptions.append(NL);
                }
            }
        }
        return scriptOptions.toString();
    }

    protected String buildScriptOptions(String optionKeyPrefix, String[] optionDescPrefixes) {
        StringBuilder scriptOptions = new StringBuilder();
        if (optionKeyPrefix != null && !optionKeyPrefix.isEmpty() && optionDescPrefixes != null && optionDescPrefixes.length != 0) {
            Enumeration<String> keys = CommandUtils.getOptions().getKeys();
            TreeSet<String> optionKeys = new TreeSet<String>();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!key.startsWith(optionKeyPrefix)) continue;
                optionKeys.add(key);
            }
            if (optionKeys.size() > 0) {
                for (String optionKey : optionKeys) {
                    String option = optionKey.substring(optionKeyPrefix.length());
                    scriptOptions.append(NL);
                    scriptOptions.append(CommandUtils.getOptions().getString(optionKey));
                    scriptOptions.append(NL);
                    for (String optionDescPrefix : optionDescPrefixes) {
                        scriptOptions.append(CommandUtils.getOptions().getString(optionDescPrefix + option));
                        scriptOptions.append(NL);
                    }
                }
            }
        }
        return scriptOptions.toString();
    }

    private String getValue(String arg) {
        String[] split = arg.split("=");
        if (split.length == 1) {
            return null;
        }
        if (split.length == 2) {
            return split[1];
        }
        StringBuffer value = new StringBuffer();
        for (int i = 1; i < split.length; ++i) {
            value.append(split[i]);
            if (i >= split.length - 1) continue;
            value.append("=");
        }
        return value.toString();
    }

    private String getArgName(String arg) {
        return arg.split("=")[0];
    }

    private boolean isKnownArgument(String arg) {
        String argName = this.getArgName(arg);
        for (String key : this.knownArgs) {
            if (!key.equalsIgnoreCase(argName)) continue;
            return true;
        }
        return false;
    }

    protected void validateArgumentList(String[] args, boolean supportsDefaultTarget) {
        this.validateArgumentList(args, true, supportsDefaultTarget);
    }

    protected void validateArgumentList(String[] args, boolean supportsTarget, boolean supportsDefaultTarget) {
        this.checkRequiredArguments(args, !supportsTarget || supportsDefaultTarget);
        int firstArg = 1;
        if (supportsTarget) {
            String primArg;
            if (!supportsDefaultTarget) {
                firstArg = 2;
            } else if (args.length > 1 && !(primArg = args[1]).startsWith("-")) {
                firstArg = 2;
            }
        }
        for (int i = firstArg; i < args.length; ++i) {
            String argName = this.getArgName(args[i]);
            if (!this.isKnownArgument(argName)) {
                throw new IllegalArgumentException(this.getMessage("invalidArg", argName));
            }
            if (args[i].contains("=")) continue;
            throw new IllegalArgumentException(this.getMessage("missingValue", argName));
        }
    }

    private void checkRequiredArguments(String[] args, boolean supportsDefaultTarget) {
        StringBuilder message = new StringBuilder();
        int additionalArgs = supportsDefaultTarget ? 1 : 2;
        if (args.length < this.reqArgs.size() + additionalArgs) {
            message.append(this.getMessage("insufficientArgs", new Object[0]));
            message.append(NL);
        }
        if (!supportsDefaultTarget && (args.length < 2 || args[1].startsWith("-"))) {
            message.append(this.getMessage("missingServerName", new Object[0]));
            message.append(NL);
        }
        for (String reqArg : this.reqArgs) {
            String lowerReqArg = reqArg.toLowerCase();
            boolean argFound = false;
            for (String arg : args) {
                if (!arg.toLowerCase().startsWith(lowerReqArg)) continue;
                argFound = true;
                break;
            }
            if (argFound) continue;
            message.append(this.getMessage("missingArg", reqArg));
            message.append(NL);
        }
        if (!message.toString().isEmpty()) {
            throw new IllegalArgumentException(message.toString());
        }
    }

    protected String getArgumentValue(String arg, String[] args, String defalt) {
        String argName = this.getArgName(arg);
        for (int i = 1; i < args.length; ++i) {
            String currentArgName = this.getArgName(args[i]);
            if (!currentArgName.equalsIgnoreCase(argName)) continue;
            return this.getValue(args[i]);
        }
        return defalt;
    }

    protected String getTaskHelp(String desc, String usage, String optionKeyPrefix, String optionDescPrefix, String addonKey, String footer, Object ... args) {
        StringBuilder scriptHelp = new StringBuilder();
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.description", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(desc, new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption("global.usage", new Object[0]));
        scriptHelp.append(NL);
        scriptHelp.append(this.getOption(usage, new Object[0]));
        scriptHelp.append(NL);
        String options = this.buildScriptOptions(optionKeyPrefix, optionDescPrefix);
        if (!options.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption("global.options", new Object[0]));
            scriptHelp.append(options);
        }
        if (addonKey != null && !addonKey.isEmpty()) {
            scriptHelp.append(NL);
            scriptHelp.append(this.getOption(addonKey, new Object[0]));
        }
        if (footer != null && !footer.isEmpty()) {
            scriptHelp.append(footer);
        }
        scriptHelp.append(NL);
        if (args.length == 0) {
            return scriptHelp.toString();
        }
        return MessageFormat.format(scriptHelp.toString(), args);
    }

    protected void abort(CommandConsole console, String message) {
        console.printlnInfoMessage(this.getMessage("generateWebServerPluginTask.abort", new Object[0]));
        console.printlnErrorMessage(message);
    }
}

