/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.mp.jwt.MicroProfileJwtConfig;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.utils.JwtPrincipalMapping;
import com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIMappingHelper {
    private static TraceComponent tc = Tr.register(TAIMappingHelper.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    String INTERNAL_DISABLE_SSO_LTPA_CACHE = "com.ibm.ws.authentication.internal.sso.disable.ltpa.cache";
    String username = null;
    String realm = null;
    JwtPrincipalMapping claimToPrincipalMapping = null;
    MicroProfileJwtConfig config = null;
    JsonWebToken jwtPrincipal = null;
    Hashtable<String, Object> customProperties = new Hashtable();
    protected static final String CCK_CLAIM = "sid";
    protected static final String APR_CLAIM = "apr";
    TAIJwtUtils taiJwtUtils = new TAIJwtUtils();
    static final long serialVersionUID = 470293064146763858L;

    public TAIMappingHelper(@Sensitive JwtToken jwtToken) throws MpJwtProcessingException {
        this.config = null;
        if (jwtToken != null) {
            this.claimToPrincipalMapping = new JwtPrincipalMapping(jwtToken, "upn", "groups", false);
            this.setUsername();
            this.setRealm();
        }
    }

    @ManualTrace
    public TAIMappingHelper(@Sensitive JwtToken jwtToken, MicroProfileJwtConfig clientConfig) throws MpJwtProcessingException {
        String methodName = "<init>";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken, clientConfig});
        }
        this.config = clientConfig;
        if (jwtToken != null) {
            this.claimToPrincipalMapping = new JwtPrincipalMapping(jwtToken, this.config.getUserNameAttribute(), this.config.getGroupNameAttribute(), this.config.getMapToUserRegistry());
            this.setUsername();
            this.setRealm();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    private void setRealm() {
        this.realm = this.claimToPrincipalMapping.getMappedRealm();
    }

    @ManualTrace
    public void createJwtPrincipalAndPopulateCustomProperties(@Sensitive JwtToken jwtToken, boolean addJwtPrincipal) throws MpJwtProcessingException {
        String methodName = "createJwtPrincipalAndPopulateCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken});
        }
        this.jwtPrincipal = this.createJwtPrincipal(jwtToken);
        String issuer = this.getIssuer(this.jwtPrincipal);
        this.customProperties = this.populateCustomProperties(issuer, this.getmaptoURconfig(), addJwtPrincipal);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    private boolean getmaptoURconfig() {
        if (this.config != null) {
            return this.config.getMapToUserRegistry();
        }
        return false;
    }

    @ManualTrace
    public Subject createSubjectFromCustomProperties(boolean addJwtPrincipalToSubject) {
        String methodName = "createSubjectFromCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{addJwtPrincipalToSubject});
        }
        Subject subject = new Subject();
        if (addJwtPrincipalToSubject) {
            subject.getPrincipals().add((Principal)this.jwtPrincipal);
            this.customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
        }
        this.customProperties.put("com.ibm.ws.authentication.internal.json.web.token", this.jwtPrincipal);
        subject.getPrivateCredentials().add(this.customProperties);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)subject);
        }
        return subject;
    }

    public String getUsername() {
        return this.username;
    }

    public Hashtable<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public JsonWebToken getJwtPrincipal() {
        return this.jwtPrincipal;
    }

    void setUsername() throws MpJwtProcessingException {
        if (this.claimToPrincipalMapping != null) {
            this.username = this.claimToPrincipalMapping.getMappedUser();
        }
        if (this.username == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"USERNAME_NOT_FOUND", (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg);
        }
    }

    @ManualTrace
    JsonWebToken createJwtPrincipal(@Sensitive JwtToken jwtToken) {
        String methodName = "createJwtPrincipal";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken});
        }
        if (this.claimToPrincipalMapping == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Claim to principal mapping object not initialized", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, null);
            }
            return null;
        }
        JsonWebToken token = this.taiJwtUtils.createJwtPrincipal(this.username, this.claimToPrincipalMapping.getMappedGroups(), jwtToken);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }

    @ManualTrace
    String getIssuer(@Sensitive JsonWebToken jwtPrincipal) throws MpJwtProcessingException {
        String methodName = "getIssuer";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtPrincipal});
        }
        if (jwtPrincipal == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"jwtPrincipal is null", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, null);
            }
            return null;
        }
        return jwtPrincipal.getIssuer();
    }

    @ManualTrace
    Hashtable<String, Object> populateCustomProperties(String issuer, boolean mapToUR, boolean addJwtPrincipal) {
        String methodName = "populateCustomProperties";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{issuer});
        }
        Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
        if (mapToUR) {
            customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            customProperties.put("com.ibm.wsspi.security.cred.userId", this.username);
        } else {
            if (this.realm == null && issuer != null) {
                this.realm = this.getRealm(issuer);
            }
            String uniqueID = this.getUniqueId(this.realm);
            List<String> groupswithrealm = this.getGroupsWithRealm(this.realm);
            customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
            if (this.realm != null && !this.realm.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.realm", this.realm);
            }
            if (!groupswithrealm.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.groups", groupswithrealm);
            }
            customProperties.put("com.ibm.wsspi.security.cred.securityName", this.username);
        }
        if (!addJwtPrincipal) {
            this.addCustomCacheKey(customProperties);
        } else {
            this.addCustomClaimsFromToken(customProperties);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, customProperties);
        }
        return customProperties;
    }

    public void addDisableSsoLtpaCacheProp() {
        this.customProperties.put(this.INTERNAL_DISABLE_SSO_LTPA_CACHE, true);
    }

    private void addCustomClaimsFromToken(Hashtable<String, Object> customProperties) {
        String apr;
        String cck = this.getCustomCacheKey();
        if (cck != null) {
            customProperties.put("com.ibm.wsspi.security.cred.cacheKey", cck);
        }
        if ((apr = this.getCustomAuthProvider()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"apr claim is set in the token : ", (Object[])new Object[]{apr});
            }
            customProperties.put("com.ibm.ws.authentication.internal.auth.provider", apr);
        }
    }

    private String getCustomAuthProvider() {
        Object apr;
        if (this.jwtPrincipal != null && (apr = this.jwtPrincipal.getClaim(APR_CLAIM)) != null && apr instanceof String) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"apr claim is set in the token : ", (Object[])new Object[]{(String)apr});
            }
            return (String)apr;
        }
        return null;
    }

    private void addCustomCacheKey(Hashtable<String, Object> customProperties) {
        if (this.jwtPrincipal != null) {
            String customCacheKey = HashUtils.digest((String)this.jwtPrincipal.getRawToken());
            customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
        }
    }

    private String getCustomCacheKey() {
        Object cck;
        if (this.jwtPrincipal != null && (cck = this.jwtPrincipal.getClaim(CCK_CLAIM)) != null) {
            return (String)cck;
        }
        return null;
    }

    @ManualTrace
    String getRealm(String issuer) {
        String realm;
        String methodName = "getRealm";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{issuer});
        }
        if (this.isRealmEndsWithSlash(realm = issuer)) {
            realm = this.updateRealm(realm);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)realm);
        }
        return realm;
    }

    private boolean isRealmEndsWithSlash(String realm) {
        return realm != null && realm.length() > 1 && realm.endsWith("/");
    }

    private String updateRealm(String realm) {
        return realm.substring(0, realm.length() - 1);
    }

    @ManualTrace
    String getUniqueId(String realm) {
        String methodName = "getUniqueId";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{realm});
        }
        String uniqueUser = null;
        if (this.claimToPrincipalMapping != null) {
            uniqueUser = this.claimToPrincipalMapping.getMappedUser();
        }
        String uniqueId = new StringBuffer("user:").append(realm).append("/").append(uniqueUser).toString();
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)uniqueId);
        }
        return uniqueId;
    }

    @ManualTrace
    List<String> getGroupsWithRealm(String realm) {
        String methodName = "getGroupsWithRealm";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{realm});
        }
        ArrayList<String> groups = null;
        if (this.claimToPrincipalMapping != null) {
            groups = this.claimToPrincipalMapping.getMappedGroups();
        }
        ArrayList<String> groupsWithRealm = new ArrayList<String>();
        if (groups != null) {
            for (String groupEntry : groups) {
                String group = new StringBuffer("group:").append(realm).append("/").append(groupEntry).toString();
                groupsWithRealm.add(group);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, groupsWithRealm);
        }
        return groupsWithRealm;
    }
}

