/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl;
import com.ibm.ws.security.mp.jwt.proxy.JsonWebTokenUtil;
import com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={JsonWebTokenUtil.class}, name="JsonWebTokenUtil", immediate=true, property={"service.vendor=IBM"})
public class JsonWebTokenUtilImpl
implements JsonWebTokenUtil {
    public static final TraceComponent tc = Tr.register(JsonWebTokenUtilImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    static final long serialVersionUID = -1969653279102311416L;

    @ManualTrace
    public Principal getJsonWebTokenPrincipal(Subject subject) {
        Set<JsonWebToken> jsonWebTokenPrincipal;
        String methodName = "getJsonWebTokenPrincipal";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{subject});
        }
        if ((jsonWebTokenPrincipal = subject.getPrincipals(JsonWebToken.class)).size() > 1) {
            this.multipleJsonWebTokenPrincipalsError(jsonWebTokenPrincipal);
        }
        if (!jsonWebTokenPrincipal.isEmpty()) {
            Principal principal = (Principal)jsonWebTokenPrincipal.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)principal);
            }
            return principal;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, null);
        }
        return null;
    }

    @ManualTrace
    public void addJsonWebToken(Subject subject, Hashtable<String, ?> customProperties, String key) {
        JsonWebToken jsonWebToken;
        String methodName = "addJsonWebToken";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{subject, customProperties, key});
        }
        if (customProperties != null && (jsonWebToken = (JsonWebToken)customProperties.get(key)) != null) {
            subject.getPrincipals().add((Principal)jsonWebToken);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @ManualTrace
    public Principal cloneJsonWebToken(Subject subject) {
        String methodName = "cloneJsonWebToken";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{subject});
        }
        if (this.getJsonWebTokenPrincipal(subject) != null) {
            JsonWebToken p = ((DefaultJsonWebTokenImpl)((Object)this.getJsonWebTokenPrincipal(subject))).clone();
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)p);
            }
            return p;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, null);
        }
        return null;
    }

    @ManualTrace
    public Principal getJsonWebToken(String jwt, String type, String username) {
        String methodName = "getJsonWebToken";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{username});
        }
        DefaultJsonWebTokenImpl jsonWebToken = new DefaultJsonWebTokenImpl(jwt, type, username);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)jsonWebToken);
        }
        return jsonWebToken;
    }

    public void addLoggedOutJwtToList(Principal p) {
        if (p instanceof JsonWebToken) {
            String jwt = ((JsonWebToken)p).getRawToken().toString();
            TAIJwtUtils.addLoggedOutJwtToList(jwt);
        }
    }

    private void multipleJsonWebTokenPrincipalsError(Set<JsonWebToken> principals) {
        String principalNames = null;
        for (JsonWebToken principal : principals) {
            if (principalNames == null) {
                principalNames = principal.getName();
                continue;
            }
            principalNames = principalNames + ", " + principal.getName();
        }
        Tr.warning((TraceComponent)tc, (String)"TOO_MANY_JWT_PRINCIPALS", (Object[])new Object[]{principalNames});
    }

    @Activate
    protected void activate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JsonWebTokenUtil service is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JsonWebTokenUtil service is deactivated", (Object[])new Object[0]);
        }
    }
}

