/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jcache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.jcache.CacheObject;
import io.openliberty.jcache.internal.CacheServiceImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CacheProxy
implements Cache<Object, Object> {
    private static final TraceComponent tc = Tr.register(CacheProxy.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
    private final Cache<Object, Object> cache;
    private final CacheServiceImpl cacheService;
    static final long serialVersionUID = -7780398413035681648L;

    public CacheProxy(Cache<Object, Object> cache, CacheServiceImpl cacheService) {
        if (cache == null) {
            throw new NullPointerException("The Cache cannot be null.");
        }
        if (cacheService == null) {
            throw new NullPointerException("The CacheService cannot be null.");
        }
        this.cache = cache;
        this.cacheService = cacheService;
    }

    public void clear() {
        this.cache.clear();
    }

    public void close() {
        this.cache.close();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<Object, Object> cacheEntryListenerConfiguration) {
        this.cache.deregisterCacheEntryListener(cacheEntryListenerConfiguration);
    }

    @Sensitive
    public Object get(Object key) {
        CacheObject jObject = (CacheObject)this.cache.get(key);
        return this.deserializeIfNecessary(jObject);
    }

    @Sensitive
    public Map<Object, Object> getAll(Set<? extends Object> keys) {
        Map values = this.cache.getAll(keys);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        for (Map.Entry entry : values.entrySet()) {
            results.put(entry.getKey(), this.deserializeIfNecessary((CacheObject)entry.getValue()));
        }
        return results;
    }

    @Sensitive
    public Object getAndPut(Object key, @Sensitive Object value) {
        CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
        CacheObject oldValue = (CacheObject)this.cache.getAndPut(key, (Object)newValue);
        if (oldValue != null) {
            return this.deserializeIfNecessary(oldValue);
        }
        return null;
    }

    @Sensitive
    public Object getAndRemove(Object key) {
        return this.deserializeIfNecessary((CacheObject)this.cache.getAndRemove(key));
    }

    @Sensitive
    public Object getAndReplace(Object key, @Sensitive Object value) {
        CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
        CacheObject oldValue = (CacheObject)this.cache.getAndReplace(key, (Object)newValue);
        if (oldValue != null) {
            return this.deserializeIfNecessary(oldValue);
        }
        return null;
    }

    public CacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public <C extends Configuration<Object, Object>> C getConfiguration(Class<C> clazz) {
        return (C)this.cache.getConfiguration(clazz);
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invoke(Object key, EntryProcessor<Object, Object, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        return (T)this.cache.invoke((Object)arguments, entryProcessor, arguments);
    }

    public <T> Map<Object, EntryProcessorResult<T>> invokeAll(Set<? extends Object> keys, EntryProcessor<Object, Object, T> entryProcessor, Object ... arguments) {
        return this.cache.invokeAll(keys, entryProcessor, arguments);
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public Iterator<Cache.Entry<Object, Object>> iterator() {
        return new CacheProxyIterator(this.cache.iterator());
    }

    public void loadAll(Set<? extends Object> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.cache.loadAll(keys, replaceExistingValues, completionListener);
    }

    public void put(Object key, @Sensitive Object value) {
        CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
        this.cache.put(key, (Object)newValue);
    }

    public void putAll(@Sensitive Map<? extends Object, ? extends Object> map) {
        HashMap<Object, CacheObject> values = new HashMap<Object, CacheObject>();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
            values.put(key, newValue);
        }
        this.cache.putAll(values);
    }

    public boolean putIfAbsent(Object key, @Sensitive Object value) {
        CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
        return this.cache.putIfAbsent(key, (Object)newValue);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<Object, Object> cacheEntryListenerConfiguration) {
        this.cache.registerCacheEntryListener(cacheEntryListenerConfiguration);
    }

    public boolean remove(Object key) {
        return this.cache.remove(key);
    }

    public boolean remove(Object key, @Sensitive Object oldValue) {
        CacheObject oldValue1 = new CacheObject(oldValue, this.cacheService.serialize(oldValue));
        return this.cache.remove(key, (Object)oldValue1);
    }

    public void removeAll() {
        this.cache.removeAll();
    }

    public void removeAll(Set<? extends Object> keys) {
        this.cache.removeAll(keys);
    }

    public boolean replace(Object key, @Sensitive Object value) {
        CacheObject newValue = new CacheObject(value, this.cacheService.serialize(value));
        return this.cache.replace(key, (Object)newValue);
    }

    public boolean replace(Object key, @Sensitive Object oldValue, @Sensitive Object newValue) {
        CacheObject oldValue1 = new CacheObject(oldValue, this.cacheService.serialize(oldValue));
        CacheObject newValue1 = new CacheObject(newValue, this.cacheService.serialize(newValue));
        return this.cache.replace(key, (Object)oldValue1, (Object)newValue1);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.cache.unwrap(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensitive
    private Object deserializeIfNecessary(@Sensitive CacheObject jObject) {
        if (jObject == null) {
            return null;
        }
        if (jObject.getObject() == null) {
            CacheObject cacheObject = jObject;
            synchronized (cacheObject) {
                if (jObject.getObject() == null) {
                    jObject.setObject(this.cacheService.deserialize(jObject.getObjectBytes()));
                }
            }
        }
        return jObject.getObject();
    }

    @Trivial
    private class CacheProxyIterator
    implements Iterator<Cache.Entry<Object, Object>> {
        private Iterator<Cache.Entry<Object, Object>> iterator;

        CacheProxyIterator(Iterator<Cache.Entry<Object, Object>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Cache.Entry<Object, Object> next() {
            Cache.Entry<Object, Object> entry = this.iterator.next();
            return entry != null ? new CacheEntryProxy(entry) : null;
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        @TraceOptions
        private class CacheEntryProxy
        implements Cache.Entry<Object, Object> {
            private Cache.Entry<Object, Object> entry;
            static final long serialVersionUID = -1583565143123402724L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            CacheEntryProxy(Cache.Entry<Object, Object> entry) {
                this.entry = entry;
            }

            public Object getKey() {
                return this.entry.getKey();
            }

            public Object getValue() {
                return CacheProxy.this.deserializeIfNecessary((CacheObject)this.entry.getValue());
            }

            public <T> T unwrap(Class<T> arg0) {
                return (T)this.entry.unwrap(arg0);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.jcache.internal.CacheProxy$CacheProxyIterator$CacheEntryProxy", CacheEntryProxy.class, (String)"jcache", (String)"io.openliberty.jcache.internal.resources.JCacheMessages");
            }
        }
    }
}

