/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_ExternalConstants;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_DataQueries
implements TargetCache_ExternalConstants {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected static final Logger queryLogger = AnnotationCacheServiceImpl_Logging.ANNO_QUERY_LOGGER;
    private final TargetCacheImpl_Factory factory;
    private final String appName;
    private final String e_appName;
    private final String modName;
    private final String e_modName;
    private final File modFile;
    private final File queriesFile;
    private boolean isSetWriter;
    private TargetCacheImpl_Writer writer;
    static final long serialVersionUID = -6466703216781063063L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_DataQueries(TargetCacheImpl_Factory factory, String appName, String e_appName, String modName, String e_modName, File modFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "<init>", new Object[]{factory, appName, e_appName, modName, e_modName, modFile});
        }
        this.factory = factory;
        this.appName = appName;
        this.e_appName = e_appName;
        this.modName = modName;
        this.e_modName = e_modName;
        this.modFile = modFile;
        this.queriesFile = modFile == null ? null : new File(modFile, "queries");
        this.isSetWriter = this.queriesFile == null;
        this.writer = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getFactory", new Object[0]);
        }
        TargetCacheImpl_Factory targetCacheImpl_Factory = this.factory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_Factory = targetCacheImpl_Factory;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getFactory", targetCacheImpl_Factory);
        }
        return targetCacheImpl_Factory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAppName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getAppName", new Object[0]);
        }
        String string = this.appName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getAppName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_getAppName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "e_getAppName", new Object[0]);
        }
        String string = this.e_appName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "e_getAppName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getModName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getModName", new Object[0]);
        }
        String string = this.modName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getModName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String e_getModName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "e_getModName", new Object[0]);
        }
        String string = this.e_modName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "e_getModName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public File getModFile() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getModFile", new Object[0]);
        }
        File file = this.modFile;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            file = file;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getModFile", file);
        }
        return file;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public File getQueriesFile() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getQueriesFile", new Object[0]);
        }
        File file = this.queriesFile;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            file = file;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getQueriesFile", file);
        }
        return file;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized TargetCacheImpl_Writer getWriter() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getWriter", new Object[0]);
        }
        if (!this.isSetWriter) {
            FileOutputStream outputStream;
            boolean isNew;
            this.isSetWriter = true;
            boolean bl = isNew = !UtilImpl_FileUtils.exists(this.queriesFile);
            if (isNew && !UtilImpl_FileUtils.ensureDir(logger, this.modFile)) {
                TargetCacheImpl_Writer targetCacheImpl_Writer = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    targetCacheImpl_Writer = targetCacheImpl_Writer;
                    logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getWriter", targetCacheImpl_Writer);
                }
                return targetCacheImpl_Writer;
            }
            try {
                outputStream = UtilImpl_FileUtils.createFileOutputStream(this.queriesFile, true);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", (String)"194", (Object)this, (Object[])new Object[0]);
                TargetCacheImpl_Writer targetCacheImpl_Writer = null;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    targetCacheImpl_Writer = targetCacheImpl_Writer;
                    logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getWriter", targetCacheImpl_Writer);
                }
                return targetCacheImpl_Writer;
            }
            this.writer = this.factory.createWriter(this.queriesFile.getPath(), outputStream);
            if (this.writer != null) {
                try {
                    this.writer.writeQueryHeader();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", (String)"207", (Object)this, (Object[])new Object[0]);
                }
            }
        }
        TargetCacheImpl_Writer targetCacheImpl_Writer = this.writer;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            targetCacheImpl_Writer = targetCacheImpl_Writer;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getWriter", targetCacheImpl_Writer);
        }
        return targetCacheImpl_Writer;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void finalize() throws Throwable {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "finalize", new Object[0]);
        }
        if (!this.isSetWriter) {
            this.isSetWriter = true;
        } else if (this.writer != null) {
            this.writer = null;
            try (TargetCacheImpl_Writer useWriter = this.writer;){
                useWriter.writeTrailer();
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "finalize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void writeQuery(String methodName, String className, String title, int policies, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery", new Object[]{methodName, className, title, policies, annoType, specificClasses, annotationClass, resultClasses});
        }
        TargetCacheImpl_Writer useWriter = this.getWriter();
        if (useWriter == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
            }
            return;
        }
        try {
            useWriter.writeQuery(className, methodName, title, policies, annoType, specificClasses, annotationClass, resultClasses);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", (String)"274", (Object)this, (Object[])new Object[]{methodName, className, title, policies, annoType, specificClasses, annotationClass, resultClasses});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void writeQuery(String methodName, String className, String title, Collection<String> sources, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery", new Object[]{methodName, className, title, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        TargetCacheImpl_Writer useWriter = this.getWriter();
        if (useWriter == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
            }
            return;
        }
        try {
            useWriter.writeQuery(className, methodName, title, sources, annoType, specificClasses, annotationClass, resultClasses);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", (String)"302", (Object)this, (Object[])new Object[]{methodName, className, title, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized void writeQuery(String methodName, String className, String title, int policies, Collection<String> sources, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery", new Object[]{methodName, className, title, policies, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        TargetCacheImpl_Writer useWriter = this.getWriter();
        if (useWriter == null) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
            }
            return;
        }
        try {
            useWriter.writeQuery(className, methodName, title, policies, sources, annoType, specificClasses, annotationClass, resultClasses);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", (String)"330", (Object)this, (Object[])new Object[]{methodName, className, title, policies, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean getLogQueries() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getLogQueries", new Object[0]);
        }
        boolean bl = queryLogger.isLoggable(Level.FINER);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "getLogQueries", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(String className, String methodName, String title, int policies, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery", new Object[]{className, methodName, title, policies, annoType, specificClasses, annotationClass, resultClasses});
        }
        StringBuilder builder = new StringBuilder();
        TargetCacheImpl_Writer.logQuery(builder, title, policies, annoType, specificClasses, annotationClass, resultClasses);
        queryLogger.logp(Level.FINER, className, methodName, builder.toString());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(String className, String methodName, String title, Collection<String> sources, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery", new Object[]{className, methodName, title, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        StringBuilder builder = new StringBuilder();
        TargetCacheImpl_Writer.logQuery(builder, title, sources, annoType, specificClasses, annotationClass, resultClasses);
        queryLogger.logp(Level.FINER, className, methodName, builder.toString());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(String className, String methodName, String title, int policies, Collection<String> sources, String annoType, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery", new Object[]{className, methodName, title, policies, sources, annoType, specificClasses, annotationClass, resultClasses});
        }
        StringBuilder builder = new StringBuilder();
        TargetCacheImpl_Writer.logQuery(builder, title, policies, sources, annoType, specificClasses, annotationClass, resultClasses);
        queryLogger.logp(Level.FINER, className, methodName, builder.toString());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataQueries", "logQuery");
        }
    }
}

