/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.jandex.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.jandex.internal.PackedDataInputStream;
import com.ibm.ws.annocache.jandex.internal.SparseClassInfo;
import com.ibm.ws.annocache.jandex.internal.SparseDotName;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.HashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class SparseIndexReaderVersionImpl_V1
implements SparseIndexReaderVersion {
    public static final int MIN_VERSION = 2;
    public static final int MAX_VERSION = 3;
    private static final byte FIELD_TAG = 1;
    private static final byte METHOD_TAG = 2;
    private static final byte METHOD_PARAMATER_TAG = 3;
    private static final byte CLASS_TAG = 4;
    private static final int AVALUE_BYTE = 1;
    private static final int AVALUE_SHORT = 2;
    private static final int AVALUE_INT = 3;
    private static final int AVALUE_CHAR = 4;
    private static final int AVALUE_FLOAT = 5;
    private static final int AVALUE_DOUBLE = 6;
    private static final int AVALUE_LONG = 7;
    private static final int AVALUE_BOOLEAN = 8;
    private static final int AVALUE_STRING = 9;
    private static final int AVALUE_CLASS = 10;
    private static final int AVALUE_ENUM = 11;
    private static final int AVALUE_ARRAY = 12;
    private static final int AVALUE_NESTED = 13;
    private final PackedDataInputStream input;
    private final int version;
    private SparseDotName[] classTable;
    private String[] stringTable;
    static final long serialVersionUID = -239102079566265917L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean accept(int version) {
        return version >= 2 && version <= 3;
    }

    public SparseIndexReaderVersionImpl_V1(PackedDataInputStream input, int version) {
        this.input = input;
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public SparseIndex read() throws IOException {
        this.readClassTable();
        this.readStringTable();
        return this.readClasses();
    }

    private SparseIndex readClasses() throws IOException {
        int numClasses = this.input.readPackedU32();
        HashMap<SparseDotName, SparseClassInfo> classes = new HashMap<SparseDotName, SparseClassInfo>();
        for (int classNo = 0; classNo < numClasses; ++classNo) {
            SparseDotName className = this.classTable[this.input.readPackedU32()];
            SparseDotName superClassName = this.classTable[this.input.readPackedU32()];
            short flags = this.input.readShort();
            this.input.readBoolean();
            int numOfInterfaces = this.input.readPackedU32();
            SparseDotName[] interfaces = new SparseDotName[numOfInterfaces];
            for (int interfaceCounter = 0; interfaceCounter < numOfInterfaces; ++interfaceCounter) {
                interfaces[interfaceCounter] = this.classTable[this.input.readPackedU32()];
            }
            SparseClassInfo currentClassEntry = new SparseClassInfo(className, superClassName, flags, interfaces);
            this.readAnnotations(currentClassEntry);
            classes.put(className, currentClassEntry);
        }
        return new SparseIndex(classes);
    }

    private void readAnnotations(SparseClassInfo currentClass) throws IOException {
        int numAnnotations = this.input.readPackedU32();
        for (int annotationNo = 0; annotationNo < numAnnotations; ++annotationNo) {
            SparseDotName annotationName = this.classTable[this.input.readPackedU32()];
            int numTargets = this.input.readPackedU32();
            for (int targetNo = 0; targetNo < numTargets; ++targetNo) {
                int typeTag = this.input.readPackedU32();
                switch (typeTag) {
                    case 1: {
                        SparseDotName fieldName = SparseDotName.createSimple(this.stringTable[this.input.readPackedU32()]);
                        this.movePastReadType();
                        this.input.readShort();
                        currentClass.addField(fieldName);
                        currentClass.addFieldAnnotation(annotationName);
                        break;
                    }
                    case 2: {
                        SparseDotName methodName = SparseDotName.createSimple(this.movePastReadMethod());
                        currentClass.addMethod(methodName);
                        currentClass.addMethodAnnotation(annotationName);
                        break;
                    }
                    case 3: {
                        this.movePastReadMethod();
                        this.input.seekPackedU32();
                        break;
                    }
                    case 4: {
                        currentClass.addClassAnnotation(annotationName);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.movePastReadAnnotationValues();
            }
        }
    }

    private void movePastReadAnnotationValues() throws IOException {
        int numOfValues = this.input.readPackedU32();
        block15: for (int valuesCounter = 0; valuesCounter < numOfValues; ++valuesCounter) {
            this.input.seekPackedU32();
            byte tag = this.input.readByte();
            switch (tag) {
                case 1: {
                    this.input.readByte();
                    continue block15;
                }
                case 2: {
                    this.input.seekPackedU32();
                    continue block15;
                }
                case 3: {
                    this.input.seekPackedU32();
                    continue block15;
                }
                case 4: {
                    this.input.seekPackedU32();
                    continue block15;
                }
                case 5: {
                    this.input.readFloat();
                    continue block15;
                }
                case 6: {
                    this.input.readDouble();
                    continue block15;
                }
                case 7: {
                    this.input.readLong();
                    continue block15;
                }
                case 8: {
                    this.input.readBoolean();
                    continue block15;
                }
                case 9: {
                    this.input.seekPackedU32();
                    continue block15;
                }
                case 10: {
                    this.movePastReadType();
                    continue block15;
                }
                case 11: {
                    this.input.seekPackedU32();
                    this.input.seekPackedU32();
                    continue block15;
                }
                case 12: {
                    this.movePastReadAnnotationValues();
                    continue block15;
                }
                case 13: {
                    this.input.seekPackedU32();
                    this.movePastReadAnnotationValues();
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Invalid annotation value tag:" + tag);
                }
            }
        }
    }

    private String movePastReadMethod() throws IOException {
        String name = this.stringTable[this.input.readPackedU32()];
        int numArgs = this.input.readPackedU32();
        for (int argsCounter = 0; argsCounter < numArgs; ++argsCounter) {
            this.input.readByte();
            this.input.seekPackedU32();
        }
        this.input.readByte();
        this.input.seekPackedU32();
        this.input.readShort();
        return name;
    }

    private void movePastReadType() throws IOException {
        this.input.readByte();
        this.input.seekPackedU32();
    }

    private void readStringTable() throws IOException {
        int numOfEntries = this.input.readPackedU32();
        this.stringTable = new String[numOfEntries];
        for (int entryCounter = 0; entryCounter < numOfEntries; ++entryCounter) {
            this.stringTable[entryCounter] = this.input.readUTF();
        }
    }

    private void readClassTable() throws IOException {
        int entries = this.input.readPackedU32();
        int lastDepth = -1;
        SparseDotName curr = null;
        this.classTable = new SparseDotName[++entries];
        for (int entryCounter = 1; entryCounter < entries; ++entryCounter) {
            int depth = this.input.readPackedU32();
            String local = this.input.readUTF();
            if (depth <= lastDepth) {
                while (lastDepth-- >= depth) {
                    curr = curr.prefix();
                }
            }
            this.classTable[entryCounter] = curr = new SparseDotName(curr, local, false, false);
            lastDepth = depth;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.jandex.internal.SparseIndexReaderVersionImpl_V1", SparseIndexReaderVersionImpl_V1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

