/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.jwt.exceptions.JwtContextMissingJoseObjects;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import java.util.List;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtParsingUtils {
    private static final TraceComponent tc = Tr.register(JwtParsingUtils.class, null, null);
    static final long serialVersionUID = -6905298012886464338L;

    public static JwtContext parseJwtWithoutValidation(String jwtString) throws Exception {
        JwtConsumer firstPassJwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
        return firstPassJwtConsumer.process(jwtString);
    }

    public static JsonWebStructure getJsonWebStructureFromJwtContext(JwtContext jwtContext) throws JwtContextMissingJoseObjects {
        List jsonStructures = jwtContext.getJoseObjects();
        if (jsonStructures == null || jsonStructures.isEmpty()) {
            throw new JwtContextMissingJoseObjects();
        }
        JsonWebStructure jsonStruct = (JsonWebStructure)jsonStructures.get(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JsonWebStructure class: " + jsonStruct.getClass().getName() + " data:" + jsonStruct), (Object[])new Object[0]);
            if (jsonStruct instanceof JsonWebSignature) {
                JsonWebSignature signature = (JsonWebSignature)jsonStruct;
                Tr.debug((TraceComponent)tc, (String)("JsonWebSignature alg: " + signature.getAlgorithmHeaderValue() + " 3rd:'" + signature.getEncodedSignature() + "'"), (Object[])new Object[0]);
            }
        }
        return jsonStruct;
    }

    public static JwtClaims parseJwtWithValidation(String jwtString, JwtConsumer jwtConsumer) throws InvalidJwtException {
        JwtContext validatedJwtContext = jwtConsumer.process(jwtString);
        return validatedJwtContext.getJwtClaims();
    }

    public static JwtClaims parseJwtWithValidation(String jwtString, JwsSignatureVerifier signatureVerifier) throws Exception {
        return null;
    }
}

