/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.service;

import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class ValidationClassLoader
extends ClassLoader {
    ValidationClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        if (resourceName.equals("META-INF/validation.xml")) {
            ArrayList<URL> list = new ArrayList<URL>();
            URL url = ValidationClassLoader.getModuleValidationXml();
            if (url != null) {
                list.add(url);
            }
            return Collections.enumeration(list);
        }
        return super.getResources(resourceName);
    }

    @Override
    public URL getResource(String resourceName) {
        if (resourceName.equals("META-INF/validation.xml")) {
            return ValidationClassLoader.getModuleValidationXml();
        }
        return super.getResource(resourceName);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        if (resourceName.equals("META-INF/validation.xml")) {
            InputStream is = super.getResourceAsStream(resourceName);
            if (is == null) {
                is = super.getResourceAsStream("WEB-INF/classes/META-INF/validation.xml");
            }
            return is;
        }
        return super.getResourceAsStream(resourceName);
    }

    static URL getModuleValidationXml() {
        URL url;
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cmd != null) {
            ModuleMetaData mmd = cmd.getModuleMetaData();
            url = AbstractBeanValidation.instance().getValidationXmlUrl(mmd);
        } else {
            url = null;
        }
        return url;
    }
}

