/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine.factory;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.injectionengine.factory.MBLinkInfo;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.MethodMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import javax.annotation.PostConstruct;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MBLinkObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = MBLinkObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(MBLinkObjectFactory.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final ThreadContextAccessor svThreadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private static final String PC_NAME = PostConstruct.class.getSimpleName();

    public MBLinkObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader classLoader;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getObjectInstance : " + obj), (Object[])new Object[0]);
        }
        Class<?> mbClass = null;
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            InjectionException inex = new InjectionException("Binding object is not a Reference : " + obj);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + inex));
            }
            throw inex;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(CLASS_NAME)) {
            InjectionException inex = new InjectionException("Incorrect factory for Reference : " + obj);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + inex));
            }
            throw inex;
        }
        RefAddr addr = ref.get("MBLinkInfo");
        if (addr == null) {
            NamingException nex = new NamingException("The address for this Reference is empty (null)");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + nex));
            }
            throw nex;
        }
        MBLinkInfo info = (MBLinkInfo)addr.getContent();
        try {
            classLoader = svThreadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
            mbClass = classLoader.loadClass(info.ivBeanType);
            retObj = mbClass.newInstance();
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getObjectInstance"), (String)"125", (Object)this);
            String msg = "The " + info.ivRefName + " managed bean reference in the " + info.ivModule + " module of the " + info.ivApplication + " application could not be resolved. A failure occurred creating an instance of the " + info.ivBeanType + " managed bean.";
            InjectionException inex = new InjectionException(msg, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getObjectInstance: " + inex));
            }
            throw inex;
        }
        this.inject(classLoader, mbClass, retObj, info);
        this.callLifecycleInterceptors(mbClass, retObj);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getObjectInstance : " + retObj.getClass().getName()));
        }
        return retObj;
    }

    private void inject(ClassLoader classLoader, Class<?> mbClass, Object mbInstance, MBLinkInfo info) throws InjectionException {
        String displayName = mbClass.getName();
        if (mbClass != String.class) {
            throw new UnsupportedOperationException();
        }
        J2EEName j2eeName = null;
        ComponentNameSpaceConfiguration compNSConfig = new ComponentNameSpaceConfiguration(displayName, j2eeName);
        compNSConfig.setOwningFlow(ComponentNameSpaceConfiguration.ReferenceFlowKind.MANAGED_BEAN);
        compNSConfig.setClassLoader(classLoader);
        compNSConfig.setInjectionClasses(Collections.singletonList(mbClass));
        InjectionEngine injectionEngine = InjectionEngineAccessor.getInstance();
        HashMap injectionTargets = new HashMap();
        injectionEngine.processInjectionMetaData(injectionTargets, compNSConfig);
        for (InjectionTarget injectionTarget : injectionTargets.get(mbClass)) {
            injectionEngine.inject(mbInstance, injectionTarget, null);
        }
    }

    private void callLifecycleInterceptors(Class<?> mbClass, Object mbInstance) throws InjectionException {
        Collection<MethodMap.MethodInfo> methods = MethodMap.getAllDeclaredMethods(mbClass);
        for (MethodMap.MethodInfo methodInfo : methods) {
            Method method = methodInfo.getMethod();
            PostConstruct postConstruct = method.getAnnotation(PostConstruct.class);
            if (postConstruct == null) continue;
            method.setAccessible(true);
            MBLinkObjectFactory.validateLifeCycleSignature(PC_NAME, method, true);
            try {
                method.invoke(mbInstance, (Object[])null);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                cause.printStackTrace();
                throw new InjectionException(PC_NAME + " interceptor \"" + method + "\" failed with the following error : " + cause);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                throw new InjectionException(PC_NAME + " interceptor \"" + method + "\" failed with the following error : " + ex);
            }
        }
    }

    public static void validateLifeCycleSignature(String lifeCycle, Method m, boolean beanClass) throws InjectionConfigurationException {
        int mod = m.getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_INTERCEPTOR_METHOD_MODIFIER_CNTR0229E", (Object[])new Object[]{method});
            throw new InjectionConfigurationException(lifeCycle + " interceptor \"" + method + "\" must not be declared as final or static.");
        }
        Class<?> returnType = m.getReturnType();
        if (returnType != Void.TYPE) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", (Object[])new Object[]{method, lifeCycle});
            throw new InjectionConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have void as return type.");
        }
        Class<?>[] exceptionTypes = m.getExceptionTypes();
        if (exceptionTypes.length != 0) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", (Object[])new Object[]{lifeCycle, method});
            throw new InjectionConfigurationException(lifeCycle + " interceptor \"" + method + "\" must not throw application exceptions.");
        }
        Class<?>[] parmTypes = m.getParameterTypes();
        if (beanClass) {
            if (parmTypes.length != 0) {
                String method = m.toGenericString();
                Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0231E", (Object[])new Object[]{lifeCycle, method});
                throw new InjectionConfigurationException(lifeCycle + " interceptor \"" + method + "\" must have zero parameters.");
            }
        } else if (parmTypes.length != 1) {
            String method = m.toGenericString();
            Tr.error((TraceComponent)tc, (String)"INVALID_LIFECYCLE_SIGNATURE_CNTR0232E", (Object[])new Object[]{method, lifeCycle});
            throw new InjectionConfigurationException("CNTR0232E: The \"" + method + "\" method does not have the required method signature for a \"" + lifeCycle + "\" method of a interceptor class.");
        }
    }
}

