/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wlp.lib.extract.Content;
import wlp.lib.extract.ContentLicenseProvider;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.InstallUtils;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ProductMatch;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;

public class SelfExtractor
implements LicenseProvider {
    private static SelfExtractor instance;
    private static final boolean isWindows;
    protected final ZipFile jarFile;
    protected final Content container;
    protected final String root;
    protected final List productMatches;
    private final String archiveContentType;
    private final String providedFeatures;
    protected final boolean productAddOn;
    private final boolean extractInstaller;
    private final LicenseProvider licenseProvider;
    private final String requiredFeatures;
    private final String serverName;
    private static final String EXTERNAL_DEPS_FILE = "externaldependencies.xml";
    private boolean doExternalDepsDownload = true;
    private ExternalDependencies externalDeps = null;
    private final boolean licensePresent;
    private File userDirOverride = null;
    protected boolean allowNonEmptyInstallDirectory = false;
    private String productInstallType = null;

    public File getUserDirOverride() {
        return this.userDirOverride;
    }

    public void setUserDirOverride(File userDirOverride) {
        this.userDirOverride = userDirOverride;
    }

    public String getServerName() {
        return this.serverName;
    }

    protected SelfExtractor(JarFile jar, LicenseProvider licenseProvider, Attributes attributes) {
        this(jar, new Content.JarContent(jar), licenseProvider, attributes);
    }

    protected SelfExtractor(Content container, LicenseProvider licenseProvider, Attributes attributes) {
        this(null, container, licenseProvider, attributes);
    }

    private SelfExtractor(JarFile jar, Content container, LicenseProvider licenseProvider, Attributes attributes) {
        this.jarFile = jar;
        this.container = container;
        this.licensePresent = licenseProvider != null;
        this.licenseProvider = licenseProvider;
        String rootDir = attributes.getValue("Archive-Root");
        this.root = rootDir != null ? rootDir : "";
        String appliesTo = attributes.getValue("Applies-To");
        this.extractInstaller = Boolean.valueOf(attributes.getValue("Extract-Installer"));
        this.requiredFeatures = attributes.getValue("Require-Feature");
        this.productMatches = SelfExtractor.parseAppliesTo(appliesTo);
        this.archiveContentType = attributes.getValue("Archive-Content-Type");
        this.productAddOn = !this.productMatches.isEmpty() && !this.isUserSample();
        this.providedFeatures = attributes.getValue("Provide-Feature");
        this.serverName = attributes.getValue("Server-Name");
    }

    public static List parseAppliesTo(String appliesTo) {
        ArrayList<ProductMatch> matches = new ArrayList<ProductMatch>();
        if (appliesTo != null) {
            boolean quoted = false;
            int index = 0;
            ProductMatch match = new ProductMatch();
            for (int i = 0; i < appliesTo.length(); ++i) {
                char c = appliesTo.charAt(i);
                if (c == '\"') {
                    boolean bl = quoted = !quoted;
                }
                if (quoted) continue;
                if (c == ',') {
                    match.add(appliesTo.substring(index, i));
                    index = i + 1;
                    matches.add(match);
                    match = new ProductMatch();
                    continue;
                }
                if (c != ';') continue;
                match.add(appliesTo.substring(index, i));
                index = i + 1;
            }
            match.add(appliesTo.substring(index));
            matches.add(match);
        }
        return matches;
    }

    public static final SelfExtractor getInstance() {
        return instance;
    }

    public static final ReturnCode buildInstance() {
        ReturnCode buildLicenseProviderReturnCode;
        if (instance != null) {
            return ReturnCode.OK;
        }
        File self = SelfExtractUtils.getSelf();
        if (self == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        Content container = null;
        String laPrefix = null;
        String liPrefix = null;
        Attributes mainAttributes = null;
        boolean hasLicense = true;
        try {
            container = Content.build(self);
            Manifest man = container.getManifest();
            mainAttributes = man.getMainAttributes();
            laPrefix = mainAttributes.getValue("License-Agreement");
            liPrefix = mainAttributes.getValue("License-Information");
            hasLicense = laPrefix != null && liPrefix != null;
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (hasLicense && (buildLicenseProviderReturnCode = ContentLicenseProvider.buildInstance(container, laPrefix, liPrefix)) != ReturnCode.OK) {
            return buildLicenseProviderReturnCode;
        }
        instance = new SelfExtractor(container, hasLicense ? ContentLicenseProvider.getInstance() : null, mainAttributes);
        return ReturnCode.OK;
    }

    public String getExtractSuccessMessageKey() {
        return "extractSuccess";
    }

    public String getExtractInstructionMessageKey() {
        return "extractInstruction";
    }

    @Override
    public InputStream getLicenseAgreement() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseAgreement();
    }

    @Override
    public InputStream getLicenseInformation() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseInformation();
    }

    @Override
    public String getProgramName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getProgramName();
    }

    @Override
    public String getLicenseName() {
        return this.licenseProvider == null ? null : this.licenseProvider.getLicenseName();
    }

    public boolean hasLicense() {
        return this.licensePresent;
    }

    public int getSize() {
        return this.container.size();
    }

    public int getTotalDepsSize() {
        try {
            return this.getExternalDependencies().getSize();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getRoot() {
        return this.productAddOn || this.isUserSample() ? "" : this.root;
    }

    public ReturnCode validate(File outputDir) {
        File[] files;
        boolean dirExists = outputDir.exists();
        if (this.productAddOn || this.isUserSample()) {
            ReturnCode result = SelfExtractor.validateProductMatches(outputDir, this.productMatches);
            if (result.getCode() == 0) {
                try {
                    Set missingFeatures = this.listMissingCoreFeatures(outputDir);
                    if (!missingFeatures.isEmpty()) {
                        result = new ReturnCode(1, "missingRequiredFeatures", new Object[]{this.container.getName(), missingFeatures, outputDir});
                    }
                }
                catch (SelfExtractorFileException sefe) {
                    result = new ReturnCode(1, "fileProcessingException", new Object[]{sefe.getFileName(), sefe.getCause()});
                }
            }
            return result;
        }
        if (dirExists && !this.allowNonEmptyInstallDirectory && (files = outputDir.listFiles()) != null && files.length > 0) {
            return new ReturnCode(4, "extractDirectoryExists", outputDir.getAbsolutePath());
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int installAssets(File installRoot, Set assets) {
        Process process;
        File java = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        if (assets.size() == 0) {
            return 0;
        }
        File installJarFile = new File(installRoot, "bin/tools/ws-installUtility.jar");
        String[] runtimeCmd = new String[assets.size() + 5];
        runtimeCmd[0] = java.getAbsolutePath();
        runtimeCmd[1] = "-jar";
        runtimeCmd[2] = installJarFile.getAbsolutePath();
        runtimeCmd[3] = "install";
        runtimeCmd[4] = "--acceptLicense";
        int i = 5;
        Iterator iter = assets.iterator();
        while (iter.hasNext()) {
            runtimeCmd[i++] = ((String)iter.next()).trim();
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(runtimeCmd, null, installRoot);
        }
        catch (IOException e1) {
            return -1;
        }
        StringBuffer stdout = new StringBuffer();
        Thread stderrCopier = new Thread(new OutputStreamCopierInstallUtil(process.getErrorStream(), stdout));
        stderrCopier.start();
        new OutputStreamCopierInstallUtil(process.getInputStream(), stdout).run();
        try {
            stderrCopier.join();
            process.waitFor();
        }
        catch (InterruptedException e) {
            int n = -1;
            return n;
        }
        if (process.exitValue() != 0) {
            System.out.println(stdout.toString());
        } else {
            try {
                Set missingFeatures = this.listMissingCoreFeatures(installRoot);
                if (!missingFeatures.isEmpty()) {
                    System.out.println(stdout.toString());
                    return -1;
                }
            }
            catch (SelfExtractorFileException sefe) {
                return -1;
            }
        }
        return process.exitValue();
    }

    public ReturnCode installMissingRequiredFeatures(File outputDir, ReturnCode rc) {
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        if (Double.parseDouble(version.substring(0, pos = version.indexOf(46, pos + 1))) < 1.8) {
            return rc;
        }
        String skipInstallRequiredAssets = System.getProperty("was.liberty.self.extractor.skip.install.required.assets");
        if (skipInstallRequiredAssets != null && skipInstallRequiredAssets.equalsIgnoreCase("true")) {
            return rc;
        }
        System.setProperty("was.liberty.self.extractor.skip.install.required.assets", "true");
        try {
            Set missingFeatures = this.listMissingCoreFeatures(outputDir);
            if (!missingFeatures.isEmpty()) {
                if (this.installAssets(outputDir, missingFeatures) == 0) {
                    return ReturnCode.OK;
                }
                return rc;
            }
        }
        catch (SelfExtractorFileException sefe) {
            return new ReturnCode(1, "fileProcessingException", new Object[]{sefe.getFileName(), sefe.getCause()});
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnCode validateProductMatches(File outputDir, List productMatches) {
        block25: {
            boolean dirExists = outputDir.exists();
            if (dirExists) {
                File f = new File(outputDir, "lib/versions");
                File[] files = f.listFiles();
                if (files == null || files.length == 0) {
                    return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
                }
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getAbsolutePath().endsWith(".properties")) continue;
                    Properties props = new Properties();
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(files[i]);
                        props.load(is);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    finally {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    for (ProductMatch match : productMatches) {
                        int result = match.matches(props);
                        if (result == -1) continue;
                        if (result == -2 || result == -3) {
                            ArrayList<String> longIDs = new ArrayList<String>();
                            for (String shortID : match.getEditions()) {
                                String editionName = InstallUtils.getEditionName(shortID);
                                longIDs.add(editionName);
                            }
                            String edition = InstallUtils.getEditionName(props.getProperty("com.ibm.websphere.productEdition"));
                            if (result == -2) {
                                return new ReturnCode(4, "invalidVersion", new Object[]{props.getProperty("com.ibm.websphere.productVersion"), match.getVersion(), edition, longIDs, props.getProperty("com.ibm.websphere.productLicenseType")});
                            }
                            if (result == -3) {
                                return new ReturnCode(4, "invalidEdition", new Object[]{edition, longIDs, props.getProperty("com.ibm.websphere.productVersion"), match.getVersion(), props.getProperty("com.ibm.websphere.productLicenseType")});
                            }
                        } else {
                            if (result == -4) {
                                return new ReturnCode(4, "invalidInstallType", new Object[]{props.getProperty("com.ibm.websphere.productInstallType"), match.getInstallType()});
                            }
                            if (result == -5) {
                                return new ReturnCode(4, "invalidLicense", new Object[]{props.getProperty("com.ibm.websphere.productLicenseType"), match.getLicenseType()});
                            }
                        }
                        break block25;
                    }
                }
            } else {
                return new ReturnCode(4, "invalidInstall", outputDir.getAbsolutePath());
            }
        }
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public ReturnCode extract(File wlpInstallDir, ExtractProgress ep) {
        ArrayList<Object> extensionRootDirs;
        boolean continueInstall;
        ArrayList<String> extractedFiles;
        ReturnCode rc;
        File outputDir;
        ArrayList<File> createdDirectoriesAndFiles;
        block41: {
            createdDirectoriesAndFiles = new ArrayList<File>();
            outputDir = null;
            if (this.isUserSample()) {
                outputDir = this.userDirOverride != null ? this.userDirOverride : SelfExtractor.determineTargetUserDirectory(wlpInstallDir);
                SelfExtract.out("targetUserDirectory", new Object[]{outputDir.getAbsolutePath()});
            } else {
                outputDir = wlpInstallDir;
            }
            boolean dirExists = outputDir.exists();
            if (!(this.allowNonEmptyInstallDirectory || dirExists || SelfExtractUtils.trackedMkdirs(outputDir, createdDirectoriesAndFiles))) {
                SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                return new ReturnCode(4, "extractDirectoryError", outputDir.getAbsolutePath());
            }
            if (ep == null) {
                ep = new NullExtractProgress();
            }
            if (!(rc = this.downloadFile(outputDir, createdDirectoriesAndFiles, ep)).equals(ReturnCode.OK)) {
                return rc;
            }
            byte[] buf = new byte[4096];
            extractedFiles = new ArrayList<String>();
            continueInstall = true;
            String metaInfDir = "META-INF/";
            HashMap<String, String> filePathsToExtract = new HashMap<String, String>();
            filePathsToExtract.put(this.root, this.root);
            filePathsToExtract.put(metaInfDir, "");
            extensionRootDirs = new ArrayList();
            if (!this.isUserSample() && !this.productAddOn) {
                try {
                    extensionRootDirs = this.getExtensionInstallDirs();
                    String[] s = this.root.split("/");
                    for (String installDir : extensionRootDirs) {
                        if (installDir.startsWith(this.root)) continue;
                        String rootDir = "";
                        for (int i = 0; i < s.length; ++i) {
                            String dirname = s[i] + "/";
                            if (!installDir.startsWith(dirname)) continue;
                            rootDir = rootDir.concat(dirname);
                        }
                        filePathsToExtract.put(installDir, rootDir);
                    }
                }
                catch (IOException ioe) {
                    return new ReturnCode(4, "extractFileError", ioe.getMessage());
                }
            }
            SelfExtract.out("extractDirectory", new Object[]{outputDir.getAbsolutePath()});
            if (this.container.isExtracted()) break block41;
            for (Content.Entry entry : this.container) {
                block43: {
                    block42: {
                        InputStream is;
                        OutputStream os;
                        File file;
                        String name = entry.getName();
                        String commonRootDir = this.getCommonRootDir(name, filePathsToExtract);
                        if (null == commonRootDir) break block42;
                        if (entry.isDirectory()) {
                            if (!this.extractInstaller && (name.startsWith(metaInfDir) || name.startsWith("wlp/lib/extract/"))) {
                                ep.skippedFile();
                                continue;
                            }
                            if (name.startsWith(metaInfDir)) {
                                file = new File(outputDir, "lib/extract");
                                if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                    return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                                }
                                file = new File(new File(outputDir, "lib/extract"), name);
                            } else {
                                file = name.startsWith(this.root) ? new File(outputDir, name.substring(commonRootDir.length())) : new File(outputDir.getParentFile(), name.substring(commonRootDir.length()));
                            }
                            if (!file.exists() && !SelfExtractUtils.trackedMkdirs(file, createdDirectoriesAndFiles)) {
                                SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                return new ReturnCode(4, "extractDirectoryError", file.getAbsolutePath());
                            }
                            ep.skippedFile();
                        } else {
                            int read;
                            File parentFile;
                            if (!this.extractInstaller && (name.startsWith(metaInfDir) || name.startsWith("wlp/lib/extract/"))) {
                                ep.skippedFile();
                                continue;
                            }
                            if (name.startsWith(metaInfDir)) {
                                file = new File(outputDir, "lib/extract");
                                file = new File(file, name);
                            } else {
                                file = name.startsWith(this.root) ? new File(outputDir, name.substring(commonRootDir.length())) : new File(outputDir.getParentFile(), name.substring(commonRootDir.length()));
                            }
                            if (file.exists()) {
                                if (this.productAddOn) continue;
                                if (this.allowNonEmptyInstallDirectory) {
                                    if (name.endsWith("wlp/lib/extract/META-INF/MANIFEST.MF")) continue;
                                    if (name.endsWith("META-INF/MANIFEST.MF")) {
                                        file.delete();
                                    } else {
                                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                        return new ReturnCode(4, "extractFileExists", file.getAbsolutePath());
                                    }
                                }
                            }
                            if (!(parentFile = file.getParentFile()).exists() && !SelfExtractUtils.trackedMkdirs(parentFile, createdDirectoriesAndFiles)) {
                                SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                return new ReturnCode(4, "extractDirectoryError", parentFile.getAbsolutePath());
                            }
                            ep.extractedFile(name);
                            extractedFiles.add(name);
                            createdDirectoriesAndFiles.add(file);
                            os = null;
                            is = null;
                            if (this.productInstallType != null && name.equalsIgnoreCase("wlp/lib/versions/WebSphereApplicationServer.properties")) {
                                Properties wasProps = new Properties();
                                try {
                                    is = entry.getInputStream();
                                    wasProps.load(is);
                                    wasProps.put("com.ibm.websphere.productInstallType", this.productInstallType);
                                    os = new FileOutputStream(file);
                                    wasProps.store(os, null);
                                    continue;
                                }
                                catch (IOException ioe) {
                                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                    ReturnCode returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
                                    return returnCode;
                                }
                                finally {
                                    SelfExtractUtils.tryToClose(is);
                                    SelfExtractUtils.tryToClose(os);
                                    continue;
                                }
                            }
                            os = new BufferedOutputStream(new FileOutputStream(file));
                            is = entry.getInputStream();
                            while ((read = is.read(buf)) != -1) {
                                ((OutputStream)os).write(buf, 0, read);
                            }
                            SelfExtractUtils.tryToClose(os);
                            SelfExtractUtils.tryToClose(is);
                        }
                        break block43;
                        catch (IOException ioe) {
                            ReturnCode returnCode;
                            try {
                                SelfExtractUtils.tryToClose(os);
                                SelfExtractUtils.tryToClose(is);
                                SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                                returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
                            }
                            catch (Throwable throwable) {
                                SelfExtractUtils.tryToClose(os);
                                SelfExtractUtils.tryToClose(is);
                                throw throwable;
                            }
                            SelfExtractUtils.tryToClose(os);
                            SelfExtractUtils.tryToClose(is);
                            return returnCode;
                        }
                    }
                    ep.skippedFile();
                }
                continueInstall = !ep.isCanceled();
            }
        }
        if (continueInstall) {
            rc = this.setFilePermission(outputDir, extensionRootDirs, ep);
            if (ReturnCode.OK.getCode() != rc.getCode()) {
                return rc;
            }
        }
        if (this.productAddOn) {
            SelfExtractor.printNeededIFixes(outputDir, extractedFiles);
        }
        if (!continueInstall) {
            SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
        }
        return ReturnCode.OK;
    }

    private ReturnCode setFilePermission(File outputDir, List<String> extInstallDirs, ExtractProgress ep) {
        ReturnCode rc = this.fixScriptPermissions(ep, outputDir);
        if (rc != null) {
            return rc;
        }
        try {
            rc = SelfExtractUtils.processExecutableDirective(outputDir);
        }
        catch (Exception e) {
            return new ReturnCode(4, "extractFileError", e.getMessage());
        }
        if (ReturnCode.OK.getCode() != rc.getCode()) {
            return rc;
        }
        File outputDirParent = outputDir.getParentFile();
        for (String installDir : extInstallDirs) {
            File extDir = new File(outputDirParent, installDir);
            try {
                rc = SelfExtractUtils.processExecutableDirective(extDir);
            }
            catch (Exception e) {
                return new ReturnCode(4, "extractFileError", e.getMessage());
            }
            if (ReturnCode.OK.getCode() == rc.getCode()) continue;
            return rc;
        }
        return null == rc ? ReturnCode.OK : rc;
    }

    private static void checkResponseCode(URLConnection uc) throws IOException {
        HttpURLConnection httpConnection;
        int rc;
        if (uc instanceof HttpURLConnection && (rc = (httpConnection = (HttpURLConnection)uc).getResponseCode()) != 200 && rc != 302) {
            throw new IOException();
        }
    }

    private InputStream getInputStreamCheckRedirects(URLConnection uc) throws IOException {
        boolean isRedirect;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            uc.setReadTimeout(30000);
            SelfExtractor.checkResponseCode(uc);
            if (uc instanceof HttpURLConnection) {
                ((HttpURLConnection)uc).setInstanceFollowRedirects(false);
            }
            in = uc.getInputStream();
            isRedirect = false;
            if (!(uc instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)uc).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            isRedirect = true;
            uc = target.openConnection();
            ++redirects;
        } while (isRedirect);
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnCode downloadFile(File downloadDir, List<File> createdDirectoriesAndFiles, ExtractProgress ep) {
        if (this.doExternalDepsDownload && this.hasExternalDepsFile()) {
            List depList = null;
            try {
                depList = this.getExternalDependencies().getDependencies();
            }
            catch (Exception e) {
                return new ReturnCode(2, "readDepsError", new Object[0]);
            }
            SelfExtract.out("downloadingBeginNotice", new Object[]{"--verbose"});
            byte[] buffer = new byte[4096];
            for (int i = 0; i < depList.size(); ++i) {
                ExternalDependency thisDep = (ExternalDependency)depList.get(i);
                URL sourceUrl = thisDep.getSourceUrl();
                String targetPath = thisDep.getTargetPath();
                File usrDir = downloadDir;
                File targetFile = new File(usrDir, targetPath);
                File targetDir = targetFile.getParentFile();
                if (targetFile.exists()) {
                    if (this.productAddOn || this.isUserSample()) continue;
                    if (this.allowNonEmptyInstallDirectory) {
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        return new ReturnCode(4, "extractFileExists", targetFile.getAbsolutePath());
                    }
                }
                if (!SelfExtractUtils.trackedMkdirs(targetDir, createdDirectoriesAndFiles) && !targetDir.exists()) {
                    SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                    return new ReturnCode(4, "extractDirectoryError", targetDir.getAbsolutePath());
                }
                ep.downloadingFile(sourceUrl, targetFile);
                createdDirectoriesAndFiles.add(targetFile);
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    URLConnection uc = sourceUrl.openConnection();
                    input = this.getInputStreamCheckRedirects(uc);
                    output = new FileOutputStream(targetFile);
                    int n = -1;
                    while ((n = input.read(buffer)) != -1) {
                        ((OutputStream)output).write(buffer, 0, n);
                        ep.dataDownloaded(n);
                    }
                }
                catch (IOException ioe) {
                    ReturnCode returnCode;
                    try {
                        SelfExtractUtils.tryToClose(output);
                        SelfExtractUtils.tryToClose(input);
                        SelfExtractUtils.rollbackExtract(createdDirectoriesAndFiles);
                        returnCode = new ReturnCode(4, "downloadFileError", new String[]{sourceUrl.toString(), targetFile.toString()});
                    }
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(output);
                        SelfExtractUtils.tryToClose(input);
                        throw throwable;
                    }
                    SelfExtractUtils.tryToClose(output);
                    SelfExtractUtils.tryToClose(input);
                    return returnCode;
                }
                SelfExtractUtils.tryToClose(output);
                SelfExtractUtils.tryToClose(input);
                continue;
            }
        }
        return ReturnCode.OK;
    }

    private String getCommonRootDir(String filePath, HashMap validFilePaths) {
        for (Map.Entry entry : validFilePaths.entrySet()) {
            String path = (String)entry.getKey();
            if (!filePath.startsWith(path)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    private ArrayList<String> getExtensionInstallDirs() throws IOException {
        String extensiondir = this.root + "etc/extensions/";
        ArrayList<String> extensionDirs = new ArrayList<String>();
        for (Content.Entry entry : this.container) {
            if (!entry.getName().startsWith(extensiondir) || !entry.getName().endsWith(".properties")) continue;
            Properties prop = new Properties();
            prop.load(entry.getInputStream());
            String installDir = prop.getProperty("com.ibm.websphere.productInstall");
            if (null == installDir || installDir.equals("")) continue;
            extensionDirs.add(installDir);
        }
        return extensionDirs;
    }

    public ReturnCode fixScriptPermissions(ExtractProgress ep, File outputDir) {
        return this.fixScriptPermissions(ep, outputDir, null);
    }

    public ReturnCode fixScriptPermissions(ExtractProgress ep, File outputDir, ZipFile filter) {
        return SelfExtractUtils.fixScriptPermissions(ep, outputDir, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static File determineTargetUserDirectory(File wlpInstallDir) {
        File defaultUserDir;
        block8: {
            block6: {
                defaultUserDir = new File(wlpInstallDir, "usr");
                File serverEnvFile = new File(wlpInstallDir, "etc/server.env");
                if (!serverEnvFile.exists()) break block6;
                Properties serverEnvProps = new Properties();
                FileInputStream serverEnvStream = null;
                try {
                    serverEnvStream = new FileInputStream(serverEnvFile);
                    serverEnvProps.load(serverEnvStream);
                }
                catch (Exception exception) {
                    SelfExtractUtils.tryToClose(serverEnvStream);
                    catch (Throwable throwable) {
                        SelfExtractUtils.tryToClose(serverEnvStream);
                        throw throwable;
                    }
                }
                SelfExtractUtils.tryToClose(serverEnvStream);
                String customUserDir = serverEnvProps.getProperty("WLP_USER_DIR");
                if (customUserDir != null && !"".equals(customUserDir)) {
                    return new File(customUserDir);
                }
                break block8;
            }
            String envVarUserDir = System.getenv("WLP_USER_DIR");
            if (envVarUserDir != null && !"".equals(envVarUserDir)) {
                return new File(envVarUserDir);
            }
        }
        return defaultUserDir;
    }

    public boolean isUserSample() {
        return this.archiveContentType != null && this.archiveContentType.equalsIgnoreCase("sample");
    }

    public boolean isProductAddon() {
        return this.productAddOn;
    }

    public String getArchiveContentType() {
        return this.archiveContentType;
    }

    public String getProvidedFeatures() {
        return this.providedFeatures;
    }

    public boolean hasExternalDepsFile() {
        return this.container.getEntry(EXTERNAL_DEPS_FILE) != null;
    }

    public void setDoExternalDepsDownload(boolean value) {
        this.doExternalDepsDownload = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExternalDependencies() throws Exception {
        Content.Entry depsEntry = null;
        ExternalDependencies newDeps = new ExternalDependencies();
        depsEntry = this.container.getEntry(EXTERNAL_DEPS_FILE);
        if (depsEntry != null) {
            InputStream entryInputStream = null;
            try {
                entryInputStream = depsEntry.getInputStream();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(entryInputStream);
                Element rootEle = doc.getDocumentElement();
                newDeps.setDescription(rootEle.getAttribute("description"));
                NodeList dependencies = rootEle.getElementsByTagName("dependency");
                for (int i = 0; i < dependencies.getLength(); ++i) {
                    Node node = dependencies.item(i);
                    Element ele = (Element)node;
                    URL sourceUrl = new URL(ele.getAttribute("url"));
                    String targetPath = ele.getAttribute("targetpath");
                    newDeps.add(sourceUrl, targetPath);
                }
            }
            finally {
                SelfExtractUtils.tryToClose(entryInputStream);
            }
        }
        this.externalDeps = newDeps;
    }

    public ExternalDependencies getExternalDependencies() throws Exception {
        if (this.externalDeps == null) {
            this.buildExternalDependencies();
        }
        return this.externalDeps;
    }

    public static void printNeededIFixes(File outputDir, List extractedFiles) {
        try {
            Runtime runtime = Runtime.getRuntime();
            String productInfo = new File(outputDir, isWindows ? "bin/productInfo.bat" : "bin/productInfo").getAbsolutePath();
            String[] runtimeCmd = new String[]{productInfo, "validate"};
            Process process = runtime.exec(runtimeCmd, null, new File(outputDir, "bin"));
            Thread stderrCopier = new Thread(new OutputStreamCopier(process.getErrorStream(), System.err));
            stderrCopier.start();
            new OutputStreamCopier(process.getInputStream(), System.out).run();
            try {
                stderrCopier.join();
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    protected static FilenameFilter createManifestFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean result = false;
                if (name.endsWith(".mf")) {
                    result = true;
                }
                return result;
            }
        };
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set listMissingCoreFeatures(File outputDir) throws SelfExtractorFileException {
        HashSet<String> missingFeatures = new HashSet<String>();
        if (this.requiredFeatures != null && !"".equals(this.requiredFeatures)) {
            StringTokenizer tokenizer = new StringTokenizer(this.requiredFeatures, ",");
            while (tokenizer.hasMoreElements()) {
                String nextFeature = tokenizer.nextToken();
                if (nextFeature.indexOf(";") >= 0) {
                    nextFeature = nextFeature.substring(0, nextFeature.indexOf(";"));
                }
                missingFeatures.add(nextFeature.trim());
            }
            FilenameFilter manifestFilter = SelfExtractor.createManifestFilter();
            File featuresDir = new File(outputDir + "/lib/features");
            File[] manifestFiles = featuresDir.listFiles(manifestFilter);
            if (manifestFiles != null) {
                for (int i = 0; i < manifestFiles.length && !missingFeatures.isEmpty(); ++i) {
                    FileInputStream fis = null;
                    File currentManifestFile = null;
                    try {
                        currentManifestFile = manifestFiles[i];
                        fis = new FileInputStream(currentManifestFile);
                        Manifest currentManifest = new Manifest(fis);
                        Attributes attrs = currentManifest.getMainAttributes();
                        String manifestSymbolicName = attrs.getValue("Subsystem-SymbolicName");
                        if (manifestSymbolicName.indexOf(";") >= 0) {
                            manifestSymbolicName = manifestSymbolicName.substring(0, manifestSymbolicName.indexOf(";"));
                        }
                        missingFeatures.remove(manifestSymbolicName.trim());
                    }
                    catch (FileNotFoundException fnfe) {
                        try {
                            throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), fnfe);
                            catch (IOException ioe) {
                                throw new SelfExtractorFileException(currentManifestFile.getAbsolutePath(), ioe);
                            }
                        }
                        catch (Throwable throwable) {
                            SelfExtractUtils.tryToClose(fis);
                            throw throwable;
                        }
                    }
                    SelfExtractUtils.tryToClose(fis);
                    continue;
                }
            }
        }
        return missingFeatures;
    }

    public void parseArguments(String[] args, boolean archiveHasLicense) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim().toLowerCase(Locale.ENGLISH);
            if (arg.startsWith("-")) {
                if (SelfExtractor.argIsOption(arg, "-viewlicenseagreement")) {
                    if (archiveHasLicense) {
                        this.showLicenseFile(this.getLicenseAgreement());
                    } else {
                        SelfExtract.out("archiveContainsNoLicense");
                    }
                    System.exit(0);
                    continue;
                }
                if (SelfExtractor.argIsOption(arg, "-viewlicenseinfo") || SelfExtractor.argIsOption(arg, "-viewlicenseinformation")) {
                    if (archiveHasLicense) {
                        this.showLicenseFile(this.getLicenseInformation());
                    } else {
                        SelfExtract.out("archiveContainsNoLicense");
                    }
                    System.exit(0);
                    continue;
                }
                if (SelfExtractor.argIsOption(arg, "-help")) {
                    SelfExtractor.displayCommandLineHelp(this);
                    System.exit(0);
                    continue;
                }
                if (SelfExtractor.argIsOption(arg, "-acceptlicense")) {
                    SelfExtract.setAcceptLicense(true);
                    continue;
                }
                if (SelfExtractor.argIsOption(arg, "-downloadDependencies")) {
                    SelfExtract.setDownloadDependencies(true);
                    continue;
                }
                if (SelfExtractor.argIsOption(arg, "-verbose")) {
                    SelfExtract.setVerbose(true);
                    continue;
                }
                System.out.println("\n" + SelfExtract.format("invalidOption", arg));
                SelfExtractor.displayCommandLineHelp(this);
                System.exit(0);
                continue;
            }
            SelfExtract.setTargetString(args[i]);
        }
    }

    protected static boolean argIsOption(String arg, String option) {
        return arg.equalsIgnoreCase(option) || arg.equalsIgnoreCase('-' + option);
    }

    protected static void displayCommandLineHelp(SelfExtractor extractor) {
        String jarName = System.getProperty("sun.java.command", "wlp-liberty-developers-core.jar");
        String[] s = jarName.split(" ");
        jarName = s[0];
        System.out.println("\n" + SelfExtract.format("usage"));
        System.out.println("\njava -jar " + jarName + " [" + SelfExtract.format("options") + "] [" + SelfExtract.format("installLocation") + "]\n");
        System.out.println(SelfExtract.format("options"));
        System.out.println("    --acceptLicense");
        System.out.println("        " + SelfExtract.format("helpAcceptLicense"));
        System.out.println("    --verbose");
        System.out.println("        " + SelfExtract.format("helpVerbose"));
        System.out.println("    --viewLicenseAgreement");
        System.out.println("        " + SelfExtract.format("helpAgreement"));
        System.out.println("    --viewLicenseInfo");
        System.out.println("        " + SelfExtract.format("helpInformation"));
        if (extractor.isUserSample()) {
            System.out.println("    --downloadDependencies");
            System.out.println("        " + SelfExtract.format("helpDownloadDependencies"));
        }
    }

    public void showLicenseFile(InputStream licenseFile) {
        Object e = SelfExtract.class;
        if (licenseFile != null) {
            e = SelfExtractUtils.showLicenseFile(licenseFile);
        }
        if (e != null) {
            SelfExtract.err("licenseNotFound");
            System.exit(2);
        }
    }

    public void handleLicenseAcceptance(LicenseProvider licenseProvider, boolean acceptLicense) {
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseStatement", new Object[]{licenseProvider.getProgramName(), licenseProvider.getLicenseName()}));
        System.out.println();
        if (acceptLicense) {
            SelfExtract.wordWrappedOut(SelfExtract.format("licenseAccepted", "--acceptLicense"));
            System.out.println();
        } else if (!SelfExtractor.obtainLicenseAgreement(licenseProvider)) {
            System.exit(0);
        }
    }

    private static boolean obtainLicenseAgreement(LicenseProvider licenseProvider) {
        SelfExtract.wordWrappedOut(SelfExtract.format("showAgreement", "--viewLicenseAgreement"));
        boolean view = SelfExtract.getResponse(SelfExtract.format("promptAgreement"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseAgreement());
            System.out.println();
        }
        SelfExtract.wordWrappedOut(SelfExtract.format("showInformation", "--viewLicenseInfo"));
        view = SelfExtract.getResponse(SelfExtract.format("promptInfo"), "", "xX");
        if (view) {
            SelfExtract.showLicenseFile(licenseProvider.getLicenseInformation());
            System.out.println();
        }
        System.out.println();
        SelfExtract.wordWrappedOut(SelfExtract.format("licenseOptionDescription"));
        System.out.println();
        boolean accept = SelfExtract.getResponse(SelfExtract.format("licensePrompt", new Object[]{"[1]", "[2]"}), "1", "2");
        System.out.println();
        return accept;
    }

    public void setProductInstallTypeOveride(String productInstallType) {
        this.productInstallType = productInstallType;
    }

    public void allowNonEmptyInstallDirectory(Boolean allowNonEmptyInstallDirectory) {
        this.allowNonEmptyInstallDirectory = allowNonEmptyInstallDirectory;
    }

    public String close() {
        if (instance == null) {
            return null;
        }
        try {
            this.container.close();
            instance = null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return null;
    }

    static {
        isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") >= 0;
    }

    protected static final class SelfExtractorFileException
    extends Exception {
        private final String fileName;

        public SelfExtractorFileException(String fileName, Throwable exception) {
            super(exception);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    private static class OutputStreamCopier
    implements Runnable {
        private final InputStream in;
        private final PrintStream out;

        OutputStreamCopier(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buf = new byte[4096];
                while ((count = this.in.read(buf)) >= 0) {
                    this.out.write(buf, 0, count);
                }
            }
            catch (IOException ex) {
                this.out.println(ex.getMessage());
            }
        }
    }

    private static class OutputStreamCopierInstallUtil
    implements Runnable {
        private final InputStream in;
        private final StringBuffer output;

        public OutputStreamCopierInstallUtil(InputStream in, StringBuffer output) {
            this.in = in;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                while ((line = reader.readLine()) != null) {
                    this.output.append(line);
                    this.output.append("\n");
                }
            }
            catch (IOException ex) {
                this.output.append(ex.getMessage());
            }
        }
    }

    public static class ExternalDependency {
        private final URL sourceUrl;
        private final String targetPath;

        public ExternalDependency(URL sourceUrl, String targetPath) {
            this.sourceUrl = sourceUrl;
            this.targetPath = targetPath;
        }

        public URL getSourceUrl() {
            return this.sourceUrl;
        }

        public String getTargetPath() {
            return this.targetPath;
        }
    }

    public static class ExternalDependencies {
        private String description = "";
        private final List dependencies = new ArrayList();
        private int size = -1;

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void add(URL sourceUrl, String targetPath) {
            this.dependencies.add(new ExternalDependency(sourceUrl, targetPath));
        }

        public List getDependencies() {
            return this.dependencies;
        }

        public int getSize() {
            if (this.size < 0) {
                int total = 0;
                for (int i = 0; i < this.dependencies.size(); ++i) {
                    URL thisDepURL = ((ExternalDependency)this.dependencies.get(i)).getSourceUrl();
                    int thisDepSize = SelfExtractUtils.tryGetContentLengthOfURL(thisDepURL);
                    if (thisDepSize == -1) continue;
                    total += thisDepSize;
                }
                this.size = total;
            }
            return this.size;
        }
    }

    public static class NullExtractProgress
    implements ExtractProgress {
        @Override
        public void extractedFile(String f) {
        }

        @Override
        public void downloadingFile(URL sourceUrl, File targetFile) {
        }

        @Override
        public void dataDownloaded(int numBytes) {
        }

        @Override
        public void setFilesToExtract(int count) {
        }

        @Override
        public void commandRun(List args) {
        }

        @Override
        public void commandsToRun(int count) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void skippedFile() {
        }
    }
}

