/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import wlp.lib.extract.Content;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;

public class ContentLicenseProvider
implements LicenseProvider {
    private final Content.Entry laEntry;
    private final Content.Entry liEntry;
    private final String pName;
    private final String lName;
    private static LicenseProvider instance;
    private static final String PROGRAM_NAME = "Program Name:";
    private static final String PROGRAM_NAME_PROGRAM_NUMBER = "Program Name (Program Number):";

    private ContentLicenseProvider(Content.Entry laEntry, Content.Entry liEntry, String pName, String lName) {
        this.laEntry = laEntry;
        this.liEntry = liEntry;
        this.pName = pName;
        this.lName = lName;
    }

    public static ReturnCode buildInstance(Content container, String laPrefix, String liPrefix) {
        Content.Entry laEntry = null;
        Content.Entry liEntry = null;
        Content.Entry liEnglishEntry = null;
        try {
            laEntry = SelfExtractUtils.getLicenseFile(container, laPrefix);
            liEntry = SelfExtractUtils.getLicenseFile(container, liPrefix);
            liEnglishEntry = container.getEntry(liPrefix + (liPrefix.endsWith("_") ? "" : "_") + "en");
        }
        catch (Exception e) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        if (container == null || laEntry == null || liEntry == null || liEnglishEntry == null) {
            return new ReturnCode(1, "licenseNotFound", new Object[0]);
        }
        String lName = ContentLicenseProvider.getLicenseName(container, laEntry);
        String pName = ContentLicenseProvider.getProgramName(liEnglishEntry);
        if (pName == null || lName == null) {
            return new ReturnCode(2, "licenseNotFound", new Object[0]);
        }
        instance = new ContentLicenseProvider(laEntry, liEntry, pName, lName);
        return ReturnCode.OK;
    }

    public static LicenseProvider createInstance(Content container, String laPrefix) {
        if (container == null) {
            return null;
        }
        Content.Entry laEntry = null;
        try {
            laEntry = SelfExtractUtils.getLicenseFile(container, laPrefix);
        }
        catch (Exception e) {
            return null;
        }
        String lName = ContentLicenseProvider.getLicenseName(container, laEntry);
        if (lName == null) {
            return null;
        }
        return new ContentLicenseProvider(laEntry, null, null, lName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLicenseName(Content container, Content.Entry laEntry) {
        block10: {
            String string;
            String line;
            BufferedReader r;
            block7: {
                block8: {
                    String sixTh_line;
                    block9: {
                        r = null;
                        r = new BufferedReader(new InputStreamReader(laEntry.getInputStream(), "UTF-16"));
                        line = r.readLine();
                        sixTh_line = "";
                        if (!container.getName().contains("base") && !container.getName().contains("core") && !container.getName().contains("nd")) break block7;
                        for (int i = 0; i < 5; ++i) {
                            sixTh_line = r.readLine();
                        }
                        if (sixTh_line == null) break block8;
                        int startIndex = sixTh_line.indexOf("IBM");
                        if (startIndex <= 0) break block9;
                        String string2 = sixTh_line.substring(startIndex, sixTh_line.length()).trim();
                        SelfExtractUtils.tryToClose(r);
                        return string2;
                    }
                    String string3 = sixTh_line;
                    SelfExtractUtils.tryToClose(r);
                    return string3;
                }
                String string4 = line;
                SelfExtractUtils.tryToClose(r);
                return string4;
            }
            try {
                string = line;
            }
            catch (IOException iOException) {
                SelfExtractUtils.tryToClose(r);
                break block10;
            }
            catch (Throwable throwable) {
                SelfExtractUtils.tryToClose(r);
                throw throwable;
            }
            SelfExtractUtils.tryToClose(r);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getProgramName(Content.Entry liEnglishEntry) {
        r = null;
        line = null;
        try {
            i = 0;
            r = new BufferedReader(new InputStreamReader(liEnglishEntry.getInputStream(), "UTF-16"));
            while (true) {
                line = r.readLine();
                if (line == null) continue;
                if (!line.startsWith("Program Name:")) ** GOTO lbl-1000
                versionIndex = (line = line.substring("Program Name:".length() + 1)).indexOf(" V");
                if (versionIndex > 0) {
                    var5_7 = line.substring(0, versionIndex).trim();
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var3_4) {
            SelfExtractUtils.tryToClose(r);
            return null;
        }
        catch (Throwable var7_12) {
            SelfExtractUtils.tryToClose(r);
            throw var7_12;
        }
        SelfExtractUtils.tryToClose(r);
        return var5_7;
lbl-1000:
        // 1 sources

        {
            var5_8 = line;
        }
        SelfExtractUtils.tryToClose(r);
        return var5_8;
lbl-1000:
        // 1 sources

        {
            if (!line.startsWith("Program Name (Program Number):") || (nextLine = r.readLine()) == null) ** GOTO lbl-1000
            versionIndex = nextLine.indexOf(" V");
            if (versionIndex <= 0) ** GOTO lbl-1000
            var6_10 = nextLine.substring(0, versionIndex).trim();
        }
        SelfExtractUtils.tryToClose(r);
        return var6_10;
lbl-1000:
        // 1 sources

        {
            var6_11 = nextLine;
        }
        SelfExtractUtils.tryToClose(r);
        return var6_11;
lbl-1000:
        // 2 sources

        {
            if (line != null && i++ < 30) ** continue;
        }
        SelfExtractUtils.tryToClose(r);
        return null;
    }

    public static LicenseProvider getInstance() {
        return instance;
    }

    @Override
    public InputStream getLicenseAgreement() {
        try {
            return this.laEntry.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public InputStream getLicenseInformation() {
        try {
            if (this.liEntry != null) {
                return this.liEntry.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getProgramName() {
        return this.pName;
    }

    @Override
    public String getLicenseName() {
        return this.lName;
    }
}

