/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleInstallOriginBundleListener
implements BundleListener {
    private static final TraceComponent tc = Tr.register(BundleInstallOriginBundleListener.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
    private static final String storagePath = "bundle.origin.cache";
    private final BundleContext ctx;
    private final File bundleOriginCache;
    private final Map<Long, Set<Long>> bundleOrigins = Collections.synchronizedMap(new HashMap());
    private final Set<Long> allTracked = new HashSet<Long>();
    static final long serialVersionUID = -6094136040931465036L;

    BundleInstallOriginBundleListener(BundleContext ctx) {
        this.bundleOriginCache = ctx.getDataFile(storagePath);
        this.ctx = ctx.getBundle("System Bundle").getBundleContext();
        this.loadCacheFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheFromDisk() {
        if (this.bundleOriginCache != null && this.bundleOriginCache.exists()) {
            this.debug("Found existing bundle origin cache", this.bundleOriginCache.toString(), this.bundleOriginCache);
            this.readCacheFile();
            this.debug("Repopulated origins cache from disk", this.bundleOriginCache);
            HashSet<Long> installerBundlesToRemove = new HashSet<Long>();
            Map<Long, Set<Long>> map = this.bundleOrigins;
            synchronized (map) {
                for (Map.Entry<Long, Set<Long>> bundleOriginEntry : this.bundleOrigins.entrySet()) {
                    Long installerBundleId = bundleOriginEntry.getKey();
                    Bundle installerBundle = this.ctx.getBundle(installerBundleId.longValue());
                    if (installerBundle != null) continue;
                    this.debug("Installer bundle has been removed", installerBundleId);
                    installerBundlesToRemove.add(installerBundleId);
                }
            }
            for (Long installerBundleId : installerBundlesToRemove) {
                this.processUninstalledInstallerBundle(installerBundleId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        boolean store = false;
        switch (event.getType()) {
            case 1: {
                Bundle installedBundle = event.getBundle();
                if (installedBundle.getLocation().startsWith("feature@")) break;
                Bundle installerBundle = event.getOrigin();
                this.debug("Tracking bundle {0} at location {1} installed by {2}.", installedBundle, installedBundle.getLocation(), installerBundle);
                Map<Long, Set<Long>> map = this.bundleOrigins;
                synchronized (map) {
                    Set<Long> existingInstalleeBundles = this.bundleOrigins.get(installerBundle.getBundleId());
                    if (existingInstalleeBundles == null) {
                        existingInstalleeBundles = new HashSet<Long>();
                        this.bundleOrigins.put(installerBundle.getBundleId(), existingInstalleeBundles);
                    }
                    existingInstalleeBundles.add(installedBundle.getBundleId());
                    this.allTracked.add(installedBundle.getBundleId());
                }
                store = true;
                break;
            }
            case 16: {
                Bundle uninstalledBundle = event.getBundle();
                store = this.processUninstalledInstallerBundle(uninstalledBundle.getBundleId());
                break;
            }
        }
        if (store) {
            this.writeCacheFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUninstalledInstallerBundle(long installerBundleId) {
        boolean uninstalledTracked;
        boolean tracked;
        Set<Long> bundleIdsToUninstall;
        Map<Long, Set<Long>> map = this.bundleOrigins;
        synchronized (map) {
            bundleIdsToUninstall = this.bundleOrigins.remove(installerBundleId);
            if (bundleIdsToUninstall != null) {
                bundleIdsToUninstall = new HashSet<Long>(bundleIdsToUninstall);
            }
            tracked = this.allTracked.remove(installerBundleId);
        }
        boolean bl = uninstalledTracked = bundleIdsToUninstall != null;
        if (uninstalledTracked) {
            this.debug("Installer bundle {0} had installees that need to be uninstalled", installerBundleId);
            Set<Long> unsuccessfulUninstallLocations = this.uninstallInstalleeBundles(bundleIdsToUninstall);
            if (!unsuccessfulUninstallLocations.isEmpty()) {
                this.bundleOrigins.put(installerBundleId, unsuccessfulUninstallLocations);
                this.debug("Not all installees were removed", unsuccessfulUninstallLocations);
            }
        }
        if (tracked) {
            Map<Long, Set<Long>> map2 = this.bundleOrigins;
            synchronized (map2) {
                for (Map.Entry<Long, Set<Long>> entry : this.bundleOrigins.entrySet()) {
                    uninstalledTracked |= entry.getValue().remove(installerBundleId);
                }
            }
        }
        return uninstalledTracked;
    }

    private Set<Long> uninstallInstalleeBundles(Set<Long> installeeBundleIdsToUninstall) {
        HashSet<Long> unsuccessfulUninstallLocations = new HashSet<Long>();
        for (Long installeeBundleId : installeeBundleIdsToUninstall) {
            Bundle installeeBundleToUninstall = this.ctx.getBundle(installeeBundleId.longValue());
            if (installeeBundleToUninstall == null) continue;
            try {
                installeeBundleToUninstall.uninstall();
            }
            catch (BundleException bundleException) {
                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"216", (Object)this, (Object[])new Object[]{installeeBundleIdsToUninstall});
                unsuccessfulUninstallLocations.add(installeeBundleId);
                BundleStartLevel bsl = (BundleStartLevel)installeeBundleToUninstall.adapt(BundleStartLevel.class);
                bsl.setStartLevel(Integer.MAX_VALUE);
            }
        }
        return unsuccessfulUninstallLocations;
    }

    @Trivial
    private void debug(String msg, Object ... objs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)msg, (Object[])objs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile() {
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.bundleOriginCache)));
            try {
                Map<Long, Set<Long>> map = this.bundleOrigins;
                synchronized (map) {
                    out.writeInt(this.bundleOrigins.size());
                    for (Map.Entry<Long, Set<Long>> origin : this.bundleOrigins.entrySet()) {
                        out.writeLong(origin.getKey());
                        out.writeInt(origin.getValue().size());
                        for (Long installed : origin.getValue()) {
                            out.writeLong(installed);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"241", (Object)this, (Object[])new Object[0]);
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"241", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"259", (Object)this, (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCacheFile() {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.bundleOriginCache)));
            try {
                Map<Long, Set<Long>> map = this.bundleOrigins;
                synchronized (map) {
                    this.bundleOrigins.clear();
                    int numOrigins = in.readInt();
                    for (int i = 0; i < numOrigins; ++i) {
                        long installeeId = in.readLong();
                        int numInstalled = in.readInt();
                        HashSet<Long> installed = new HashSet<Long>(numInstalled);
                        for (int j = 0; j < numInstalled; ++j) {
                            long id = in.readLong();
                            installed.add(id);
                            this.allTracked.add(id);
                        }
                        this.bundleOrigins.put(installeeId, installed);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"265", (Object)this, (Object[])new Object[0]);
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"265", (Object)this, (Object[])new Object[0]);
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            in.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.BundleInstallOriginBundleListener", (String)"281", (Object)this, (Object[])new Object[0]);
        }
    }
}

