/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ejbcontainer.AmbiguousEJBReferenceException;
import com.ibm.websphere.ejbcontainer.ApplicationNotStartedException;
import com.ibm.websphere.ejbcontainer.EJBStoppedException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.runtime.EJBApplicationEventListener;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EJBApplicationMetaData {
    private static final String CLASS_NAME = EJBApplicationMetaData.class.getName();
    private static final TraceComponent tc = Tr.register(EJBApplicationMetaData.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final EJSContainer ivContainer;
    private final String ivName;
    private final String ivLogicalName;
    private final boolean ivStandaloneModule;
    private final ApplicationMetaData ivApplicationMetaData;
    private final boolean isCheckpointApplications;
    private final Set<EJBModuleMetaDataImpl> ivModules = new LinkedHashSet<EJBModuleMetaDataImpl>();
    private volatile boolean ivCurrentlyBlockingWork;
    private boolean ivBlockWorkUntilStarted;
    private Thread ivStartupThread;
    private boolean ivBindToServerRoot = ContainerProperties.BindToServerRoot;
    private boolean ivBindToJavaGlobal = ContainerProperties.BindToJavaGlobal;
    private boolean ivCheckConfig;
    private boolean ivIndirectLocalProxies;
    private List<J2EEName> ivStartupSingletonList;
    private List<J2EEName> ivCheckpointSingletonList;
    private LinkedHashMap<BeanMetaData, Set<String>> ivSingletonDependencies;
    private RuntimeWarning ivSingletonDependencyResolutionException;
    private LinkedHashSet<EJSHome> ivSingletonInitializations;
    private List<TimerNpImpl> ivQueuedNonPersistentTimers;
    private List<Runnable> ivPreloadBeanPools;
    private boolean ivStopping;
    private EJBModuleMetaDataImpl ivModuleBeingAddedLate = null;

    public EJBApplicationMetaData(EJSContainer container2, String name, String logicalName, boolean standaloneModule, ApplicationMetaData amd, boolean started, boolean blockWorkUntilStarted) {
        this.ivContainer = container2;
        this.ivName = name;
        this.ivLogicalName = logicalName;
        this.ivStandaloneModule = standaloneModule;
        this.ivApplicationMetaData = amd;
        this.isCheckpointApplications = container2 != null ? container2.getEJBRuntime().isCheckpointApplications() : false;
        this.ivBlockWorkUntilStarted = blockWorkUntilStarted;
        if (!started) {
            this.ivCurrentlyBlockingWork = this.ivBlockWorkUntilStarted;
            this.ivStartupThread = Thread.currentThread();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("EJBApplicationMetaData object created for thread: " + this.ivStartupThread + ", blockWorkUntilStarted=" + blockWorkUntilStarted), (Object[])new Object[0]);
        }
    }

    public String getName() {
        return this.ivName;
    }

    public String getLogicalName() {
        return this.ivLogicalName;
    }

    public boolean isStandaloneModule() {
        return this.ivStandaloneModule;
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.ivApplicationMetaData;
    }

    public void setBindToServerRoot(boolean bind) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBindToServerRoot: " + bind), (Object[])new Object[0]);
        }
        this.ivBindToServerRoot = bind;
    }

    public boolean isBindToServerRoot() {
        return this.ivBindToServerRoot;
    }

    public void setBindToJavaGlobal(boolean bind) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBindToJavaGlobal: " + bind), (Object[])new Object[0]);
        }
        this.ivBindToJavaGlobal = bind;
    }

    public boolean isBindToJavaGlobal() {
        return this.ivBindToJavaGlobal;
    }

    public void setCheckConfig(boolean checkConfig) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCheckConfig: " + checkConfig), (Object[])new Object[0]);
        }
        this.ivCheckConfig = checkConfig;
    }

    public boolean isCheckConfig() {
        return this.ivCheckConfig;
    }

    public void setIndirectLocalProxies(boolean indirectLocalProxies) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setIndirectLocalProxies: " + indirectLocalProxies), (Object[])new Object[0]);
        }
        this.ivIndirectLocalProxies = indirectLocalProxies;
    }

    public boolean isIndirectLocalProxies() {
        return this.ivIndirectLocalProxies;
    }

    public void addSingleton(BeanMetaData bmd, boolean startup, Set<String> dependsOnLinks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addSingleton: " + bmd.j2eeName + " (startup=" + startup + ", dependsOn=" + (dependsOnLinks != null) + ")"), (Object[])new Object[0]);
        }
        if (startup) {
            if (this.ivStartupSingletonList == null) {
                this.ivStartupSingletonList = new ArrayList<J2EEName>();
            }
            this.ivStartupSingletonList.add(bmd.j2eeName);
        } else if (this.isCheckpointApplications && !bmd.ivDeferEJBInitialization) {
            if (this.ivCheckpointSingletonList == null) {
                this.ivCheckpointSingletonList = new ArrayList<J2EEName>();
            }
            this.ivCheckpointSingletonList.add(bmd.j2eeName);
        }
        if (dependsOnLinks != null) {
            if (this.ivSingletonDependencies == null) {
                this.ivSingletonDependencies = new LinkedHashMap();
            }
            this.ivSingletonDependencies.put(bmd, dependsOnLinks);
        }
    }

    public void addPreloadBeanPool(Runnable preloadBeanPool) {
        if (this.ivPreloadBeanPools == null) {
            this.ivPreloadBeanPools = new ArrayList<Runnable>();
        }
        this.ivPreloadBeanPools.add(preloadBeanPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfEJBWorkAllowed(EJBModuleMetaDataImpl module) {
        EJBModuleMetaDataImpl moduleBeingAddedLate;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (!this.ivCurrentlyBlockingWork) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkIfEJBWorkAllowed: " + module.getJ2EEName() + ": not blocking work"), (Object[])new Object[0]);
            }
            return true;
        }
        EJBApplicationMetaData eJBApplicationMetaData = this;
        synchronized (eJBApplicationMetaData) {
            if (!this.ivCurrentlyBlockingWork) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkIfEJBWorkAllowed: " + module.getJ2EEName() + ": not blocking work"), (Object[])new Object[0]);
                }
                return true;
            }
            if (this.ivStartupThread == Thread.currentThread()) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkIfEJBWorkAllowed: " + module.getJ2EEName() + ": allowing startup thread"), (Object[])new Object[0]);
                }
                return false;
            }
            moduleBeingAddedLate = this.ivModuleBeingAddedLate;
            if (moduleBeingAddedLate != null && moduleBeingAddedLate != module) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkIfEJBWorkAllowed: " + module.getJ2EEName() + ": allowing non-late-add module"), (Object[])new Object[0]);
                }
                return true;
            }
            long begin = System.nanoTime();
            long end = begin + TimeUnit.MILLISECONDS.toNanos(ContainerProperties.BlockWorkUntilAppStartedWaitTime);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkIfEJBWorkAllowed: " + module.getJ2EEName() + ": waiting for application to start"), (Object[])new Object[0]);
            }
            while (this.ivCurrentlyBlockingWork && (moduleBeingAddedLate == null || moduleBeingAddedLate == this.ivModuleBeingAddedLate)) {
                try {
                    long waitTime = end - System.nanoTime();
                    if (waitTime <= 0L) {
                        if (isTraceOn && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"checkIfEJBWorkAllowed: wait timed out", (Object[])new Object[0]);
                        }
                        if (moduleBeingAddedLate != null) {
                            throw new ApplicationNotStartedException("module " + module.getName() + " in application " + this.ivName + " has not finished startup processing");
                        }
                        throw new ApplicationNotStartedException("application " + this.ivName + " has not finished startup processing");
                    }
                    TimeUnit.NANOSECONDS.timedWait(this, waitTime);
                }
                catch (InterruptedException ex) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"checkIfEJBWorkAllowed: wait interrupted", (Object[])new Object[0]);
                    }
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".checkIfEJBWorkAllowed"), (String)"360", (Object)this);
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (moduleBeingAddedLate != null && moduleBeingAddedLate.ivStopping) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkIfEJBWorkAllowed: module failed to start", (Object[])new Object[0]);
            }
            throw new EJBStoppedException("module " + module.getName() + " in application " + this.ivName + " failed to start");
        }
        if (this.ivStopping) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkIfEJBWorkAllowed: application failed to start", (Object[])new Object[0]);
            }
            throw new EJBStoppedException("application " + this.ivName + " failed to start");
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checkIfEJBWorkAllowed: application started", (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized void checkIfCreateNonPersistentTimerAllowed(EJBModuleMetaDataImpl mmd) {
        if (this.ivStopping) {
            throw new EJBStoppedException(this.ivName);
        }
        if (mmd != null && mmd.ivStopping) {
            throw new EJBStoppedException(mmd.getJ2EEName().toString());
        }
    }

    public synchronized void startingModule(EJBModuleMetaDataImpl mmd, boolean blockWorkUntilStarted) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startingModule: " + mmd.getJ2EEName() + ", blockWorkUntilStarted=" + blockWorkUntilStarted + ", started=" + this.isStarted()), (Object[])new Object[0]);
        }
        this.ivModules.add(mmd);
        if (this.isStarted()) {
            this.ivModuleBeingAddedLate = mmd;
            this.ivStartupThread = Thread.currentThread();
            this.ivBlockWorkUntilStarted |= blockWorkUntilStarted;
            this.ivCurrentlyBlockingWork = this.ivBlockWorkUntilStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStarting() throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("finishStarting: " + this.ivName), (Object[])new Object[0]);
        }
        if (this.ivModules != null) {
            this.notifyApplicationEventListeners(this.ivModules, true);
        }
        this.unblockThreadsWaitingForStart();
        if (this.ivCheckpointSingletonList != null) {
            this.createSingletonBeansForCheckpoint();
            this.ivCheckpointSingletonList = null;
        }
        if (this.ivPreloadBeanPools != null) {
            this.preloadBeanPools();
            this.ivPreloadBeanPools = null;
        }
        EJBApplicationMetaData eJBApplicationMetaData = this;
        synchronized (eJBApplicationMetaData) {
            if (this.ivQueuedNonPersistentTimers != null) {
                this.startQueuedNonPersistentTimerAlarms();
                this.ivQueuedNonPersistentTimers = null;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishStarting");
        }
    }

    public void startedModule(EJBModuleMetaDataImpl mmd) throws RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startedModule: " + mmd.getJ2EEName()), (Object[])new Object[0]);
        }
        if (this.ivSingletonDependencies != null) {
            this.resolveDependencies();
            this.ivSingletonDependencies = null;
        }
        if (this.ivStartupSingletonList != null) {
            this.createStartupBeans();
            this.ivStartupSingletonList = null;
        }
        if (this.ivModuleBeingAddedLate == mmd) {
            this.finishStarting();
        }
    }

    public void started() throws RuntimeWarning {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"started", (Object[])new Object[0]);
        }
        this.finishStarting();
    }

    private synchronized void unblockThreadsWaitingForStart() {
        this.ivStartupThread = null;
        this.ivModuleBeingAddedLate = null;
        this.ivCurrentlyBlockingWork = false;
        this.notifyAll();
    }

    private HomeRecord resolveEJBLink(J2EEName source, String link) throws RuntimeWarning {
        HomeRecord result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolveEJBLink: " + link), (Object[])new Object[0]);
        }
        String module = source.getModule();
        String component = source.getComponent();
        try {
            result = EJSContainer.homeOfHomes.resolveEJBLink(source.getApplication(), module, link);
        }
        catch (EJBNotFoundException ex) {
            Tr.error((TraceComponent)tc, (String)"SINGLETON_DEPENDS_ON_NONEXISTENT_BEAN_CNTR0198E", (Object[])new Object[]{component, module, link});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolveEJBLink");
            }
            throw new RuntimeWarning("CNTR0198E: The " + component + " singleton session bean in the " + module + " module depends on " + link + ", which does not exist.", (Throwable)ex);
        }
        catch (AmbiguousEJBReferenceException ex) {
            Tr.error((TraceComponent)tc, (String)"SINGLETON_DEPENDS_ON_AMBIGUOUS_NAME_CNTR0199E", (Object[])new Object[]{component, module, link});
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"resolveEJBLink");
            }
            throw new RuntimeWarning("CNTR0199E: The " + component + " singleton session bean in the " + module + " module depends on " + link + ", which does not uniquely specify an enterprise bean.", (Throwable)((Object)ex));
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolveEJBLink: " + result));
        }
        return result;
    }

    private void resolveDependencies() throws RuntimeWarning {
        if (EJSPlatformHelper.isZOSCRA()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resolveDependencies: skipped in adjunct process", (Object[])new Object[0]);
            }
            return;
        }
        if (this.ivSingletonDependencyResolutionException != null) {
            throw this.ivSingletonDependencyResolutionException;
        }
        HashSet<BeanMetaData> used = new HashSet<BeanMetaData>();
        for (BeanMetaData bmd : new ArrayList<BeanMetaData>(this.ivSingletonDependencies.keySet())) {
            used.add(bmd);
            this.resolveBeanDependencies(bmd, used);
            used.remove(bmd);
        }
    }

    private void resolveBeanDependencies(BeanMetaData bmd, Set<BeanMetaData> used) throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolveBeanDependencies: " + bmd.j2eeName), (Object[])new Object[0]);
        }
        if (bmd.ivDependsOn != null) {
            return;
        }
        bmd.ivDependsOn = new ArrayList<J2EEName>();
        Set dependsOnLinks = (Set)this.ivSingletonDependencies.remove(bmd);
        if (dependsOnLinks == null) {
            return;
        }
        for (String dependencyLink : dependsOnLinks) {
            HomeRecord hr = this.resolveEJBLink(bmd.j2eeName, dependencyLink);
            BeanMetaData dependency = hr.getBeanMetaData();
            J2EEName dependencyName = dependency.j2eeName;
            if (!dependency.isSingletonSessionBean()) {
                Tr.error((TraceComponent)tc, (String)"SINGLETON_DEPENDS_ON_NON_SINGLETON_BEAN_CNTR0200E", (Object[])new Object[]{bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), dependencyName.getComponent(), dependencyName.getModule()});
                throw new RuntimeWarning("CNTR0200E: The " + bmd.j2eeName.getComponent() + " singleton session bean in the " + bmd.j2eeName.getModule() + " module depends on the " + dependencyName.getComponent() + " enterprise bean in the " + dependencyName.getModule() + ", but the target is not a singleton session bean.");
            }
            if (!used.add(dependency)) {
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("circular dependency from " + dependencyName), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"SINGLETON_DEPENDS_ON_SELF_CNTR0201E", (Object[])new Object[]{dependencyName.getComponent(), dependencyName.getModule()});
                throw new RuntimeWarning("CNTR0201E: The " + dependencyName.getComponent() + " singleton session bean in the " + dependencyName.getModule() + " module directly or indirectly depends on itself.");
            }
            bmd.ivDependsOn.add(dependencyName);
            this.resolveBeanDependencies(dependency, used);
            used.remove(dependency);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolveBeanDependencies: " + bmd.j2eeName));
        }
    }

    public List<J2EEName> resolveBeanDependencies(BeanMetaData bmd) throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolveBeanDependencies: " + bmd.j2eeName), (Object[])new Object[0]);
        }
        if (bmd.ivDependsOn == null && this.ivSingletonDependencies != null) {
            HashSet<BeanMetaData> used = new HashSet<BeanMetaData>();
            used.add(bmd);
            try {
                this.resolveBeanDependencies(bmd, used);
            }
            catch (RuntimeWarning ex) {
                this.ivSingletonDependencyResolutionException = ex;
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("resolveBeanDependencies: " + (Object)((Object)ex)));
                }
                throw ex;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolveBeanDependencies: " + bmd.ivDependsOn));
        }
        return bmd.ivDependsOn;
    }

    private void createStartupBeans() throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (EJSPlatformHelper.isZOSCRA()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createStartupBeans: skipped in adjunct process", (Object[])new Object[0]);
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStartupBeans", (Object[])new Object[0]);
        }
        int size = this.ivStartupSingletonList.size();
        for (int i = 0; i < size; ++i) {
            J2EEName startupName = this.ivStartupSingletonList.get(i);
            try {
                EJSHome home = (EJSHome)EJSContainer.homeOfHomes.getHome(startupName);
                if (home == null) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring Singleton Startup bean: " + startupName), (Object[])new Object[0]);
                    continue;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Creating instance for Singleton Startup bean: " + startupName.toString()), (Object[])new Object[0]);
                }
                home.createSingletonBeanO();
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".createStartupBeans"), (String)"6921", (Object)this);
                Tr.error((TraceComponent)tc, (String)"STARTUP_SINGLETON_SESSION_BEAN_INITIALIZATION_FAILED_CNTR0190E", (Object[])new Object[]{startupName.getComponent(), startupName.getModule(), t});
                throw new RuntimeWarning("CNTR0201E: The " + startupName.getComponent() + " startup singleton session bean in the " + startupName.getModule() + " module failed initialization.", t);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStartupBeans");
        }
    }

    private void createSingletonBeansForCheckpoint() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (EJSPlatformHelper.isZOSCRA()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createSingletonBeansForCheckpoint: skipped in adjunct process", (Object[])new Object[0]);
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createSingletonBeansForCheckpoint : " + this.ivCheckpointSingletonList.size()), (Object[])new Object[0]);
        }
        int size = this.ivCheckpointSingletonList.size();
        for (int i = 0; i < size; ++i) {
            J2EEName singletonName = this.ivCheckpointSingletonList.get(i);
            try {
                EJSHome home = (EJSHome)EJSContainer.homeOfHomes.getHome(singletonName);
                if (home == null) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Ignoring Singleton bean: " + singletonName), (Object[])new Object[0]);
                    continue;
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Creating instance for Singleton bean: " + singletonName.toString()), (Object[])new Object[0]);
                }
                home.createSingletonBeanO();
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".createSingletonBeansForCheckpoint"), (String)"1052", (Object)this);
                Tr.error((TraceComponent)tc, (String)"UNEXPECTED_EJB_START_FAILURE_CNTR0149E", (Object[])new Object[]{singletonName.getComponent(), singletonName.getModule(), t});
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSingletonBeansForCheckpoint");
        }
    }

    private void preloadBeanPools() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (EJSPlatformHelper.isZOSCRA()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"preloadBeanPools: skipped in adjunct process", (Object[])new Object[0]);
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("preloadBeanPools : " + this.ivPreloadBeanPools.size() + " beans"), (Object[])new Object[0]);
        }
        ArrayList preloadFutures = new ArrayList();
        ScheduledExecutorService executor = this.ivContainer.getEJBRuntime().getScheduledExecutorService();
        for (Runnable preloadBeanPool : this.ivPreloadBeanPools) {
            ScheduledFuture<?> preloadFuture = executor.schedule(preloadBeanPool, 0L, TimeUnit.MILLISECONDS);
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("preloadBeanPool scheduled : " + preloadFuture), (Object[])new Object[0]);
            }
            preloadFutures.add(preloadFuture);
        }
        if (this.isCheckpointApplications) {
            long timeout = 10L;
            for (ScheduledFuture scheduledFuture : preloadFutures) {
                try {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkpoint - waiting " + timeout + "s : " + scheduledFuture), (Object[])new Object[0]);
                    }
                    scheduledFuture.get(timeout, TimeUnit.SECONDS);
                }
                catch (TimeoutException tex) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"checkpoint - TimeoutException", (Object[])new Object[0]);
                    }
                    timeout = 1L;
                }
                catch (InterruptedException | ExecutionException ex) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("checkpoint - continuing : " + ex), (Object[])new Object[0]);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preloadBeanPools");
        }
    }

    private void notifyApplicationEventListeners(Collection<EJBModuleMetaDataImpl> modules, boolean started) throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("notifyApplicationEventListeners: started=" + started), (Object[])new Object[0]);
        }
        RuntimeWarning warning = null;
        for (EJBModuleMetaDataImpl mmd : modules) {
            List<EJBApplicationEventListener> listeners;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notifying listeners in module: " + mmd.ivJ2EEName), (Object[])new Object[0]);
            }
            if ((listeners = mmd.ivApplicationEventListeners) == null) continue;
            for (EJBApplicationEventListener listener : listeners) {
                try {
                    if (started) {
                        listener.applicationStarted(this.ivName);
                        continue;
                    }
                    listener.applicationStopping(this.ivName);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".notifyApplicationEventListeners"), (String)"781", (Object)this);
                    if (isTraceOn && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)(listener + " threw unexpected throwable: " + t), (Object[])new Object[]{t});
                    }
                    if (warning != null) continue;
                    warning = new RuntimeWarning(t);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("notifyApplicationEventListeners: exception=" + warning));
        }
        if (warning != null) {
            throw warning;
        }
    }

    private void startQueuedNonPersistentTimerAlarms() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (EJSPlatformHelper.isZOSCRA()) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"startQueuedNonPersistentTimerAlarms: skipped in adjunct process", (Object[])new Object[0]);
            }
            return;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startQueuedNonPersistentTimers", (Object[])new Object[0]);
        }
        for (TimerNpImpl timer : this.ivQueuedNonPersistentTimers) {
            timer.schedule();
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startQueuedNonPersistentTimers");
        }
    }

    public synchronized void addSingletonInitialization(EJSHome home) {
        if (this.ivStopping) {
            throw new EJBStoppedException(home.getJ2EEName().toString());
        }
        if (this.ivSingletonInitializations == null) {
            this.ivSingletonInitializations = new LinkedHashSet();
        }
        this.ivSingletonInitializations.add(home);
    }

    public synchronized boolean queueOrStartNonPersistentTimerAlarm(TimerNpImpl timer, EJBModuleMetaDataImpl module) {
        if (this.ivStopping) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("not starting timer alarm after application stop: " + timer), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.isStarted()) {
            timer.schedule();
        } else if (this.ivModuleBeingAddedLate != null && this.ivModuleBeingAddedLate != module) {
            timer.schedule();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("queueing timer alarm until full application start: " + timer), (Object[])new Object[0]);
            }
            if (this.ivQueuedNonPersistentTimers == null) {
                this.ivQueuedNonPersistentTimers = new ArrayList<TimerNpImpl>();
            }
            this.ivQueuedNonPersistentTimers.add(timer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginStopping(boolean application, J2EEName j2eeName, Collection<EJBModuleMetaDataImpl> modules) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("beginStopping: application=" + application + ", " + j2eeName), (Object[])new Object[0]);
        }
        EJBApplicationMetaData eJBApplicationMetaData = this;
        synchronized (eJBApplicationMetaData) {
            if (application) {
                this.ivStopping = true;
            }
            this.unblockThreadsWaitingForStart();
        }
        if (j2eeName != null) {
            this.ivContainer.getEJBRuntime().removeTimers(j2eeName);
        }
        if (this.ivSingletonInitializations != null) {
            ArrayList<EJSHome> reverse = new ArrayList<EJSHome>(this.ivSingletonInitializations);
            int i = reverse.size();
            while (--i >= 0) {
                EJSHome home = (EJSHome)reverse.get(i);
                J2EEName homeJ2EEName = home.getJ2EEName();
                if (!application && !j2eeName.getModule().equals(homeJ2EEName.getModule())) continue;
                home.destroy();
                this.ivSingletonInitializations.remove(home);
            }
        }
        try {
            this.notifyApplicationEventListeners(modules, false);
        }
        catch (RuntimeWarning rw) {
            FFDCFilter.processException((Throwable)rw, (String)(CLASS_NAME + ".stopping"), (String)"977", (Object)this);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"beginStopping");
        }
    }

    public void stoppingModule(EJBModuleMetaDataImpl mmd) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stoppingModule: " + mmd.getJ2EEName()), (Object[])new Object[0]);
        }
        if (!this.ivStopping) {
            mmd.ivStopping = true;
            this.ivModules.remove(mmd);
            try {
                this.beginStopping(false, mmd.getJ2EEName(), Collections.singletonList(mmd));
            }
            finally {
                this.ivSingletonDependencies = null;
                this.ivStartupSingletonList = null;
                this.ivCheckpointSingletonList = null;
                this.ivQueuedNonPersistentTimers = null;
                this.ivPreloadBeanPools = null;
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stoppingModule");
        }
    }

    public void stopping() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"stopping", (Object[])new Object[0]);
        }
        J2EEName j2eeName = this.ivApplicationMetaData == null ? null : this.ivApplicationMetaData.getJ2EEName();
        this.beginStopping(true, j2eeName, this.ivModules);
    }

    public boolean isStarted() {
        return this.ivStartupThread == null;
    }

    public boolean isStopping() {
        return this.ivStopping;
    }

    void validateVersionedModuleBaseName(String appBaseName, String modBaseName) {
        for (EJBModuleMetaDataImpl ejbMMD : this.ivModules) {
            String versionedAppBaseName = ejbMMD.ivVersionedAppBaseName;
            if (versionedAppBaseName != null && !versionedAppBaseName.equals(appBaseName)) {
                throw new IllegalArgumentException("appBaseName (" + appBaseName + ") does not equal previously set value : " + versionedAppBaseName);
            }
            if (!modBaseName.equals(ejbMMD.ivVersionedModuleBaseName)) continue;
            throw new IllegalArgumentException("duplicate baseName : " + modBaseName);
        }
    }
}

