/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BusinessLocalWrapperProxy;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.EJSLocalWrapperProxy;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.container.LocalBeanWrapperProxy;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperProxy;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.EJBSerializer;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.EJBException;

public abstract class WrapperProxyState {
    static final TraceComponent tc = Tr.register(WrapperProxyState.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    final J2EEName ivJ2EEName;
    private final J2EEName ivUnversionedJ2EEName;
    private final byte[] ivUnversionedSerializerBytes;
    BeanId ivBeanId;
    volatile Object ivWrapper;

    public static WrapperProxyState getWrapperProxyState(Object proxy) {
        if (proxy instanceof BusinessLocalWrapperProxy) {
            return ((BusinessLocalWrapperProxy)proxy).ivState;
        }
        if (proxy instanceof EJSLocalWrapperProxy) {
            return ((EJSLocalWrapperProxy)proxy).ivState;
        }
        if (proxy instanceof LocalBeanWrapperProxy) {
            return EJSWrapperCommon.getLocalBeanWrapperProxyState((LocalBeanWrapperProxy)proxy);
        }
        if (proxy instanceof WrapperProxy) {
            throw new IllegalStateException(Util.identity((Object)proxy));
        }
        throw new IllegalArgumentException(Util.identity((Object)proxy));
    }

    WrapperProxyState(EJSHome home, BeanId beanId, Object wrapper) {
        this.ivJ2EEName = home.getJ2EEName();
        J2EEName unversionedJ2EEName = null;
        byte[] unversionedSerializerBytes = null;
        BeanMetaData bmd = home.beanMetaData;
        if (bmd.ivUnversionedJ2eeName != null) {
            unversionedJ2EEName = bmd.ivUnversionedJ2eeName;
            unversionedSerializerBytes = beanId.getByteArrayBytes();
        }
        this.ivUnversionedJ2EEName = unversionedJ2EEName;
        this.ivUnversionedSerializerBytes = unversionedSerializerBytes;
        this.connect(beanId, wrapper);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('(');
        builder.append(this.ivJ2EEName.toString());
        if (this.ivWrapper == null) {
            builder.append(", disconnected");
        }
        if (this.ivUnversionedJ2EEName != null) {
            builder.append(", unversioned: " + this.ivUnversionedJ2EEName.getModule());
        }
        return builder.append(')').toString();
    }

    public abstract int hashCode();

    public abstract boolean equals(WrapperProxyState var1);

    final void connect(BeanId beanId, Object wrapper) {
        this.ivBeanId = beanId;
        this.ivWrapper = wrapper;
    }

    final void disconnect() {
        this.ivBeanId = null;
        this.ivWrapper = null;
    }

    final WrapperProxyState reconnect() {
        WrapperProxyState state;
        J2EEName j2eeName;
        HomeOfHomes homeOfHomes;
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("reconnect: " + this), (Object[])new Object[0]);
        }
        if ((home = (EJSHome)(homeOfHomes = EJSContainer.homeOfHomes).getHome(j2eeName = this.ivUnversionedJ2EEName == null ? this.ivJ2EEName : homeOfHomes.getVersionedJ2EEName(this.ivUnversionedJ2EEName))) == null) {
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconnect: stopped");
            }
            throw new EJBException("The referenced " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " module in the " + j2eeName.getApplication() + " application has been stopped and must be started again to be used.");
        }
        try {
            state = this.reconnect(home);
        }
        catch (RemoteException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".update"), (String)"225", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reconnect", (Object)ex);
            }
            throw new EJBException((Exception)ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reconnect");
        }
        return state;
    }

    abstract WrapperProxyState reconnect(EJSHome var1) throws RemoteException;

    public abstract EJBSerializer.ObjectType getSerializerObjectType();

    public final byte[] getSerializerBytes() {
        if (this.ivUnversionedSerializerBytes != null) {
            return this.ivUnversionedSerializerBytes;
        }
        BeanId beanId = this.ivBeanId;
        if (beanId == null) {
            beanId = this.getSerializerBeanId(this.ivJ2EEName);
        }
        return this.getSerializerBytes(beanId);
    }

    abstract BeanId getSerializerBeanId(J2EEName var1);

    byte[] getSerializerBytes(BeanId beanId) {
        return beanId.getByteArrayBytes();
    }

    static class BusinessLocal
    extends AbstractObjectState {
        private final Class<?> ivBusinessInterface;
        private final int ivBusinessInterfaceIndex;

        BusinessLocal(EJSHome home, BeanId beanId, Object wrapper, Class<?> businessInterface, int businessInterfaceIndex) {
            super(home, beanId, wrapper);
            this.ivBusinessInterface = businessInterface;
            this.ivBusinessInterfaceIndex = businessInterfaceIndex;
        }

        @Override
        public int hashCode() {
            return this.ivJ2EEName.hashCode() + this.ivBusinessInterface.hashCode();
        }

        @Override
        public boolean equals(WrapperProxyState state) {
            return state instanceof BusinessLocal && this.ivJ2EEName.equals(state.ivJ2EEName) && this.ivBusinessInterface == ((BusinessLocal)state).ivBusinessInterface;
        }

        @Override
        Serializable getPrimaryKey() {
            return null;
        }

        @Override
        WrapperProxyState reconnect(EJSWrapperCommon wrappers) {
            return wrappers.getLocalBusinessWrapperProxyState(this.ivBusinessInterface);
        }

        @Override
        public EJBSerializer.ObjectType getSerializerObjectType() {
            return EJBSerializer.ObjectType.EJB_BUSINESS_LOCAL;
        }

        @Override
        public byte[] getSerializerBytes(BeanId beanId) {
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), this.ivBusinessInterface.getName(), this.ivBusinessInterfaceIndex);
            return wrapperId.getBytes();
        }
    }

    static class LocalObject
    extends AbstractObjectState {
        private final Serializable ivPrimaryKey;

        LocalObject(EJSHome home, EJSLocalWrapper wrapper) {
            super(home, wrapper.beanId, wrapper);
            this.ivPrimaryKey = wrapper.beanId.getPrimaryKey();
        }

        @Override
        public int hashCode() {
            return this.ivJ2EEName.hashCode();
        }

        @Override
        public boolean equals(WrapperProxyState state) {
            return state instanceof LocalObject && this.ivJ2EEName.equals(state.ivJ2EEName);
        }

        @Override
        Serializable getPrimaryKey() {
            return this.ivPrimaryKey;
        }

        @Override
        WrapperProxyState reconnect(EJSWrapperCommon wrappers) {
            return wrappers.getLocalWrapperProxyState();
        }

        @Override
        public EJBSerializer.ObjectType getSerializerObjectType() {
            return EJBSerializer.ObjectType.EJB_LOCAL_OBJECT;
        }
    }

    static abstract class AbstractObjectState
    extends WrapperProxyState {
        AbstractObjectState(EJSHome home, BeanId beanId, Object wrapper) {
            super(home, beanId, wrapper);
        }

        @Override
        final WrapperProxyState reconnect(EJSHome home) throws RemoteException {
            BeanId beanId = new BeanId(home, this.getPrimaryKey());
            EJSWrapperCommon wrappers = EJSContainer.getDefaultContainer().wrapperManager.getWrapper(beanId);
            return this.reconnect(wrappers);
        }

        abstract Serializable getPrimaryKey();

        abstract WrapperProxyState reconnect(EJSWrapperCommon var1);

        @Override
        public final BeanId getSerializerBeanId(J2EEName j2eeName) {
            return new BeanId(j2eeName, this.getPrimaryKey(), false);
        }
    }

    static class LocalHome
    extends WrapperProxyState {
        LocalHome(EJSHome home, EJSLocalWrapper wrapper) {
            super(home, wrapper.beanId, wrapper);
        }

        @Override
        public int hashCode() {
            return this.ivJ2EEName.hashCode() + 1;
        }

        @Override
        public boolean equals(WrapperProxyState state) {
            return state instanceof LocalHome && this.ivJ2EEName.equals(state.ivJ2EEName);
        }

        @Override
        WrapperProxyState reconnect(EJSHome home) throws RemoteException {
            return home.getWrapper().getLocalWrapperProxyState();
        }

        @Override
        public EJBSerializer.ObjectType getSerializerObjectType() {
            return EJBSerializer.ObjectType.EJB_LOCAL_HOME;
        }

        @Override
        public BeanId getSerializerBeanId(J2EEName j2eeName) {
            return new BeanId(EJSContainer.homeOfHomes.getJ2EEName(), (Serializable)j2eeName, true);
        }
    }
}

