/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.security.utils.SecurityUtils;
import com.ibm.wsspi.security.audit.AuditService;

@Trivial
public class Audit {
    public static boolean isAuditServiceEnabled() {
        return SecurityUtils.getAuditService() != null;
    }

    public static boolean isAuditRequired(EventID eventID, String outcome) {
        AuditService auditService = SecurityUtils.getAuditService();
        if (auditService == null) {
            return false;
        }
        return auditService.isAuditRequired(eventID.getEventType(), outcome);
    }

    @Trivial
    public static void audit(EventID eventId, Object ... params) {
    }

    @Trivial
    public static enum EventID {
        SECURITY_AUTHN_01("SECURITY_AUTHN"),
        SECURITY_AUTHZ_01("SECURITY_AUTHZ"),
        SECURITY_AUTHZ_02("SECURITY_AUTHZ"),
        SECURITY_AUTHZ_03("SECURITY_AUTHZ"),
        SECURITY_AUTHZ_04("SECURITY_AUTHZ"),
        SECURITY_AUDIT_MGMT_01("SECURITY_AUDIT_MGMT"),
        SECURITY_AUDIT_MGMT_02("SECURITY_AUDIT_MGMT"),
        SECURITY_AUTHN_DELEGATION_01("SECURITY_AUTHN_DELEGATION"),
        SECURITY_AUTHZ_DELEGATION_01("SECURITY_AUTHZ_DELEGATION"),
        SECURITY_API_AUTHN_01("SECURITY_API_AUTHN"),
        SECURITY_API_AUTHN_TERMINATE_01("SECURITY_API_AUTHN_TERMINATE"),
        SECURITY_AUTHN_TERMINATE_01("SECURITY_AUTHN_TERMINATE"),
        SECURITY_AUTHN_FAILOVER_01("SECURITY_AUTHN_FAILOVER"),
        SECURITY_MEMBER_MGMT_01("SECURITY_MEMBER_MGMT"),
        SECURITY_JMS_AUTHN_01("SECURITY_JMS_AUTHN"),
        SECURITY_JMS_AUTHZ_01("SECURITY_JMS_AUTHZ"),
        SECURITY_JMS_AUTHN_TERMINATE_01("SECURITY_JMS_AUTHN_TERMINATE"),
        SECURITY_JMS_CLOSED_CONNECTION_01("SECURITY_JMS_CLOSED_CONNECTION"),
        SECURITY_REST_HANDLER_AUTHZ("SECURITY_REST_HANDLER_AUTHZ"),
        SECURITY_SAF_AUTHZ("SECURITY_SAF_AUTHZ"),
        SECURITY_SAF_AUTHZ_DETAILS("SECURITY_SAF_AUTHZ_DETAILS"),
        JMX_NOTIFICATION_01("JMX_NOTIFICATION"),
        JMX_MBEAN_01("JMX_MBEAN"),
        JMX_MBEAN_ATTRIBUTES_01("JMX_MBEAN_ATTRIBUTES"),
        JMX_MBEAN_REGISTER_01("JMX_MBEAN_REGISTER"),
        APPLICATION_PASSWORD_TOKEN_01("APPLICATION_TOKEN_MANAGEMENT");

        final String eventType;

        private EventID(String eventType) {
            this.eventType = eventType;
        }

        public String getEventType() {
            return this.eventType;
        }
    }
}

