/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ras;

import com.ibm.websphere.ras.Traceable;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public final class ProtectedString
implements Traceable,
FFDCSelfIntrospectable {
    private static final byte[] SALT;
    public static final ProtectedString NULL_PROTECTED_STRING;
    public static final ProtectedString EMPTY_PROTECTED_STRING;
    @Sensitive
    private final char[] _password;
    private String _traceableString = null;

    public ProtectedString(@Sensitive char[] password) {
        if (password != null) {
            if (password.length != 0) {
                this._password = new char[password.length];
                System.arraycopy(password, 0, this._password, 0, password.length);
            } else {
                this._password = password;
            }
        } else {
            this._password = null;
        }
    }

    @Sensitive
    public char[] getChars() {
        if (this._password != null) {
            if (this._password.length != 0) {
                char[] result = new char[this._password.length];
                System.arraycopy(this._password, 0, result, 0, this._password.length);
                return result;
            }
            return this._password;
        }
        return null;
    }

    public String toString() {
        if (this._password != null) {
            return "*****";
        }
        return "null";
    }

    @Override
    public String toTraceString() {
        if (this._traceableString == null) {
            if (this._password != null) {
                try {
                    MessageDigest digester = MessageDigest.getInstance("SHA-512");
                    digester.update(SALT);
                    for (char c : this._password) {
                        digester.update((byte)((c & 0xFF00) >> 8));
                        digester.update((byte)(c & 0xFF));
                    }
                    byte[] hash = digester.digest();
                    StringBuilder sb = new StringBuilder();
                    for (byte b : hash) {
                        int i = b & 0xF;
                        sb.append(Integer.toHexString(i));
                    }
                    this._traceableString = sb.toString();
                }
                catch (NoSuchAlgorithmException nsae) {
                    this._traceableString = this.toString();
                }
            } else {
                this._traceableString = "";
            }
        }
        return this._traceableString;
    }

    @Override
    public String[] introspectSelf() {
        return new String[]{"_password = " + this.toString(), "_traceablePassword = " + this.toTraceString()};
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ProtectedString) {
            ProtectedString other = (ProtectedString)o;
            return Arrays.equals(this._password, other._password);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this._password);
    }

    public boolean isEmpty() {
        return this._password == null || this._password.length == 0;
    }

    static {
        SecureRandom sr = new SecureRandom();
        SALT = new byte[12];
        sr.nextBytes(SALT);
        NULL_PROTECTED_STRING = new ProtectedString(null);
        EMPTY_PROTECTED_STRING = new ProtectedString(new char[0]);
    }
}

