/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.logging.DebugLog;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class HttpICLReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpICLReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpICLReadCallback myInstance = new HttpICLReadCallback();

    private HttpICLReadCallback() {
    }

    public static final HttpICLReadCallback getRef() {
        return myInstance;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + vc), (Object[])new Object[0]);
        }
        HttpInboundLink myLink = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        myLink.processRequest();
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        HttpInboundLink myLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + vc), (Object[])new Object[0]);
        }
        if ((myLink = (HttpInboundLink)(vc == null ? null : vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL))) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"error: myLink is null", (Object[])new Object[0]);
            }
        } else {
            HttpInboundServiceContextImpl isc = myLink.getHTTPContext();
            isc.setPersistent(false);
            myLink.setFilterCloseExceptions(true);
            if ((myLink.isFirstRequest() || myLink.isPartiallyParsed()) && ioe instanceof SocketTimeoutException) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error, sending 408 timeout back", (Object[])new Object[0]);
                    }
                    if (isc.getHttpConfig().getDebugLog().isEnabled(DebugLog.Level.WARN)) {
                        isc.getHttpConfig().getDebugLog().log(DebugLog.Level.WARN, "A read during the connection failed due to a socket exception.", (HttpServiceContext)isc);
                    }
                    isc.setHeadersParsed();
                    isc.sendError(StatusCodes.REQ_TIMEOUT.getHttpError());
                }
                catch (MessageSentException mse) {
                    FFDCFilter.processException((Throwable)mse, (String)(this.getClass().getName() + ".error"), (String)"152");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"MessageSent error during ICL read error", (Object[])new Object[0]);
                    }
                    myLink.close(vc, ioe);
                }
            } else {
                myLink.close(vc, ioe);
            }
        }
    }
}

