/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.executor.impl.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class QueuedFuture<R>
implements Future<R>,
Runnable {
    private static final TraceComponent tc = Tr.register(QueuedFuture.class, (String)"FAULTTOLERANCE", (String)"com.ibm.ws.microprofile.faulttolerance.resources.FaultTolerance");
    private Callable<Future<R>> innerTask;
    private CompletableFuture<Future<R>> resultFuture;
    private Future<?> taskFuture;
    private ThreadContextDescriptor threadContext;
    private final AtomicInteger inProgressCounter;
    static final long serialVersionUID = 2010505866269785255L;

    public QueuedFuture(AtomicInteger inProgressCounter) {
        this.inProgressCounter = inProgressCounter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public boolean cancel(boolean mayInterruptIfRunning) {
        CompletableFuture<Future<R>> resultFuture = this.getResultFuture();
        boolean cancellationResult = resultFuture.cancel(false);
        if (cancellationResult) {
            this.getTaskFuture().cancel(mayInterruptIfRunning);
        } else if (resultFuture.isDone() && !resultFuture.isCancelled()) {
            try {
                Future innerFuture = (Future)resultFuture.get();
                cancellationResult = innerFuture.cancel(mayInterruptIfRunning);
            }
            catch (InterruptedException innerFuture) {
                void e;
                FFDCFilter.processException((Throwable)innerFuture, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.async.QueuedFuture", (String)"83", (Object)this, (Object[])new Object[]{mayInterruptIfRunning});
                throw new FaultToleranceException((Throwable)e);
            }
            catch (ExecutionException e) {
                cancellationResult = false;
            }
        }
        return cancellationResult;
    }

    public void abort(Throwable t) {
        boolean abortSuccessful = this.getResultFuture().completeExceptionally(t);
        if (abortSuccessful) {
            this.getTaskFuture().cancel(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public boolean isCancelled() {
        CompletableFuture<Future<R>> resultFuture = this.getResultFuture();
        if (resultFuture.isDone()) {
            if (resultFuture.isCancelled()) {
                return true;
            }
            try {
                Future innerFuture = (Future)resultFuture.get();
                return innerFuture.isCancelled();
            }
            catch (InterruptedException innerFuture) {
                void e;
                FFDCFilter.processException((Throwable)innerFuture, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.async.QueuedFuture", (String)"123", (Object)this, (Object[])new Object[0]);
                throw new FaultToleranceException((Throwable)e);
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public boolean isDone() {
        CompletableFuture<Future<R>> resultFuture = this.getResultFuture();
        if (resultFuture.isDone()) {
            if (resultFuture.isCancelled()) {
                return true;
            }
            try {
                Future innerFuture = (Future)resultFuture.get();
                return innerFuture.isDone();
            }
            catch (InterruptedException innerFuture) {
                void e;
                FFDCFilter.processException((Throwable)innerFuture, (String)"com.ibm.ws.microprofile.faulttolerance.executor.impl.async.QueuedFuture", (String)"149", (Object)this, (Object[])new Object[0]);
                throw new FaultToleranceException((Throwable)e);
            }
            catch (ExecutionException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public R get() throws InterruptedException, ExecutionException {
        R result = null;
        CompletableFuture<Future<R>> resultFuture = this.getResultFuture();
        try {
            result = (R)((Future)resultFuture.get()).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException) {
                throw new ExecutionException(e.getCause().getCause());
            }
            throw e;
        }
        return result;
    }

    @Override
    @FFDCIgnore(value={ExecutionException.class})
    public R get(long methodTimeout, TimeUnit methodUnit) throws InterruptedException, ExecutionException, TimeoutException {
        R result = null;
        CompletableFuture<Future<R>> resultFuture = this.getResultFuture();
        try {
            long start = System.nanoTime();
            long methodNanos = TimeUnit.NANOSECONDS.convert(methodTimeout, methodUnit);
            Future innerFuture = (Future)resultFuture.get(methodNanos, TimeUnit.NANOSECONDS);
            long middle = System.nanoTime();
            long diff = middle - start;
            long remaining = methodNanos - diff;
            result = (R)innerFuture.get(remaining, TimeUnit.NANOSECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException) {
                throw new ExecutionException(e.getCause().getCause());
            }
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FFDCIgnore(value={Throwable.class})
    public void run() {
        Future<R> result = null;
        Throwable thrownException = null;
        try {
            this.inProgressCounter.incrementAndGet();
            ArrayList contextAppliedToThread = null;
            if (this.threadContext != null) {
                contextAppliedToThread = this.threadContext.taskStarting();
            }
            try {
                result = this.innerTask.call();
            }
            finally {
                if (contextAppliedToThread != null) {
                    this.threadContext.taskStopping(contextAppliedToThread);
                }
            }
        }
        catch (Throwable e) {
            thrownException = e instanceof com.ibm.ws.microprofile.faulttolerance.spi.ExecutionException ? e.getCause() : e;
        }
        finally {
            this.inProgressCounter.decrementAndGet();
            if (thrownException == null) {
                this.resultFuture.complete(result);
            } else {
                this.resultFuture.completeExceptionally(thrownException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Future<R>> getResultFuture() {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            if (this.resultFuture == null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
        }
        return this.resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<?> getTaskFuture() {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            if (this.taskFuture == null) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"internal.error.CWMFT4999E", (Object[])new Object[0]));
            }
        }
        return this.taskFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ExecutorService executorService, Callable<Future<R>> innerTask, ThreadContextDescriptor threadContext) {
        QueuedFuture queuedFuture = this;
        synchronized (queuedFuture) {
            this.innerTask = innerTask;
            this.threadContext = threadContext;
            this.resultFuture = new CompletableFuture();
            this.taskFuture = executorService.submit(this);
        }
    }
}

