/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.AioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class AioTCPWriteRequestContextImpl
extends TCPWriteRequestContextImpl {
    private static final TraceComponent tc = Tr.register(AioTCPWriteRequestContextImpl.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private boolean immedTimeoutRequested = false;

    protected AioTCPWriteRequestContextImpl(TCPConnLink link) {
        super(link);
    }

    @Override
    public VirtualConnection processAsyncWriteRequest() {
        this.immedTimeoutRequested = false;
        IOException exThisTime = null;
        try {
            boolean complete = ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).writeAIO(this, this.isForceQueue(), this.getTimeoutInterval());
            if (complete) {
                return this.oTCPConnLink.getVirtualConnection();
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof AsyncTimeoutException) {
                exThisTime = new SocketTimeoutException(ioe.getMessage());
                exThisTime.initCause(ioe);
            }
            exThisTime = ioe;
        }
        if (exThisTime != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SocketIOChannel x = this.getTCPConnLink().getSocketIOChannel();
                Socket socket = null;
                SocketAddress la = null;
                String las = null;
                SocketAddress ra = null;
                String ras = null;
                if (x != null && (socket = x.getSocket()) != null) {
                    la = socket.getLocalSocketAddress();
                    if (la != null) {
                        las = la.toString();
                    }
                    if ((ra = socket.getRemoteSocketAddress()) != null) {
                        ras = ra.toString();
                    }
                }
                Tr.event((TraceComponent)tc, (String)("IOException while processing writeAsynch request local: " + las + " remote: " + ras), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Exception is: " + exThisTime), (Object[])new Object[0]);
            }
            this.getWriteCompletedCallback().error(this.getTCPConnLink().getVirtualConnection(), this, exThisTime);
        }
        return null;
    }

    @Override
    public long processSyncWriteRequest(long numBytes, int timeout) throws IOException {
        this.immedTimeoutRequested = false;
        this.setIOAmount(numBytes);
        this.setLastIOAmt(0L);
        this.setIODoneAmount(0L);
        this.setTimeoutTime(timeout);
        SocketIOChannel channel = this.oTCPConnLink.getSocketIOChannel();
        try {
            return ((AioSocketIOChannel)channel).writeAIOSync(this);
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException while processing sync write. request local: " + channel.getSocket().getLocalSocketAddress() + " remote: " + channel.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                Tr.event((TraceComponent)tc, (String)("Exception is: " + ioe), (Object[])new Object[0]);
            }
            throw ioe;
        }
    }

    protected boolean updateForAllData(long byteCount) {
        ByteBuffer[] buffers = this.getByteBufferArray();
        boolean allComplete = true;
        for (int i = 0; i < buffers.length && allComplete; ++i) {
            if (!buffers[i].hasRemaining()) continue;
            allComplete = false;
        }
        this.setLastIOAmt(byteCount);
        this.setIODoneAmount(this.getIODoneAmount() + byteCount);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            SocketIOChannel channel = this.getTCPConnLink().getSocketIOChannel();
            Tr.event((TraceComponent)tc, (String)("Wrote " + byteCount + "(" + this.getIODoneAmount() + ") bytes, " + this.getIOAmount() + " requested on local: " + channel.getSocket().getLocalSocketAddress() + " remote: " + channel.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
        }
        if (allComplete) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"write complete, at least minimum amount of data written", (Object[])new Object[0]);
            }
        } else {
            Tr.debug((TraceComponent)tc, (String)"write not complete, more data needs to be written", (Object[])new Object[0]);
        }
        return allComplete;
    }

    @Override
    protected void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"immediateTimeout", (Object[])new Object[0]);
        }
        this.immedTimeoutRequested = true;
        ((AioSocketIOChannel)this.getTCPConnLink().getSocketIOChannel()).timeoutWriteFuture();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"immediateTimeout");
        }
    }

    protected boolean isImmedTimeoutRequested() {
        return this.immedTimeoutRequested;
    }
}

