/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache.web;

import com.ibm.websphere.cache.DynamicCacheAccessor;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.config.CacheInstance;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.web.config.ConfigManager;
import com.ibm.wsspi.cache.Cache;
import com.ibm.wsspi.cache.ConfigEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CacheMonitor {
    public static final int CACHE_TYPE_JAXRPC = 1;
    public static final int NOT_SHARED = 1;
    public static final int SHARED_PULL = 3;
    public static final int SHARED_PUSH = 2;
    public static final int SHARED_PUSH_PULL = 4;
    public static final int HIGH = 3;
    public static final int BALANCED = 1;
    public static final int LOW = 0;
    public static final int CUSTOM = 2;
    public static final int EVICTION_RANDOM = 1;
    public static final int EVICTION_SIZE_BASED = 2;
    public static final int EVICTION_NONE = 0;
    public static final String DISKCACHE_MORE = "DISKCACHE_MORE";

    public static boolean isCachingEnabled() {
        return DynamicCacheAccessor.isCachingEnabled();
    }

    public static boolean isServletCachingEnabled() {
        return ServerCache.servletCacheEnabled;
    }

    public static boolean isObjectCachingEnabled() {
        return ServerCache.objectCacheEnabled;
    }

    public static Cache getCache(String instanceName) {
        DCache c = ServerCache.getCache((String)instanceName);
        if (c != null) {
            return new Cache((com.ibm.websphere.cache.Cache)c);
        }
        return null;
    }

    public static final ArrayList getConfiguredServletCacheInstanceNames() {
        ArrayList instanceNames = ServerCache.getServletCacheInstanceNames();
        if (instanceNames.contains("services/cache/basecache")) {
            instanceNames.remove("services/cache/basecache");
            instanceNames.add("baseCache");
        }
        return instanceNames;
    }

    public static final ArrayList getCacheInstanceNames() {
        Map map = ServerCache.getCacheInstances();
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry entry : map.entrySet()) {
            String instanceName = (String)entry.getKey();
            names.add(instanceName);
        }
        return names;
    }

    public static final ArrayList getPolicyServletCacheInstanceNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (CacheInstance ci : ConfigManager.getInstance().getCacheInstances()) {
            names.add(ci.name);
        }
        return names;
    }

    public static final ArrayList getConfigEntries(String instanceName) {
        ArrayList<ConfigEntry> ces = new ArrayList<ConfigEntry>();
        List configEntries = ConfigManager.getInstance().getCacheEntries(instanceName);
        for (int i = 0; i < configEntries.size(); ++i) {
            ConfigEntry ce = new ConfigEntry((com.ibm.ws.cache.config.ConfigEntry)configEntries.get(i));
            ces.add(ce);
        }
        return ces;
    }

    public static final ArrayList getConfigEntries() {
        ArrayList<ConfigEntry> ces = new ArrayList<ConfigEntry>();
        List configEntries = ConfigManager.getInstance().getEntries();
        for (int i = 0; i < configEntries.size(); ++i) {
            ConfigEntry ce = new ConfigEntry((com.ibm.ws.cache.config.ConfigEntry)configEntries.get(i));
            ces.add(ce);
        }
        return ces;
    }
}

