/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.TypeMappings;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DisplayNameBridge {
    private static final TraceComponent tc = Tr.register(DisplayNameBridge.class, (String)"registyUtil", (String)"com.ibm.ws.security.wim.registry.util.resources.RegistryUtilMessages");
    private TypeMappings propertyMap = null;
    private BridgeUtils mappingUtils = null;
    static final long serialVersionUID = 869303381677205174L;

    public DisplayNameBridge(BridgeUtils mappingUtil) {
        this.mappingUtils = mappingUtil;
        this.propertyMap = new TypeMappings(mappingUtil);
    }

    @FFDCIgnore(value={WIMException.class})
    public String getUserDisplayName(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        String returnValue = "";
        try {
            Root resultRoot;
            Context context;
            boolean allowDNAsPrincipalName;
            String outputAttrName;
            String inputAttrName;
            String id;
            String quote;
            Root root;
            IDAndRealm idAndRealm;
            block20: {
                List contexts;
                this.mappingUtils.validateId(inputUserSecurityName);
                idAndRealm = this.mappingUtils.separateIDAndRealm(inputUserSecurityName);
                root = this.mappingUtils.getWimService().createRootObject();
                if (idAndRealm.isRealmDefined()) {
                    this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
                }
                quote = "'";
                id = idAndRealm.getId();
                if (id.indexOf("'") != -1) {
                    quote = "\"";
                }
                inputAttrName = this.propertyMap.getInputUserSecurityName(idAndRealm.getRealm());
                inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, true);
                String outputAttrNameMod = outputAttrName = this.propertyMap.getOutputUserDisplayName(idAndRealm.getRealm());
                allowDNAsPrincipalName = this.mappingUtils.allowDNAsPrincipalName;
                if (allowDNAsPrincipalName && (contexts = root.getContexts()) != null) {
                    Context ctx = new Context();
                    ctx.setKey("allowDNPrincipalNameAsLiteral");
                    ctx.setValue((Object)allowDNAsPrincipalName);
                    contexts.add(ctx);
                }
                context = new Context();
                context.setKey("isURBridgeResult");
                context.setValue((Object)"false");
                root.getContexts().add(context);
                resultRoot = null;
                try {
                    if (outputAttrNameMod != null && outputAttrNameMod.equalsIgnoreCase("principalName")) {
                        outputAttrNameMod = "displayBridgePrincipalName";
                    }
                    resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrNameMod, this.mappingUtils);
                }
                catch (WIMException e) {
                    if (allowDNAsPrincipalName) break block20;
                    throw e;
                }
            }
            boolean foundInURBridge = false;
            if (resultRoot != null && !resultRoot.getEntities().isEmpty()) {
                List contexts = resultRoot.getContexts();
                for (Context ctx : contexts) {
                    String key = ctx.getKey();
                    if (key == null || !"isURBridgeResult".equals(key) || !"true".equalsIgnoreCase((String)ctx.getValue())) continue;
                    foundInURBridge = true;
                }
            }
            root.getContexts().clear();
            if (resultRoot != null && !resultRoot.getEntities().isEmpty() && (DisplayNameBridge.isDN(id) || foundInURBridge)) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl srchCtrl = new SearchControl();
                if (controls != null) {
                    controls.add(srchCtrl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    srchCtrl.getProperties().add(outputAttrName);
                }
                if (allowDNAsPrincipalName) {
                    inputAttrName = "principalName";
                }
                srchCtrl.setExpression("//entities[@xsi:type='LoginAccount' and " + inputAttrName + "=" + quote + id + quote + "]");
                context = new Context();
                context.set("key", (Object)"useUserFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputUserSecurityName)));
            }
            if (returnList.get(0) instanceof PersonAccount) {
                Object value;
                Object value2;
                String outputUserPrincipalAttr;
                String mappedProp;
                PersonAccount personAccount = (PersonAccount)returnList.get(0);
                returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((mappedProp = outputAttrName).equals("displayName") ? (personAccount.getDisplayName().size() == 0 ? "" : (String)personAccount.getDisplayName().get(0)) : (mappedProp.equals("principalName") && foundInURBridge ? (!this.mappingUtils.isIdentifierTypeProperty(outputUserPrincipalAttr = this.propertyMap.getOutputUserPrincipal(idAndRealm.getRealm())) ? ((value2 = personAccount.get(outputUserPrincipalAttr)) instanceof List ? BridgeUtils.getStringValue(((List)value2).get(0)) : BridgeUtils.getStringValue(value2)) : (String)personAccount.getIdentifier().get(outputUserPrincipalAttr)) : ((value = personAccount.get(mappedProp)) instanceof List ? BridgeUtils.getStringValue(((List)value).get(0)) : BridgeUtils.getStringValue(value)))) : BridgeUtils.getStringValue(personAccount.getIdentifier().get(outputAttrName));
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups will be returned for user because the entity was not of type \"PersonAccount\".", (Object[])new Object[]{returnList.get(0)});
            }
        }
        catch (WIMException toCatch) {
            BridgeUtils.handleExceptions((Exception)((Object)toCatch));
        }
        return returnValue;
    }

    @FFDCIgnore(value={WIMException.class})
    public String getGroupDisplayName(String inputGroupSecurityName) throws EntryNotFoundException, RegistryException {
        String returnValue = "";
        try {
            Object value;
            Root resultRoot;
            this.mappingUtils.validateId(inputGroupSecurityName);
            IDAndRealm idAndRealm = this.mappingUtils.separateIDAndRealm(inputGroupSecurityName);
            Root root = this.mappingUtils.getWimService().createRootObject();
            if (idAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(root, idAndRealm.getRealm());
            }
            String quote = "'";
            String id = idAndRealm.getId();
            if (id.indexOf("'") != -1) {
                quote = "\"";
            }
            String inputAttrName = this.propertyMap.getInputGroupSecurityName(idAndRealm.getRealm());
            inputAttrName = this.mappingUtils.getRealInputAttrName(inputAttrName, id, false);
            String outputAttrName = this.propertyMap.getOutputGroupDisplayName(idAndRealm.getRealm());
            String outputAttrNameMod = outputAttrName;
            if (outputAttrNameMod != null && outputAttrNameMod.equalsIgnoreCase("cn")) {
                outputAttrNameMod = "displayBridgeCN";
            }
            if ((resultRoot = this.mappingUtils.getEntityByIdentifier(root, inputAttrName, id, outputAttrNameMod, this.mappingUtils)) != null) {
                root = resultRoot;
            } else {
                List controls = root.getControls();
                SearchControl searchControl = new SearchControl();
                if (controls != null) {
                    controls.add(searchControl);
                }
                if (!this.mappingUtils.isIdentifierTypeProperty(outputAttrName)) {
                    searchControl.getProperties().add(outputAttrName);
                }
                searchControl.setExpression("//entities[@xsi:type='Group' and " + inputAttrName + "=" + quote + id + quote + "]");
                Context context = new Context();
                context.set("key", (Object)"useGroupFilterForSearch");
                context.set("value", (Object)id);
                root.getContexts().add(context);
                root = this.mappingUtils.getWimService().search(root);
            }
            List returnList = root.getEntities();
            if (returnList.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            if (returnList.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)inputGroupSecurityName)));
            }
            Entity group = (Entity)returnList.get(0);
            returnValue = !this.mappingUtils.isIdentifierTypeProperty(outputAttrName) ? ((value = group.get(outputAttrName)) instanceof List ? BridgeUtils.getStringValue(((List)value).get(0)) : BridgeUtils.getStringValue(value)) : BridgeUtils.getStringValue(group.getIdentifier().get(outputAttrName));
        }
        catch (WIMException toCatch) {
            BridgeUtils.handleExceptions((Exception)((Object)toCatch));
        }
        return returnValue;
    }

    @FFDCIgnore(value={InvalidNameException.class})
    public static boolean isDN(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        try {
            new LdapName(uniqueName);
            return true;
        }
        catch (InvalidNameException e) {
            return false;
        }
    }
}

