/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.cxf.microprofile.client.cdi.RestClientBean;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RestClientExtension
implements Extension {
    private Set<Class<?>> restClientClasses = new LinkedHashSet();
    private Set<Throwable> errors = new LinkedHashSet<Throwable>();
    static final long serialVersionUID = -7356801697631613885L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void findClients(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> pat) {
        Class restClient = pat.getAnnotatedType().getJavaClass();
        if (restClient.isInterface()) {
            this.restClientClasses.add(restClient);
            pat.veto();
        } else {
            this.errors.add(new IllegalArgumentException("The class " + restClient + " is not an interface"));
        }
    }

    public void registerClientBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        this.restClientClasses.stream().map(c -> new RestClientBean((Class<?>)c, beanManager)).forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
    }

    public void registerErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.errors.forEach(arg_0 -> ((AfterDeploymentValidation)afterDeploymentValidation).addDeploymentProblem(arg_0));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.microprofile.client.cdi.RestClientExtension", RestClientExtension.class, null, null);
    }
}

