/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.concurrent.atomic.AtomicReference;

@Trivial
public class LockFreeIndexedStack<E> {
    final AtomicReference<StackNode<E>> top = new AtomicReference<Object>(null);

    public StackNode<E> clean() {
        StackNode<E> oldTop;
        while (!this.top.compareAndSet(oldTop = this.top.get(), null)) {
        }
        return oldTop;
    }

    public E pop() {
        StackNode newTop;
        StackNode<E> oldTop;
        do {
            if ((oldTop = this.top.get()) != null) continue;
            return null;
        } while (!this.top.compareAndSet(oldTop, newTop = oldTop.next));
        return oldTop.data;
    }

    public E popWithLimit(int minSize) {
        StackNode newTop;
        StackNode<E> oldTop;
        do {
            if ((oldTop = this.top.get()) == null) {
                return null;
            }
            if (oldTop.index + 1 > minSize) continue;
            return null;
        } while (!this.top.compareAndSet(oldTop, newTop = oldTop.next));
        return oldTop.data;
    }

    public void push(E d) {
        StackNode<E> oldTop;
        StackNode<E> newTop = new StackNode<E>(d);
        do {
            oldTop = this.top.get();
            newTop.next = oldTop;
            newTop.index = oldTop != null ? oldTop.index + 1 : 0;
        } while (!this.top.compareAndSet(oldTop, newTop));
    }

    public boolean pushWithLimit(E d, int maxSize) {
        StackNode<E> oldTop;
        StackNode<E> newTop = new StackNode<E>(d);
        do {
            oldTop = this.top.get();
            newTop.next = oldTop;
            if (oldTop != null) {
                newTop.index = oldTop.index + 1;
                if (newTop.index < maxSize) continue;
                return false;
            }
            if (maxSize == 0) {
                return false;
            }
            newTop.index = 0;
        } while (!this.top.compareAndSet(oldTop, newTop));
        return true;
    }

    public boolean isEmpty() {
        return this.top.get() == null;
    }

    public int size() {
        StackNode<E> oldTop = this.top.get();
        if (oldTop == null) {
            return 0;
        }
        return oldTop.index + 1;
    }

    public E peek() {
        StackNode<E> oldTop = this.top.get();
        if (oldTop == null) {
            return null;
        }
        return oldTop.data;
    }

    public static class StackNode<E> {
        final E data;
        StackNode<E> next;
        int index;

        public StackNode(E d) {
            this.data = d;
        }

        public StackNode<E> getNext() {
            return this.next;
        }

        public E getValue() {
            return this.data;
        }
    }
}

